package org.eaglei.ui.gwt.search.results;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.SearchContext.SearchListener;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;

public class RequestSummaryPanel extends SimplePanel implements SearchListener {
    private Label summaryLabel = new Label();
    // Static list of institutions
    private Map<EIURI, String> mapInstURIToLabel = null;
    
    public RequestSummaryPanel() {
        setStyleName("requestSummaryPanel");
        add(summaryLabel);
        summaryLabel.setStyleName("requestSummaryLabel");
        
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            onResults(SearchContext.INSTANCE.getCurrentResults());
        } else if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            onRequestPending(SearchContext.INSTANCE.getCurrentRequest(), false);
        } else {
            setVisible(false);
        }
        SearchContext.INSTANCE.addListener(this);
        
        initInstitutionList();
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
        setVisible(false);
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        setVisible(false);
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        setVisible(false);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        EIEntity bindingEntity = results.getBindingEntity();
        SearchRequest request = results.getResultSet().getRequest();
        boolean needsComma = false;
        StringBuilder buf = new StringBuilder("Search results for:  ");
        if (mapInstURIToLabel != null && request.getInstitution() != null) {
            buf.append(mapInstURIToLabel.get(request.getInstitution()));
            needsComma = true;
        }
        if (bindingEntity != null) {
            if (needsComma) {
                buf.append(", ");
            }
            buf.append(bindingEntity.getLabel());
            needsComma = true;
        }
        if (request.getTerm() != null && request.getTerm().getQuery() != null) {
            if (needsComma) {
                buf.append(", ");
            }
            buf.append("\"");
            buf.append(request.getTerm().getQuery());
            buf.append("\"");
            needsComma = true;
        }
        summaryLabel.setText(buf.toString());
        setVisible(needsComma);
    }
    
    private void initInstitutionList() {
        SearchServiceRemoteAsync searchService = GWT.create(SearchServiceRemote.class);
        searchService.getInstitutions(new AsyncCallback<List<EIEntity>>() {
            
            @Override
            public void onSuccess(List<EIEntity> result) {
                mapInstURIToLabel = new HashMap<EIURI, String>(result.size()); 
                for (EIEntity entity : result) {
                    mapInstURIToLabel.put(entity.getURI(), entity.getLabel());
                }
            }
            
            @Override
            public void onFailure(Throwable caught) {
            }
        });
    }

}
