package org.eaglei.ui.gwt.search.results;

import org.eaglei.ui.gwt.LoginPanel;
import org.eaglei.ui.gwt.ApplicationContext.ApplicationPage;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.security.SessionContext.SessionListener;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

public class ResultsPageWrapper extends Composite  implements SessionListener, ApplicationPage {

    interface MyUiBinder extends UiBinder<Widget, ResultsPageWrapper> {
    }

    private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);
    
    @UiField ResultsPage resultsPage;
    @UiField LoginPanel loginPanel;

    public ResultsPageWrapper() {
        initWidget(uiBinder.createAndBindUi(this));
        
        loginPanel.loginBox.addStyleName("subPageLoginBox");
        loginPanel.loginGrayOut.setStyleName("subPageLoginGrayOut");
        	
        SessionContext.INSTANCE.addListener(this);
        // Initialize
        if (SessionContext.getSessionId() != null) {
            onLogIn();
        } else {
            onLogOut();
        }
    }

    @Override
    public Widget asWidget() {
         return this;
    }

    @Override
    public void setPageParams(String params) {
        resultsPage.setPageParams(params);
    }

    @Override
    public void onLogIn() {
        resultsPage.setVisible(true);
        loginPanel.setVisible(false);
    }

    @Override
    public void onLogOut() {
        resultsPage.setVisible(false);
        loginPanel.setVisible(true);
    }
}
