package org.eaglei.ui.gwt.search.sidebar;

import java.util.List;
import java.util.SortedSet;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.CountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchRequest.TypeBinding;
import org.eaglei.ui.gwt.search.SearchContext;

import com.google.gwt.user.client.History;

public abstract class AbstractClassCountNavigatorPanel extends AbstractCountNavigatorPanel {

    protected SearchRequest currentRequest;
    
    protected AbstractClassCountNavigatorPanel() {
        super();
    }
    
    public void setClassCountResult(ClassCountResult result) {
        currentRequest = result.getSearchRequest();
        displayResult(result);
    }
    
    private void displayResult(ClassCountResult c) {
        outer.clear();
        currentMargin = 5;
        // The All label
        if (c.getEntity() == null) {
            // Null entity indicates that the target of the
            // search was at the ALL level.
            // The All label is read-only
            currentMargin += MARGIN_INCREMENT;
            // //addLabel(createLabelString(getAllLinkLabel(), c.getClassCount().getCount()), false);
            //addLabel(getAllLinkLabel(), false);
        } else {
            // Non-null indicates that the target of
            // the search was a specific entity.
            // The All label is a link
            currentMargin += MARGIN_INCREMENT;
            // //addLink(createLabelString(getAllLinkLabel(), c.getClassCount().getCount()), null, false, true, false);
            addLink(getAllLinkLabel(), null, false, true, false);
        }
        // Super class list
        List<CountResult> superClassCounts = c.getSuperClassCounts();
        if (superClassCounts != null && superClassCounts.size() > 0) {
            for (CountResult superClass : superClassCounts) {
                // Supers
                currentMargin += MARGIN_INCREMENT;
                addAncestorLink(superClass);
            }
        }
        // The target class
        if (c.getEntity() != null) {
            currentMargin += MARGIN_INCREMENT;
            addLabel(c.getClassCount());
        }
        // Sub class list
        SortedSet<CountResult> subClassCounts = c.getSubClassCounts();
        if (subClassCounts != null && subClassCounts.size() > 0) {
	        currentMargin += MARGIN_INCREMENT;
	        for (CountResult child : subClassCounts) {
	            addSubClassLink(child);
	        }
        }
    }
    
    @Override
    protected void onEntityClick(final EIURI typeBindingURI) {
        SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
        SearchRequest newRequest;
        if (previousRequest != null) {
            // TODO: somewhat inefficient way to create a clone
            newRequest = new SearchRequest(previousRequest.toURLParams());
            newRequest.setStartIndex(0);
        } else {
            newRequest = new SearchRequest();
        }
        // Clears any current property filters
        if (typeBindingURI == null) {
            newRequest.setBinding(null);
        } else {
            newRequest.setBinding(new TypeBinding(typeBindingURI));
        }
        SearchContext.INSTANCE.search(newRequest);
    }

}
