package org.eaglei.ui.gwt.search.sidebar;

import java.util.SortedSet;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntConstants;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchRequest.ResourceProvider;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.SearchContext.SearchListener;
import org.eaglei.ui.gwt.search.results.PropertyFilter;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.sidebar.AbstractSidebarComponent;
import org.eaglei.ui.gwt.suggest.DataSuggestBox;
import org.eaglei.ui.gwt.suggest.DataSuggestOracle;
import org.eaglei.ui.gwt.suggest.AbstractSearchBox.SearchHandler;

public class ResourceProviderSidebarComponent extends AbstractSidebarComponent implements SearchListener {
    
    /*
    class InstitutionFilter extends AbstractInstitutionPropertyFilter {

        InstitutionFilter() {
            super();
        }
        
        protected String getDefaultItem() {
            return "Select an Institution";
        }
        
        protected void fetchInstitutionList() {
            dashboardService.getInstitutions(new AsyncCallback<List<EIEntity>>() {

                @Override
                public void onFailure(Throwable caught) {
                }

                @Override
                public void onSuccess(List<EIEntity> result) {
                    initInstitutionList(result);
                }
                
            });
        }
        
        protected void executeSearch() {
            if (getSelectedInstitution() == null) {
                return;
            }
            SearchRequest newRequest;
            // Don't preserve any other search parameters
            //if (currentRequest != null) {
            //    newRequest = new SearchRequest(currentRequest.toURLParams());
            //} else {
                newRequest = new SearchRequest();
            //}
            ResourceProvider location = newRequest.getLocation();
            if (location == null) {
                location = new ResourceProvider();
            }
            location.setInstitution(getSelectedInstitution());
            location.setURI(null);  // clear the uri setting
            newRequest.setLocation(location);
            History.newItem(newRequest.toURLParams());
        }
        
    }
    */
    
    static class LaboratorySuggestBox extends DataSuggestBox {

		public LaboratorySuggestBox(DataSuggestOracle oracle) {
			super(oracle);
		}
    	
		@Override
		public String getDefaultText() {
	        return "Resource Location Name";
		}

    }
    
    class LaboratoryFilter extends PropertyFilter {

        private DataSuggestOracle suggestOracle;
        private LaboratorySuggestBox suggestBox;
        //private EIURI currentInstitution;
        private EIURI currentLaboratory;
        
        LaboratoryFilter() {
            //super("Laboratory");
            super(null);
            suggestOracle = new DataSuggestOracle();
            suggestBox = new LaboratorySuggestBox(suggestOracle);
            add(suggestBox);
            
        	suggestOracle.setClass(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000001"));
        	suggestOracle.setProperty(EIOntConstants.PG_RELATED_RESOURCE_PROVIDER);
        	suggestBox.addSearchHandler(new SearchHandler() {

				@Override
				public void performSearch(String query, String uri) {
                    if (uri == null) {
                        currentLaboratory = null;
                        suggestBox.setDefaultText();
                    } else {
                        currentLaboratory = EIURI.create(uri);
                    }
		            SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
		            SearchRequest newRequest;
		            if (previousRequest != null) {
		                // TODO: somewhat inefficient way to create a clone
		                newRequest = new SearchRequest(previousRequest.toURLParams());
		                newRequest.setStartIndex(0);
		            } else {
		                newRequest = new SearchRequest();
		            }
		            onRequestCreate(newRequest);
		            SearchContext.INSTANCE.search(newRequest);
				}
        		
        	}, true, true);
        }
        
        public void setSearchRequest(SearchRequest request) {
        	//currentInstitution = request.getLocation().getInstitution();
        	//suggestOracle.setResourceProviderInstitution(currentInstitution);
        	if (request.getLocation() == null || request.getLocation().getURI() == null) {
        		suggestBox.setDefaultText();
        	} else {
        		// TODO probably should look up lab name, check if it's set
        	}
        }
        
        public void onRequestCreate(SearchRequest request) {
            if (currentLaboratory == null) {
                request.setLocation(null);
            } else {
                request.setLocation(new ResourceProvider(currentLaboratory, null, null));
            }
        }
    }

    //private InstitutionFilter institutionFilter;
    private LaboratoryFilter laboratoryFilter;
	//private SearchRequest currentRequest;

    public ResourceProviderSidebarComponent() {
        super("Resource Location");
        //institutionFilter = new InstitutionFilter();
        //main.add(institutionFilter);
        laboratoryFilter = new LaboratoryFilter();
        main.add(laboratoryFilter);
        
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            setSearchRequest(SearchContext.INSTANCE.getCurrentRequest());
        }
        
        SearchContext.INSTANCE.addListener(this);
    }
    
    public void setInstitutions(SortedSet<EIEntity> institutions) {
        
    }
    
    public void setSearchRequest(SearchRequest request) {
        //currentRequest = request;
        //EIURI institution = request.getLocation().getInstitution();
        //institutionFilter.setInstitution(institution);
        laboratoryFilter.setSearchRequest(request);
    }
    
    public void setRequestPending() {
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        laboratoryFilter.onRequestCreate(request);
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        setSearchRequest(request);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        setSearchRequest(results.getResultSet().getRequest());
    }

}
