package org.eaglei.ui.gwt.search.sidebar;

import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.SearchContext.SearchListener;
import org.eaglei.ui.gwt.search.results.PropertyFilter;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.security.SessionContext;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class ResourceSidebarComponent extends AbstractSidebarComponent implements SearchListener {
    
    class ResourceFilter extends PropertyFilter {

        private ResourceCountNavigatorPanel p;

        protected ResourceFilter() {
            super(null);
            p = new ResourceCountNavigatorPanel();
            add(p);
        }
        
        public void setClassCountResult(ClassCountResult c) {
            p.setClassCountResult(c);
        }
        
        public void setRequestPending() {
            p.setRequestPending();
        }
    }

    private static class ResourceCountNavigatorPanel extends AbstractClassCountNavigatorPanel {

        ResourceCountNavigatorPanel() {
			super();
		}

		@Override
        protected String getAllLinkLabel() {
            return "All Resources";
        }

    }

    private ResourceFilter resourceFilter;
    private ClassCountResult currentCountResult = null;

    public ResourceSidebarComponent() {
        super("Resource Type");
        resourceFilter = new ResourceFilter();
        main.add(resourceFilter);
        
        SearchContext.INSTANCE.addListener(this);
        // Initialize to any currently pending, or executed request.
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            getSearchCounts(SearchContext.INSTANCE.getCurrentRequest());
        }
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            onResults(SearchContext.INSTANCE.getCurrentResults());
        }
    }

    public void setClassCountResult(ClassCountResult c) {
        resourceFilter.setClassCountResult(c);
    }
    
    @Override
    public void onFailure(SearchRequest request, String message) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (!isAttached()) {
            return;
        }
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            // no-op on page requests.
            return;
        }
        getSearchCounts(request);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        if (results.getResultSet().getRequest().getDataset() != SearchRequest.DataSet.EI_RESOURCES) {
            // no-op
            return;
        }
        if (currentCountResult != null) {
            // The count response arrived before the result set.
            if (!results.getResultSet().getRequest().equals(currentCountResult.getSearchRequest())) {
                // Unexpected. Cached counts request doesn't match result set request.
                // Maybe a new result set is about to arrive?
                return;
            }
            setClassCountResult(currentCountResult);
        }
    }
    
    private void getSearchCounts(final SearchRequest searchRequest) {
        resourceFilter.setRequestPending();
        if (searchRequest == null) {
            return;
        }
        if (searchRequest.getDataset() != SearchRequest.DataSet.EI_RESOURCES) {
            return;
        }
        // Putting in deferred command to ensure that the result list request
        // gets executed first.  And the UI has a chance to go to display progress.
        DeferredCommand.addCommand(new Command() {

            @Override
            public void execute() {
                SearchContext.searchService.getResourceCounts(SessionContext.getSessionId(), searchRequest,
                        new AsyncCallback<ClassCountResult>() {

                            public void onFailure(Throwable caught) {
                                if (caught instanceof InvalidSessionIdException) {
                                    SessionContext.INSTANCE.logOut();
                                    return;
                                }
                            }

                            public void onSuccess(ClassCountResult result) {
                                if (SearchContext.INSTANCE.getCurrentRequest() == null
                                        || !SearchContext.INSTANCE.getCurrentRequest().equals(
                                                result.getSearchRequest())) {
                                    // Old request. no-op.
                                    return;
                                }
                                // Stash the current count response
                                currentCountResult = result;
                                if (SearchContext.INSTANCE.getCurrentResults() != null) {
                                    setClassCountResult(currentCountResult);
                                }
                            }

                        });
            }
            
        });
    }

}
