/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemote;
import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemoteAsync;

public class LoginPanel
extends Composite
implements SessionContext.SessionListener {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    public HTMLPanel loginBox;
    @UiField
    public HTMLPanel loginGrayOut;
    @UiField
    ListBox loginInstitutionList;
    @UiField
    TextBox loginUserText;
    @UiField
    PasswordTextBox loginPasswordText;
    @UiField
    Button loginButton;
    private List<EIEntity> listInstitutionEntities = null;

    public LoginPanel() {
        this.initWidget((Widget)binder.createAndBindUi(this));
        if (ApplicationContext.IS_INSTITUTION) {
            this.loginInstitutionList.setVisible(false);
        } else {
            this.initInstitutionList();
        }
        Image loginImage = new Image(ApplicationResources.INSTANCE.loginButton());
        loginImage.setWidth("104");
        loginImage.setHeight("32");
        this.loginUserText.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                if (LoginPanel.this.getDefaultUsernameText().equals(LoginPanel.this.loginUserText.getText())) {
                    LoginPanel.this.loginUserText.setText("");
                }
            }
        });
        this.loginPasswordText.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    LoginPanel.this.performLogin();
                }
            }
        });
        this.loginButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                LoginPanel.this.performLogin();
            }
        });
        SessionContext.INSTANCE.addListener(this);
        if (SessionContext.getSessionId() != null) {
            this.onLogIn();
        } else {
            this.onLogOut();
        }
    }

    private void initInstitutionList() {
        SecurityServiceRemoteAsync securityService = (SecurityServiceRemoteAsync)GWT.create(SecurityServiceRemote.class);
        securityService.getInstitutions(new AsyncCallback<List<EIEntity>>(){

            public void onSuccess(List<EIEntity> result) {
                LoginPanel.this.listInstitutionEntities = result;
                for (EIEntity institution : result) {
                    LoginPanel.this.loginInstitutionList.addItem(institution.getLabel());
                }
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    private void performLogin() {
        String user;
        String institutionId = null;
        if (!ApplicationContext.IS_INSTITUTION) {
            EIURI institutionURI = this.listInstitutionEntities.get(this.loginInstitutionList.getSelectedIndex()).getURI();
            institutionId = institutionURI.toString();
        }
        if ((user = this.loginUserText.getText()) == null || user.trim().length() == 0) {
            Window.alert((String)"A username is required");
            return;
        }
        String pass = this.loginPasswordText.getText();
        if (pass == null || pass.trim().length() == 0) {
            Window.alert((String)"A password is required");
            return;
        }
        SessionContext.INSTANCE.logIn(institutionId, user.trim(), pass.trim());
    }

    private void performLogout() {
        SessionContext.INSTANCE.logOut();
    }

    @Override
    public void onLogOut() {
        this.loginUserText.setText(this.getDefaultUsernameText());
        this.loginPasswordText.setText("");
    }

    private String getDefaultUsernameText() {
        return "Username";
    }

    @Override
    public void onLogIn() {
    }

    static interface Binder
    extends UiBinder<Widget, LoginPanel> {
    }
}

