/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.home.HomePageModule;
import org.eaglei.ui.gwt.instance.InstancePageModule;
import org.eaglei.ui.gwt.search.results.ResultsPageModule;
import org.eaglei.ui.gwt.security.SessionContext;

public class SearchApplicationContext {
    public static final String HOME_PAGE_TOKEN = "home/";
    public static final String RESULTS_PAGE_TOKEN = "results/";
    public static final String ADVANCED_PAGE_TOKEN = "adv/";
    public static final String INSTANCE_PAGE_TOKEN = "inst/";
    public static SearchApplicationContext INSTANCE;
    public static String CURRENT_PAGE_TOKEN;
    private SimplePanel mainPanel;
    private ApplicationContext.ApplicationPage homePagePanel;
    private ApplicationContext.ApplicationPage resultsPagePanel;
    private ApplicationContext.ApplicationPage instancePagePanel;

    public static void setHistory(String pageToken, String pageParams) {
        assert (pageToken != null);
        StringBuilder buf = new StringBuilder(pageToken);
        if (pageParams != null) {
            buf.append(pageParams);
        }
        History.newItem((String)buf.toString());
    }

    public static void createApplicationContext(boolean isInstitution) {
        ApplicationContext.createApplicationContext(isInstitution);
        INSTANCE = new SearchApplicationContext();
    }

    private SearchApplicationContext() {
        RootPanel mainSlot = RootPanel.get((String)"main_container");
        if (mainSlot == null) {
            mainSlot = RootPanel.get((String)"main_container_x");
        }
        if (mainSlot == null) {
            Window.alert((String)"Missing main body element");
            return;
        }
        this.mainPanel = new SimplePanel();
        mainSlot.add((Widget)this.mainPanel);
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String historyToken = (String)event.getValue();
                SearchApplicationContext.this.handleHistoryChanged(historyToken);
            }
        });
        SessionContext.INSTANCE.addListener(new SessionContext.SessionListener(){

            @Override
            public void onLogOut() {
                String initToken = History.getToken();
                SearchApplicationContext.this.handleHistoryChanged(initToken);
            }

            @Override
            public void onLogIn() {
                String initToken = History.getToken();
                SearchApplicationContext.this.handleHistoryChanged(initToken);
            }
        });
        String initToken = History.getToken();
        this.handleHistoryChanged(initToken);
    }

    private void handleHistoryChanged(String strToken) {
        if (strToken == null || strToken.length() == 0 || strToken.startsWith(HOME_PAGE_TOKEN)) {
            CURRENT_PAGE_TOKEN = HOME_PAGE_TOKEN;
            if (strToken == null || strToken.length() == 0) {
                Object pageParams = null;
            } else {
                String pageParams = strToken.substring(HOME_PAGE_TOKEN.length());
            }
            if (this.homePagePanel == null) {
                HomePageModule.createAsync(new HomePageModule.ModuleClient(){

                    @Override
                    public void onSuccess(ApplicationContext.ApplicationPage instance) {
                        SearchApplicationContext.this.homePagePanel = instance;
                        SearchApplicationContext.this.mainPanel.setWidget(SearchApplicationContext.this.homePagePanel.asWidget());
                    }

                    @Override
                    public void onUnavailable() {
                        Window.alert((String)"Error loading home page module.");
                    }
                });
            } else {
                this.mainPanel.setWidget(this.homePagePanel.asWidget());
            }
        } else if (strToken.startsWith(RESULTS_PAGE_TOKEN)) {
            CURRENT_PAGE_TOKEN = RESULTS_PAGE_TOKEN;
            final String pageParams = strToken.substring(RESULTS_PAGE_TOKEN.length());
            if (this.resultsPagePanel == null) {
                ResultsPageModule.createAsync(new ResultsPageModule.ModuleClient(){

                    @Override
                    public void onSuccess(ApplicationContext.ApplicationPage instance) {
                        SearchApplicationContext.this.resultsPagePanel = instance;
                        SearchApplicationContext.this.mainPanel.setWidget(SearchApplicationContext.this.resultsPagePanel.asWidget());
                        SearchApplicationContext.this.resultsPagePanel.setPageParams(pageParams);
                    }

                    @Override
                    public void onUnavailable() {
                        Window.alert((String)"Error loading results module.");
                    }
                });
            } else {
                this.mainPanel.setWidget(this.resultsPagePanel.asWidget());
                this.resultsPagePanel.setPageParams(pageParams);
            }
        } else if (strToken.startsWith(INSTANCE_PAGE_TOKEN)) {
            CURRENT_PAGE_TOKEN = INSTANCE_PAGE_TOKEN;
            final String pageParams = strToken.substring(INSTANCE_PAGE_TOKEN.length());
            if (this.instancePagePanel == null) {
                InstancePageModule.createAsync(new InstancePageModule.ModuleClient(){

                    @Override
                    public void onSuccess(ApplicationContext.ApplicationPage instance) {
                        SearchApplicationContext.this.instancePagePanel = instance;
                        SearchApplicationContext.this.mainPanel.setWidget(SearchApplicationContext.this.instancePagePanel.asWidget());
                        SearchApplicationContext.this.instancePagePanel.setPageParams(pageParams);
                    }

                    @Override
                    public void onUnavailable() {
                        Window.alert((String)"Error loading instance module.");
                    }
                });
            } else {
                this.mainPanel.setWidget(this.instancePagePanel.asWidget());
                this.instancePagePanel.setPageParams(pageParams);
            }
        }
    }
}

