/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.eaglei.model.EIEntity;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.results.NavBar;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;

public class ResourcesGrid
extends FlexTable
implements NavBar.NavListener {
    private static final int PAGE_SIZE = 10;
    private static final int HEADER_ROW = 0;
    private static final int STATUS_ROW = 1;
    private static final int PROGRESS_ROW = 2;
    private static final int FIRST_RESULT_ROW = 3;
    private final Map<SearchRequest.DataSet, DataSetRenderer> mapDSToRenderer = new HashMap<SearchRequest.DataSet, DataSetRenderer>();
    private ClientSearchResultSet currentResults;
    private DataSetRenderer currentRenderer;
    private final NavBar navBar;
    private Label status;

    public ResourcesGrid(NavBar navBar) {
        this.setStyleName("listGrid");
        this.navBar = navBar;
        navBar.addNavListnener(this);
        this.status = new Label();
        this.setWidget(1, 0, (Widget)this.status);
        this.setWidget(2, 0, (Widget)new Image(ApplicationResources.INSTANCE.loading()));
    }

    public ClientSearchResultSet getCurrentResults() {
        return this.currentResults;
    }

    public void addRenderer(DataSetRenderer renderer) {
        this.mapDSToRenderer.put(renderer.getDataset(), renderer);
    }

    public void displaySearchPending() {
        this.currentResults = null;
        HTMLTable.RowFormatter rf = this.getRowFormatter();
        this.navBar.setVisible(false);
        rf.setVisible(1, false);
        rf.setVisible(2, true);
        for (int i = this.getRowCount() - 1; i >= 3; --i) {
            this.removeRow(i);
        }
    }

    public void displayStatusMessage(String message) {
        this.status.setText(message);
        this.currentResults = null;
        HTMLTable.RowFormatter rf = this.getRowFormatter();
        this.navBar.setVisible(false);
        rf.setVisible(1, true);
        rf.setVisible(2, false);
        for (int i = this.getRowCount() - 1; i >= 3; --i) {
            this.removeRow(i);
        }
    }

    public void displaySearchResults(ClientSearchResultSet results) {
        if (results.getResultSet().getResults().size() == 0) {
            this.displayStatusMessage("No results found.");
            return;
        }
        HTMLTable.RowFormatter rf = this.getRowFormatter();
        if (this.currentRenderer == null || this.currentRenderer.getDataset() != results.getResultSet().getRequest().getDataset()) {
            this.currentRenderer = this.mapDSToRenderer.get(results.getResultSet().getRequest().getDataset());
            this.currentRenderer.displayHeaderRow();
        }
        this.currentResults = results;
        rf.setVisible(2, false);
        int count = results.getResultSet().getTotalCount();
        int max = results.getResultSet().getStartIndex() + 10;
        if (max > count) {
            max = count;
        }
        this.navBar.update(results.getResultSet().getStartIndex(), count, max);
        this.navBar.setVisible(true);
        rf.setVisible(1, false);
        int row = 3;
        SearchRequest.DataSet dataset = results.getResultSet().getRequest().getDataset();
        for (SearchResult result : results.getResultSet().getResults()) {
            this.currentRenderer.createInstanceRow(row++, dataset, result);
        }
    }

    @Override
    public void onPreviousPage() {
        int startIndex = this.currentResults.getResultSet().getStartIndex() - 10;
        assert (startIndex >= 0) : "paged beyond the start of the result list";
        this.executeNewPageSearch(startIndex);
    }

    @Override
    public void onNextPage() {
        int startIndex = this.currentResults.getResultSet().getStartIndex() + 10;
        assert (startIndex < this.currentResults.getResultSet().getTotalCount()) : "paged beyond the end of the result list";
        this.executeNewPageSearch(startIndex);
    }

    private void executeNewPageSearch(int startIndex) {
        SearchRequest newRequest = new SearchRequest();
        SearchRequest oldRequest = this.currentResults.getResultSet().getRequest();
        newRequest.setInstitution(oldRequest.getInstitution());
        newRequest.setTerm(oldRequest.getTerm());
        newRequest.setBinding(oldRequest.getBinding());
        newRequest.setStartIndex(startIndex);
        SearchContext.INSTANCE.search(newRequest);
    }

    public static class DataSetRenderer {
        protected String[] columnHeaderNames;
        protected SearchRequest.DataSet dataset;
        protected ResourcesGrid resultsTable;

        public DataSetRenderer(ResourcesGrid resultsTable, SearchRequest.DataSet dataset, String[] columnHeaderNames) {
            this.resultsTable = resultsTable;
            this.dataset = dataset;
            this.columnHeaderNames = columnHeaderNames;
        }

        public SearchRequest.DataSet getDataset() {
            return this.dataset;
        }

        public String[] getHeaderColumnNames() {
            return this.columnHeaderNames;
        }

        public void displayHeaderRow() {
            int col = 0;
            for (String colName : this.getHeaderColumnNames()) {
                this.resultsTable.getCellFormatter().setStyleName(0, col, "listGridHeader");
                this.resultsTable.setHTML(0, col++, "<b>" + colName + "</b>");
            }
        }

        public void createInstanceRow(int row, SearchRequest.DataSet dataset, SearchResult searchResult) {
            Anchor instanceLink;
            int col = 0;
            if (dataset == SearchRequest.DataSet.EI_RESOURCES) {
                instanceLink = new Hyperlink(searchResult.getEntity().getLabel(), "inst/uri=" + searchResult.getEntity().getURI().toString());
            } else {
                instanceLink = new Anchor(searchResult.getEntity().getLabel(), searchResult.getEntity().getURI().toString());
                instanceLink.setTarget("_blank");
            }
            HTML snippit = null;
            if (searchResult.getHighlight() != null) {
                snippit = new HTML(searchResult.getHighlight());
            }
            CellPanel cp = new CellPanel();
            cp.setContent((Widget)instanceLink, (Widget)snippit);
            this.resultsTable.setWidget(row, col++, (Widget)cp);
            Label typeLabel = new Label(searchResult.getType().getLabel());
            Label rootTypeLabel = null;
            EIEntity rootTypeEntity = this.resultsTable.currentResults.getMapURIToRootEntity().get(searchResult.getType().getURI());
            if (rootTypeEntity != null) {
                rootTypeLabel = new Label(rootTypeEntity.getLabel());
            }
            cp = new CellPanel();
            cp.setContent((Widget)typeLabel, (Widget)rootTypeLabel);
            if (rootTypeLabel != null) {
                rootTypeLabel.addStyleName("rootType");
            }
            this.resultsTable.setWidget(row, col++, (Widget)cp);
            EIEntity lab = searchResult.getLab();
            Hyperlink labLink = lab != null ? new Hyperlink(lab.getLabel(), "inst/uri=" + lab.getURI().toString()) : null;
            Label instLabel = new Label(searchResult.getInstitution().getLabel());
            cp = new CellPanel();
            if (ApplicationContext.IS_INSTITUTION) {
                if (labLink != null) {
                    cp.setContent((Widget)labLink, null);
                }
            } else {
                cp.setContent((Widget)instLabel, (Widget)labLink);
            }
            this.resultsTable.setWidget(row, col++, (Widget)cp);
        }
    }

    public static class CellPanel
    extends VerticalPanel {
        CellPanel() {
            this.setStyleName("resultsTableCell");
            this.setSpacing(0);
        }

        void setContent(Widget primary, Widget secondary) {
            this.clear();
            this.add(primary);
            primary.addStyleName("primary");
            if (secondary != null) {
                this.add(secondary);
                secondary.setStyleName("secondary");
            }
        }
    }
}

