/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.sidebar;

import java.util.List;
import java.util.SortedSet;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.CountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.sidebar.AbstractCountNavigatorPanel;

public abstract class AbstractClassCountNavigatorPanel
extends AbstractCountNavigatorPanel {
    protected SearchRequest currentRequest;

    protected AbstractClassCountNavigatorPanel() {
    }

    public void setClassCountResult(ClassCountResult result) {
        this.currentRequest = result.getSearchRequest();
        this.displayResult(result);
    }

    private void displayResult(ClassCountResult c) {
        SortedSet subClassCounts;
        this.outer.clear();
        this.currentMargin = 5;
        if (c.getEntity() == null) {
            this.currentMargin += 6;
        } else {
            this.currentMargin += 6;
            this.addLink(this.getAllLinkLabel(), null, false, true, false);
        }
        List superClassCounts = c.getSuperClassCounts();
        if (superClassCounts != null && superClassCounts.size() > 0) {
            for (CountResult superClass : superClassCounts) {
                this.currentMargin += 6;
                this.addAncestorLink(superClass);
            }
        }
        if (c.getEntity() != null) {
            this.currentMargin += 6;
            this.addLabel(c.getClassCount());
        }
        if ((subClassCounts = c.getSubClassCounts()) != null && subClassCounts.size() > 0) {
            this.currentMargin += 6;
            for (CountResult child : subClassCounts) {
                this.addSubClassLink(child);
            }
        }
    }

    @Override
    protected void onEntityClick(EIURI typeBindingURI) {
        SearchRequest newRequest;
        SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
        if (previousRequest != null) {
            newRequest = new SearchRequest(previousRequest.toURLParams());
            newRequest.setStartIndex(0);
        } else {
            newRequest = new SearchRequest();
        }
        if (typeBindingURI == null) {
            newRequest.setBinding(null);
        } else {
            newRequest.setBinding(new SearchRequest.TypeBinding(typeBindingURI));
        }
        SearchContext.INSTANCE.search(newRequest);
    }
}

