/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.home;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.suggest.client.AbstractSearchBox;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.LoginPanel;
import org.eaglei.ui.gwt.LogoutPanel;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.TermSuggestBox;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;
import org.eaglei.ui.gwt.security.SessionContext;

public class NewHomePage
extends Composite
implements SessionContext.SessionListener,
ApplicationContext.ApplicationPage {
    public static boolean HAS_INSTITUTION_SELECT;
    private static MyUiBinder uiBinder;
    @UiField
    TermSuggestBox termBox;
    @UiField
    ListBox institutionListBox;
    @UiField
    ListBox typeListBox;
    @UiField
    Image searchButton;
    @UiField
    LoginPanel loginPanel;
    @UiField
    LogoutPanel logoutPanel;
    private List<EIEntity> listInstitutionEntities = null;
    private List<EIClass> listTypeClasses = null;

    public NewHomePage() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.loginPanel.loginBox.addStyleName("homePageLoginBox");
        this.loginPanel.loginGrayOut.addStyleName("homePageLoginGrayOut");
        this.institutionListBox.setStylePrimaryName("searchboxInstitutionDropdown");
        if (HAS_INSTITUTION_SELECT) {
            this.initInstitutionList();
        } else {
            this.institutionListBox.setVisible(false);
        }
        SessionContext.INSTANCE.addListener(this);
        if (SessionContext.getSessionId() != null) {
            this.onLogIn();
        } else {
            this.onLogOut();
        }
        this.searchButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SearchRequest request = NewHomePage.this.getSearchRequest();
                NewHomePage.this.executeSearch(request);
            }
        });
        this.termBox.addSearchHandler(new AbstractSearchBox.SearchHandler(){

            public void performSearch(String query, String uri) {
                SearchRequest.Term term = new SearchRequest.Term(query, uri != null ? EIURI.create((String)uri) : null);
                SearchRequest request = NewHomePage.this.getSearchRequest(term);
                NewHomePage.this.executeSearch(request);
            }
        }, true, true);
        this.termBox.setDefaultText();
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                NewHomePage.this.initResourcesList();
            }
        });
    }

    @Override
    public Widget asWidget() {
        return this;
    }

    private void initInstitutionList() {
        this.institutionListBox.addItem("All Institutions");
        SearchServiceRemoteAsync searchService = (SearchServiceRemoteAsync)GWT.create(SearchServiceRemote.class);
        searchService.getInstitutions(new AsyncCallback<List<EIEntity>>(){

            public void onSuccess(List<EIEntity> result) {
                NewHomePage.this.listInstitutionEntities = result;
                for (EIEntity institution : result) {
                    NewHomePage.this.institutionListBox.addItem(institution.getLabel());
                }
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    @Override
    public void setPageParams(String params) {
    }

    private void initResourcesList() {
        this.typeListBox.addItem("All Resources");
        this.typeListBox.setStylePrimaryName("searchboxInstitutionDropdown");
        SearchContext.searchService.getTopLevelSearchCategories(new AsyncCallback<List<EIClass>>(){

            public void onSuccess(List<EIClass> result) {
                NewHomePage.this.listTypeClasses = result;
                for (EIClass rclass : NewHomePage.this.listTypeClasses) {
                    NewHomePage.this.typeListBox.addItem(rclass.getEntity().getLabel());
                }
                NewHomePage.this.typeListBox.setSelectedIndex(0);
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    private void executeSearch(SearchRequest request) {
        if (SessionContext.getSessionId() == null) {
            Window.alert((String)"Please login");
            return;
        }
        SearchContext.INSTANCE.search(request);
    }

    private SearchRequest getSearchRequest() {
        SearchRequest.Term term = null;
        String query = this.termBox.getText();
        if (query != null) {
            query.trim();
            if (query.length() > 0) {
                term = new SearchRequest.Term(query);
            }
        }
        return this.getSearchRequest(term);
    }

    private SearchRequest getSearchRequest(SearchRequest.Term term) {
        SearchRequest request = new SearchRequest();
        request.setTerm(term);
        if (this.institutionListBox != null && this.institutionListBox.getSelectedIndex() > 0) {
            EIURI institution = this.listInstitutionEntities.get(this.institutionListBox.getSelectedIndex() - 1).getURI();
            request.setInstitution(institution);
        }
        if (this.typeListBox != null && this.typeListBox.getSelectedIndex() > 0) {
            EIURI type = this.listTypeClasses.get(this.typeListBox.getSelectedIndex() - 1).getEntity().getURI();
            SearchRequest.TypeBinding binding = new SearchRequest.TypeBinding(type);
            request.setBinding(binding);
        }
        return request;
    }

    @Override
    public void onLogIn() {
        this.loginPanel.setVisible(false);
        this.logoutPanel.setVisible(true);
    }

    @Override
    public void onLogOut() {
        this.loginPanel.setVisible(true);
        this.logoutPanel.setVisible(false);
    }

    static {
        uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    }

    static interface MyUiBinder
    extends UiBinder<Widget, NewHomePage> {
    }
}

