package org.eaglei.ui.gwt;



import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.security.SessionContext.SessionListener;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

/**
 * The top panel, header logo, sign in, etc
 */
public class NewTopPanel extends Composite implements SessionListener  {

    interface Binder extends UiBinder<Widget, NewTopPanel> {
    }

    public static boolean HAS_INSTITUTION_SELECT;
    public static boolean IS_INSTITUION;
    
    private static final Binder binder = GWT.create(Binder.class);
    //@UiField
    Label welcomeLabel;
    //@UiField
    Anchor logoutAnchor;
    //@UiField
    //Label logoutSeparator;
    //@UiField
    UListElement loginList;
    @UiField
	Anchor homeLink;
	@UiField
	Image logo;
    //@UiField
    ListBox institutionListBox;
    //@UiField
    TextBox userTextBox;
    //@UiField
    PasswordTextBox passTextBox;
    @UiField
    SpanElement atLabel;
    //@UiField
    Button loginButton;
    @UiField
    Anchor helpLink;
	@UiField
	SpanElement institutionName;
    
    // Static list of institutions
    private List<EIEntity> listInstitutionEntities = null;
    boolean signedIn = false;

    public static String[] wfStates;
    
    public static Map<String,Boolean> accessMap = new HashMap<String,Boolean>(); 
    
    public NewTopPanel() {
        this(true);
        //helpLink.setHref(getHelpUrl());
    }
    
    private String getHelpUrl() {
        String url = GWT.getHostPageBaseURL();
        url = url.substring(0, url.length()-1); // strip last /
        url = url.substring(0, url.lastIndexOf('/'));  // strip module name
        url += "/help/eagle-i.htm";
        return url;
    }
    
    public NewTopPanel(boolean requiresLogin) {
        initWidget(binder.createAndBindUi(this));

        helpLink.addClickHandler(new ClickHandler() {

            public void onClick(final ClickEvent clickEvent) {
                Window.open(getHelpUrl(), "_blank", "height=" + (getHelpWindowHeight()) + ",width=" + getHelpWindowWidth() + ",left=" + (getHelpWindowLeft()) + ",top=0");
            }
        });
        
        if(IS_INSTITUION) {
	        final String shortName = InstanceWidgetUtils.getNodeNameFromURL();
	        logo.setUrl( "images/logo_" + shortName + ".png" );
	        institutionName.setInnerText( InstanceWidgetUtils.getUniversity( GWT.getHostPageBaseURL() ) );
	        atLabel.setInnerText( "at" );
	        homeLink.setHref("/institution");
        } else
        {
	        homeLink.setHref("/central");
        }
        /*`	`
        if (HAS_INSTITUTION_SELECT) {
            institutionListBox.setWidth("300px");
            initInstitutionList();
        } else {
            institutionListBox.setVisible(false);
        }

        helpLink.addClickHandler(new ClickHandler() {

            public void onClick(final ClickEvent clickEvent) {
                Window.open(getHelpUrl(), "_blank", "height=" + (getHelpWindowHeight()) + ",width=" + getHelpWindowWidth() + ",left=" + (getHelpWindowLeft()) + ",top=0");
            }
        });
        
        if (requiresLogin) {
            passTextBox.addKeyUpHandler(new KeyUpHandler() {
                @Override
                public void onKeyUp(KeyUpEvent event) {
                    if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
                        performLogin();
                    }
                }
            });
    
            loginButton.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    performLogin();
                }
            });
            
            logoutAnchor.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    if (signedIn) {
                       performLogout();
                    }
                }
            });
            
            SessionContext.INSTANCE.addListener(this);
            if (SessionContext.getSessionId() != null) {
                onLogIn();
            } else {
                onLogOut();
            }
        } else {
            welcomeLabel.setText("Welcome to eagle-i");  // TODO need way to hide separator
            logoutAnchor.setVisible(false);
            institutionListBox.setVisible(false);
            loginList.getStyle().setVisibility(Style.Visibility.HIDDEN);
        }
        */
    }

    private void performLogin() {
        String institutionId = null;
        if (HAS_INSTITUTION_SELECT) {
            EIURI institutionURI = listInstitutionEntities.get(institutionListBox.getSelectedIndex()).getURI();
            institutionId = institutionURI.toString();
        }
        
    	String user = userTextBox.getText();
        if (user == null || user.trim().length() == 0) {
            Window.alert("A username is required");
            return;
        } 
        String pass = passTextBox.getText();
        if (pass == null || pass.trim().length() == 0) {
            Window.alert("A password is required");
            return;
        }
        SessionContext.INSTANCE.logIn(institutionId, user.trim(), pass.trim());
    }
    
    private void performLogout() {
        SessionContext.INSTANCE.logOut();
	}

    @Override
    public void onLogOut() {
        welcomeLabel.setText("Please login");  
        logoutAnchor.setVisible(false);
        //logoutSeparator.setVisible(false);
        if (HAS_INSTITUTION_SELECT) {
            institutionListBox.setVisible(true);
        }
        loginList.getStyle().setVisibility(Style.Visibility.VISIBLE);
        signedIn = false;
        userTextBox.setText("");
        passTextBox.setText("");
    }

    @Override
    public void onLogIn() {
        welcomeLabel.setText("Welcome, "+SessionContext.getUserName());
        logoutAnchor.setVisible(true);
        //logoutSeparator.setVisible(true);
        //userURI.setText(text);
        if (HAS_INSTITUTION_SELECT) {
            institutionListBox.setVisible(false);
        }
        loginList.getStyle().setVisibility(Style.Visibility.HIDDEN);
        signedIn = true;
    }
    
    private void initInstitutionList() {
        SearchServiceRemoteAsync searchService = GWT.create(SearchServiceRemote.class);
        searchService.getInstitutions(new AsyncCallback<List<EIEntity>>() {
            
            @Override
            public void onSuccess(List<EIEntity> result) {
                listInstitutionEntities = result;
                for (EIEntity institution : result) {
                    institutionListBox.addItem(institution.getLabel());
                }
            }
            
            @Override
            public void onFailure(Throwable caught) {
            }
        });
    }

    private int getHelpWindowHeight() {
        return Window.getClientHeight() + Window.getClientHeight() / 12;
    }

    private int getHelpWindowWidth() {
        return 600;
    }

    private int getHelpWindowLeft() {
        return Window.getClientWidth() - getHelpWindowWidth();
    }
}
