package org.eaglei.ui.gwt.instance;

import org.eaglei.model.EIInstance;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;

public abstract class InstancePanel extends Composite {
	
	protected final FlowPanel outerFormPanel = new FlowPanel();
	//FIXME one level of nesting too much; remove formPanel
	protected FlowPanel formPanel = new FlowPanel();
	protected FlowPanel ontologyPanel = new FlowPanel();
	protected FlowPanel nonOntologyOuterPanel = new FlowPanel();
	protected EIInstance eiInstance;
	protected OntologyPropertiesRenderer ontologyPropRenderer;
	protected FlowPanel materializedPropertiesPanel = new FlowPanel();
	protected Renderer renderer;
	
	protected boolean shouldShowReadOnlyProperties = true; // TODO: We probably had this when we shared code with search. Can be removed completely.

	public InstancePanel(final EIInstance instance) {
		eiInstance = instance;
		initWidget(outerFormPanel);
		outerFormPanel.setStyleName("formPanel");
		formPanel.setStyleName("formPanel");
		ontologyPanel.setStyleName( "formPanel" );
		nonOntologyOuterPanel.setStyleName( "formPanelInside" );
		initializeSpecifics();
	}

	protected InstancePanel() {
		// NOTE: ONLY to be called by subclasses that need to set other instance variables before doing stuff
		initWidget(outerFormPanel);
		outerFormPanel.setStyleName("formPanel");
		formPanel.setStyleName("formPanel");
		ontologyPanel.setStyleName( "formPanel" );
		nonOntologyOuterPanel.setStyleName( "formPanelInside" );
	}
	
	

	protected void initializeSpecifics() {
		formPanel.add(ontologyPanel);
		formPanel.add(nonOntologyOuterPanel);
		outerFormPanel.add(formPanel);
		
	}

	public EIInstance getInstance() {
		return eiInstance;
	}

}