package org.eaglei.ui.gwt.search.sidebar;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.CountResult;
import org.eaglei.ui.gwt.ApplicationResources;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;

public abstract class AbstractCountNavigatorPanel extends Composite {

    protected static final int MARGIN_INCREMENT = 6; // 
    private static final String STANDARD_TEXT_INDENT = "-10px"; //
    private static final String ARROW_TEXT_INDENT = "-14px"; // extra indent for <
    
    protected final FlowPanel outer = new FlowPanel();
    protected int currentMargin;
    private Image loadingImage = new Image(ApplicationResources.INSTANCE.loadingSmall());
    
    protected AbstractCountNavigatorPanel() {
        super();
        initWidget(outer);
        setStyleName("resourceList");
//        setStyleName("navigator");
    }
    
    protected String createLabelString(String label, int count) {
        return label + " (" + count + ")";
    }
    
    protected String createLabelString(CountResult c) {
    	return createLabelString(c.getEntity().getLabel(), c.getCount());
    }
    
    protected UIObject addLabel(CountResult c) {
        UIObject ui = addLabel(createLabelString(c), false);
        ui.setTitle(c.getDefinition());
        return ui;
    }
    
    protected UIObject addLabel(String labelString, boolean isItalic) {
        Label l = new Label(labelString);
        DOM.setStyleAttribute(l.getElement(), "textIndent", STANDARD_TEXT_INDENT);
        DOM.setStyleAttribute(l.getElement(), "marginLeft", currentMargin+"px");
        DOM.setStyleAttribute(l.getElement(), "marginBottom", "1px");
        DOM.setStyleAttribute(l.getElement(), "fontWeight", "bold");
        if (isItalic) {
            DOM.setStyleAttribute(l.getElement(), "fontStyle", "italic");
        }
        outer.add(l);
        return l;
    }

    /*
     * Adds a link for an ancestor class of the search request type binding
     */
    protected UIObject addAncestorLink(CountResult c) {
        UIObject ui = addLink(c, true, false);
        return ui;
    }
    
    /*
     * Adds a link for a subclass of the search request type binding
     */
    protected UIObject addSubClassLink(CountResult c) {
        UIObject ui = addLink(c, false, c.hasSubEntity());
        return ui;
    }
    
    /*
     * Adds a link for a class
     */
    protected UIObject addLink(CountResult c, boolean displayArrow, boolean bold) {
        UIObject ui = addLink(createLabelString(c), c.getEntity().getURI(), false, displayArrow, bold);
        ui.setTitle(c.getDefinition());
        return ui;
    }
    
    protected Label addLink(final String labelString, final EIURI entityURI, boolean isInferred, boolean displayArrow, boolean bold) {
        final Label l;
        if (displayArrow) {
            l = new Label("< "+labelString);
            DOM.setStyleAttribute(l.getElement(), "textIndent", ARROW_TEXT_INDENT);
        } else {
            l = new Label(labelString);
            DOM.setStyleAttribute(l.getElement(), "textIndent", STANDARD_TEXT_INDENT);
        }
        DOM.setStyleAttribute(l.getElement(), "marginLeft", currentMargin+"px");
        DOM.setStyleAttribute(l.getElement(), "marginBottom", "1px");
        if (bold) {
            DOM.setStyleAttribute(l.getElement(), "fontWeight", "bold");
        }
        l.setStyleName("link");
        if (isInferred) {
        	l.addStyleDependentName("inferred");
        }
        l.addMouseOverHandler(new MouseOverHandler() {
            
            @Override
            public void onMouseOver(MouseOverEvent event) {
                l.addStyleDependentName("hovering");
            }
            
        });
        l.addMouseOutHandler(new MouseOutHandler() {
            
            @Override
            public void onMouseOut(MouseOutEvent event) {
                l.removeStyleDependentName("hovering");
            }
            
        });
        l.addClickHandler(new ClickHandler() {
            
            @Override
            public void onClick(ClickEvent event) {
                onEntityClick(entityURI);
            }
        });
        outer.add(l);
        return l;
    }
    
    protected abstract void onEntityClick(final EIURI entityURI);
    
    protected abstract String getAllLinkLabel();

    public void setRequestPending() {
        outer.clear();
        outer.add(loadingImage);
        DOM.setStyleAttribute(loadingImage.getElement(), "marginLeft", currentMargin+"px");
    }
    
    protected void removeLoading() {
        outer.remove(outer.getWidgetCount()-1);        
    }
    
}
