/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.logging.AsynchronousLoggerInstance;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.services.repository.RepositoryInstanceProvider;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.SecurityProvider;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.rpc.LoggedException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class InstanceServlet
extends RemoteServiceServlet
implements InstanceServiceRemote {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(InstanceServlet.class);
    private RepositoryInstanceProvider instanceProvider;
    private SecurityProvider securityProvider;
    protected static final String READ_VIEW = "user";
    private static EIOntModel ontModel;
    private AsynchronousLoggerInstance asyncLoggerInstance;
    private static final String INSTANCE_LOG_TABLE_NAME = "INSTANCE_SERVLET_LOG_TABLE";

    public void init() {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.instanceProvider = (RepositoryInstanceProvider)ctx.getBean(RepositoryInstanceProvider.class);
        this.securityProvider = (SecurityProvider)ctx.getBean("securityProvider", SecurityProvider.class);
        ontModel = (EIOntModel)ctx.getBean(EIOntModel.class);
        String buildID = "Unknown";
        InputStream inputStream = null;
        try {
            inputStream = ctx.getResource("/buildversion.properties").getInputStream();
            if (inputStream == null) {
                logger.debug((Object)"/buildversion.properties not found");
                inputStream = ctx.getResource("/institution/buildversion.properties").getInputStream();
                if (inputStream == null) {
                    logger.debug((Object)"/institution/buildversion.properties not found");
                    inputStream = ctx.getResource("/central/buildversion.properties").getInputStream();
                    if (inputStream == null) {
                        logger.debug((Object)"/central/buildversion.properties not found");
                    }
                }
            }
            if (inputStream != null) {
                Properties props = new Properties();
                props.load(inputStream);
                buildID = props.getProperty("buildversion", "Unknown");
            }
        }
        catch (IOException ioe) {
            logger.error((Object)"Failed to find buildversion.properties");
        }
        logger.debug((Object)("InstanceServlet: Context Display name = " + ctx.getDisplayName()));
        logger.debug((Object)("InstanceServlet: Context ID = " + ctx.getId()));
        if (ctx.getParent() == null) {
            logger.debug((Object)"InstanceServlet: Context Parent is null.");
        } else {
            logger.debug((Object)("InstanceServlet: Context Parent Display name = " + ctx.getParent().getDisplayName()));
        }
        if (ctx.getServletContext() == null) {
            logger.debug((Object)"InstanceServlet: ServletContext is null.");
        } else {
            logger.debug((Object)("InstanceServlet: ServletContext path = " + ctx.getServletContext().getContextPath()));
            logger.debug((Object)("InstanceServlet: ServletContext context name = " + ctx.getServletContext().getServletContextName()));
        }
        String ontologyVersion = ontModel.getVersion();
        this.asyncLoggerInstance = new AsynchronousLoggerInstance(INSTANCE_LOG_TABLE_NAME, buildID, ontologyVersion);
    }

    public void destroy() {
    }

    @Override
    public Map<EIURI, String> getToolTips(String sessionID, EIURI instanceID) throws InvalidSessionIdException, LoggedException {
        try {
            this.securityProvider.isValid(sessionID, true);
        }
        catch (RepositoryProviderException e) {
            throw new InvalidSessionIdException("Error validating session.", e);
        }
        try {
            return this.instanceProvider.getToolTips(sessionID, instanceID);
        }
        catch (Throwable t) {
            logger.error((Object)"Error getting tool tips", t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public EIInstance getEIInstance(String sessionID, EIURI instanceID) throws InvalidSessionIdException, LoggedException {
        try {
            this.securityProvider.isValid(sessionID, true);
        }
        catch (RepositoryProviderException e) {
            throw new InvalidSessionIdException("Error validating session.", e);
        }
        try {
            long start = System.currentTimeMillis();
            EIInstance result = this.instanceProvider.getEIInstance(sessionID, instanceID);
            long end = System.currentTimeMillis();
            this.asyncLoggerInstance.log(sessionID, this.securityProvider.getSession(sessionID).getUserName(), start, end, instanceID, result);
            return result;
        }
        catch (Throwable t) {
            logger.error((Object)"Error getting instance", t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public boolean contactMessage(String sessionID, EIURI instanceID, String label, boolean test_mode, String from_name, String from_email, String subject, String message) throws InvalidSessionIdException, LoggedException {
        try {
            this.securityProvider.isValid(sessionID, true);
        }
        catch (RepositoryProviderException e) {
            throw new InvalidSessionIdException("Error validating session.", e);
        }
        try {
            String client_ip = this.getThreadLocalRequest().getLocalAddr();
            return this.instanceProvider.contactMessage(sessionID, client_ip, instanceID, label, test_mode, from_name, from_email, subject, message);
        }
        catch (Throwable t) {
            logger.error((Object)"Error sending contact message", t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public EIInstance setReferencingResources(String sessionID, EIInstance instance) throws Exception {
        try {
            this.securityProvider.isValid(sessionID, true);
        }
        catch (RepositoryProviderException e) {
            throw new InvalidSessionIdException("Error validating session.", e);
        }
        try {
            return this.instanceProvider.setReferencingResources(sessionID, instance);
        }
        catch (Throwable t) {
            logger.error((Object)"Error setting Referencing resources", t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public List<EIInstanceMinimal> listReferencingResources(String sessionID, String userURI, EIURI resourceUri, AuthSearchRequest queryRequest, boolean strictOwnerFilter) throws Exception {
        try {
            this.securityProvider.isValid(sessionID, true);
        }
        catch (RepositoryProviderException e) {
            throw new InvalidSessionIdException("Error validating session.", e);
        }
        try {
            return this.instanceProvider.listReferencingResources(sessionID, userURI, resourceUri, queryRequest, strictOwnerFilter);
        }
        catch (Throwable t) {
            logger.error((Object)"Error listing Referencing resources", t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }
}

