/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.results.PropertyFilter;

public abstract class AbstractInstitutionPropertyFilter
extends PropertyFilter {
    private List<EIEntity> listInstitutionEntities = null;
    private ListBox institutionListBox = new ListBox();
    private EIURI currentInstitution;

    protected AbstractInstitutionPropertyFilter() {
        this("Institution");
    }

    protected AbstractInstitutionPropertyFilter(String label) {
        super(label);
        this.add((Widget)this.institutionListBox);
        this.institutionListBox.setStyleName("value");
        this.institutionListBox.addStyleName("valueListBox");
        this.institutionListBox.addItem(this.getDefaultItem());
        this.fetchInstitutionList();
        this.institutionListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                EIURI selectedInstitution = AbstractInstitutionPropertyFilter.this.institutionListBox.getSelectedIndex() > 0 ? ((EIEntity)AbstractInstitutionPropertyFilter.this.listInstitutionEntities.get(AbstractInstitutionPropertyFilter.this.institutionListBox.getSelectedIndex() - 1)).getURI() : null;
                if (selectedInstitution == null && AbstractInstitutionPropertyFilter.this.currentInstitution != null || !selectedInstitution.equals((Object)AbstractInstitutionPropertyFilter.this.currentInstitution)) {
                    AbstractInstitutionPropertyFilter.this.currentInstitution = selectedInstitution;
                    AbstractInstitutionPropertyFilter.this.executeSearch();
                }
            }
        });
    }

    protected String getDefaultItem() {
        return "All Institutions";
    }

    protected abstract void fetchInstitutionList();

    protected void initInstitutionList(List<EIEntity> result) {
        this.listInstitutionEntities = result;
        for (EIEntity institution : result) {
            this.institutionListBox.addItem(institution.getLabel());
        }
        this.setInstitution(this.currentInstitution);
    }

    public void setSearchRequest(SearchRequest request) {
        EIURI institution = request.getLocation() != null ? request.getLocation().getInstitution() : null;
        this.setInstitution(institution);
    }

    public void setInstitution(EIURI institution) {
        this.currentInstitution = institution;
        if (institution != null && this.listInstitutionEntities != null) {
            int i = 1;
            for (EIEntity inst : this.listInstitutionEntities) {
                if (inst.getURI().equals((Object)institution)) {
                    this.institutionListBox.setSelectedIndex(i);
                    return;
                }
                ++i;
            }
        }
        this.institutionListBox.setSelectedIndex(0);
    }

    public EIURI getSelectedInstitution() {
        return this.currentInstitution;
    }

    public void onRequestCreate(SearchRequest request) {
        if (!this.isAttached()) {
            return;
        }
        SearchRequest.ResourceProvider provider = request.getLocation();
        if (provider != null) {
            provider.setInstitution(this.currentInstitution);
        } else if (this.currentInstitution != null) {
            provider = new SearchRequest.ResourceProvider(null, null, this.currentInstitution);
            request.setLocation(provider);
        }
    }

    protected void executeSearch() {
        SearchRequest newRequest;
        SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
        if (previousRequest != null) {
            newRequest = new SearchRequest(previousRequest.toURLParams());
            newRequest.setStartIndex(0);
        } else {
            newRequest = new SearchRequest();
        }
        SearchRequest.ResourceProvider provider = new SearchRequest.ResourceProvider(null, null, this.currentInstitution);
        newRequest.setLocation(provider);
        SearchContext.INSTANCE.search(newRequest);
    }
}

