/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results.renderers;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.model.EIEntity;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.ui.gwt.search.results.grid.EagleIGridRow;
import org.eaglei.ui.gwt.search.results.grid.ResourcesGrid;
import org.eaglei.ui.gwt.search.results.renderers.DataSetRenderer;

public class EagleIDataSetRenderer
extends DataSetRenderer {
    public EagleIDataSetRenderer(ResourcesGrid resultsTable, SearchRequest.DataSet dataset) {
        this.resultsTable = resultsTable;
        this.dataset = dataset;
    }

    @Override
    public void createInstanceRow(int row, SearchRequest.DataSet dataset, SearchResult searchResult) {
        boolean col = false;
        Widget instanceLink = this.getResourceNameLink(searchResult);
        HTML snippit = (HTML)this.getSnippit(searchResult);
        Label typeLabel = new Label(searchResult.getType().getLabel());
        Label rootTypeLabel = this.getRootTypeLabel(searchResult);
        Hyperlink labLink = this.getLabLink(searchResult);
        Label instLabel = new Label(searchResult.getInstitution().getLabel());
        EagleIGridRow gridRow = new EagleIGridRow();
        gridRow.setResourceNameWidget(instanceLink);
        gridRow.setResourceSnippitWidget((Widget)snippit);
        gridRow.setResourceClassWidget((Widget)rootTypeLabel);
        gridRow.setResourceTypeWidget((Widget)typeLabel);
        gridRow.setResourceInstitutionWidget((Widget)instLabel);
        gridRow.setResourceLabWidget((Widget)labLink);
        this.resultsTable.addRow(gridRow);
    }

    private Hyperlink getLabLink(SearchResult searchResult) {
        EIEntity lab = searchResult.getProvider();
        Hyperlink labLink = lab != null ? new Hyperlink(lab.getLabel(), "inst/uri=" + lab.getURI().toString()) : new Hyperlink();
        return labLink;
    }

    private Label getRootTypeLabel(SearchResult searchResult) {
        Label rootTypeLabel = null;
        EIEntity rootTypeEntity = this.resultsTable.currentResults.getMapURIToRootEntity().get(searchResult.getType().getURI());
        if (rootTypeEntity != null) {
            rootTypeLabel = new Label(rootTypeEntity.getLabel());
        }
        if (rootTypeLabel != null) {
            rootTypeLabel.addStyleName("rootType");
        }
        return rootTypeLabel;
    }
}

