/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results.renderers;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.ui.gwt.search.results.grid.NIFGridRow;
import org.eaglei.ui.gwt.search.results.grid.ResourcesGrid;
import org.eaglei.ui.gwt.search.results.renderers.DataSetRenderer;

public class NIFDataSetRenderer
extends DataSetRenderer {
    private static final EIURI REPOSITORY_URI = EIURI.create((String)"repository");

    public NIFDataSetRenderer(ResourcesGrid resultsTable, SearchRequest.DataSet dataset) {
        this.resultsTable = resultsTable;
        this.dataset = dataset;
    }

    @Override
    public void createInstanceRow(int row, SearchRequest.DataSet dataset, SearchResult searchResult) {
        boolean col = false;
        Widget instanceLink = this.getResourceNameLink(searchResult);
        HTML snippit = (HTML)this.getSnippit(searchResult);
        Label typeLabel = new Label(searchResult.getType().getLabel());
        Set repoList = searchResult.getDataTypeProperty(REPOSITORY_URI);
        FlowPanel locationPanel = this.makeLabelFromSet(repoList);
        NIFGridRow gridRow = new NIFGridRow();
        gridRow.setResourceNameWidget(instanceLink);
        gridRow.setResourceSnippitWidget((Widget)snippit);
        gridRow.setResourceTypeWidget((Widget)typeLabel);
        gridRow.setResourceLocationWidget((Widget)locationPanel);
        this.resultsTable.addRow(gridRow);
    }

    @Override
    protected Widget getResourceNameLink(SearchResult searchResult) {
        return new HTML(searchResult.getURL());
    }
}

