/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.sidebar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.SortedSet;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.results.AbstractInstitutionPropertyFilter;
import org.eaglei.ui.gwt.search.results.PropertyFilter;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;
import org.eaglei.ui.gwt.search.sidebar.AbstractSidebarComponent;
import org.eaglei.ui.gwt.suggest.AbstractSearchBox;
import org.eaglei.ui.gwt.suggest.DataSuggestBox;
import org.eaglei.ui.gwt.suggest.DataSuggestOracle;

public class ResourceProviderSidebarComponent
extends AbstractSidebarComponent
implements SearchContext.SearchListener {
    private InstitutionFilter institutionFilter;

    public ResourceProviderSidebarComponent() {
        super("Resource Location");
        if (!ApplicationContext.IS_INSTITUTION) {
            this.institutionFilter = new InstitutionFilter();
            this.main.add((Widget)this.institutionFilter);
        }
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            this.setSearchRequest(SearchContext.INSTANCE.getCurrentRequest());
        }
        SearchContext.INSTANCE.addListener(this);
    }

    public void setInstitutions(SortedSet<EIEntity> institutions) {
    }

    public void setSearchRequest(SearchRequest request) {
        if (this.institutionFilter != null) {
            this.institutionFilter.setSearchRequest(request);
        }
    }

    public void setRequestPending() {
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (!this.isAttached()) {
            return;
        }
        if (this.institutionFilter != null) {
            this.institutionFilter.onRequestCreate(request);
        }
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        this.setSearchRequest(request);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        this.setSearchRequest(results.getResultSet().getRequest());
    }

    class LaboratoryFilter
    extends PropertyFilter {
        private DataSuggestOracle suggestOracle;
        private LaboratorySuggestBox suggestBox;
        private EIURI currentLaboratory;

        LaboratoryFilter() {
            super(null);
            CheckBox c = new CheckBox("Center");
            this.add((Widget)c);
            c.setStyleName("sidebarCheckbox");
            c = new CheckBox("Core Laboratory");
            this.add((Widget)c);
            c.setStyleName("sidebarCheckbox");
            c = new CheckBox("Technology Transfer Office");
            this.add((Widget)c);
            c.setStyleName("sidebarCheckbox");
            this.suggestOracle = new DataSuggestOracle();
            this.suggestBox = new LaboratorySuggestBox(this.suggestOracle);
            this.add((Widget)this.suggestBox);
            this.suggestOracle.setClass(EIURI.create((String)"http://purl.obolibrary.org/obo/ERO_0000001"));
            this.suggestOracle.setProperty("http://eagle-i.org/ont/app/1.0/PropertyGroup_RelatedResourceProvider");
            this.suggestBox.addSearchHandler(new AbstractSearchBox.SearchHandler(){

                @Override
                public void performSearch(String query, String uri) {
                    SearchRequest newRequest;
                    if (uri == null) {
                        LaboratoryFilter.this.currentLaboratory = null;
                        LaboratoryFilter.this.suggestBox.setDefaultText();
                    } else {
                        LaboratoryFilter.this.currentLaboratory = EIURI.create((String)uri);
                    }
                    SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
                    if (previousRequest != null) {
                        newRequest = new SearchRequest(previousRequest.toURLParams());
                        newRequest.setStartIndex(0);
                    } else {
                        newRequest = new SearchRequest();
                    }
                    LaboratoryFilter.this.onRequestCreate(newRequest);
                    SearchContext.INSTANCE.search(newRequest);
                }
            }, true, true);
        }

        public void setSearchRequest(SearchRequest request) {
            if (request.getLocation() == null || request.getLocation().getURI() == null) {
                this.suggestBox.setDefaultText();
            }
        }

        public void onRequestCreate(SearchRequest request) {
            if (this.currentLaboratory == null) {
                request.setLocation(null);
            } else {
                request.setLocation(new SearchRequest.ResourceProvider(this.currentLaboratory, null, null));
            }
        }
    }

    static class LaboratorySuggestBox
    extends DataSuggestBox {
        public LaboratorySuggestBox(DataSuggestOracle oracle) {
            super(oracle);
        }

        @Override
        public String getDefaultText() {
            return "Resource Location Name";
        }
    }

    class InstitutionFilter
    extends AbstractInstitutionPropertyFilter {
        InstitutionFilter() {
            super(null);
        }

        @Override
        protected String getDefaultItem() {
            return "Select an Institution";
        }

        @Override
        protected void fetchInstitutionList() {
            SearchServiceRemoteAsync searchService = (SearchServiceRemoteAsync)GWT.create(SearchServiceRemote.class);
            searchService.getInstitutions(new AsyncCallback<List<EIEntity>>(){

                public void onSuccess(List<EIEntity> result) {
                    InstitutionFilter.this.initInstitutionList(result);
                }

                public void onFailure(Throwable caught) {
                }
            });
        }
    }
}

