/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.sidebar;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.results.PropertyFilter;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.sidebar.AbstractClassCountNavigatorPanel;
import org.eaglei.ui.gwt.search.sidebar.AbstractSidebarComponent;
import org.eaglei.ui.gwt.security.SessionContext;

public class ResourceSidebarComponent
extends AbstractSidebarComponent
implements SearchContext.SearchListener {
    private ResourceFilter resourceFilter = new ResourceFilter();
    private ClassCountResult currentCountResult = null;

    public ResourceSidebarComponent() {
        super("Resource Type");
        this.main.add((Widget)this.resourceFilter);
        SearchContext.INSTANCE.addListener(this);
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            this.getSearchCounts(SearchContext.INSTANCE.getCurrentRequest());
        }
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            this.onResults(SearchContext.INSTANCE.getCurrentResults());
        }
    }

    public void setClassCountResult(ClassCountResult c) {
        this.resourceFilter.setClassCountResult(c);
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (!this.isAttached()) {
            return;
        }
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        this.getSearchCounts(request);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        if (results.getResultSet().getRequest().getDataset() != SearchRequest.DataSet.EI_RESOURCES) {
            return;
        }
        if (this.currentCountResult != null) {
            if (!results.getResultSet().getRequest().equals((Object)this.currentCountResult.getSearchRequest())) {
                return;
            }
            this.setClassCountResult(this.currentCountResult);
        }
    }

    private void getSearchCounts(final SearchRequest searchRequest) {
        this.resourceFilter.setRequestPending();
        if (searchRequest == null) {
            return;
        }
        if (searchRequest.getDataset() != SearchRequest.DataSet.EI_RESOURCES) {
            return;
        }
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                SearchContext.searchService.getResourceCounts(SessionContext.getSessionId(), searchRequest, new AsyncCallback<ClassCountResult>(){

                    public void onFailure(Throwable caught) {
                        if (caught instanceof InvalidSessionIdException) {
                            SessionContext.INSTANCE.logOut();
                            return;
                        }
                    }

                    public void onSuccess(ClassCountResult result) {
                        if (SearchContext.INSTANCE.getCurrentRequest() == null || !SearchContext.INSTANCE.getCurrentRequest().equals((Object)result.getSearchRequest())) {
                            return;
                        }
                        ResourceSidebarComponent.this.currentCountResult = result;
                        if (SearchContext.INSTANCE.getCurrentResults() != null) {
                            ResourceSidebarComponent.this.setClassCountResult(ResourceSidebarComponent.this.currentCountResult);
                        }
                    }
                });
            }
        });
    }

    private static class ResourceCountNavigatorPanel
    extends AbstractClassCountNavigatorPanel {
        ResourceCountNavigatorPanel() {
        }

        @Override
        protected String getAllLinkLabel() {
            return "All Resources";
        }
    }

    class ResourceFilter
    extends PropertyFilter {
        private ResourceCountNavigatorPanel p;

        protected ResourceFilter() {
            super(null);
            this.p = new ResourceCountNavigatorPanel();
            this.add((Widget)this.p);
        }

        public void setClassCountResult(ClassCountResult c) {
            this.p.setClassCountResult(c);
        }

        public void setRequestPending() {
            this.p.setRequestPending();
        }
    }
}

