package org.eaglei.ui.gwt;

import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.security.SessionContext.SessionListener;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;

public class LogoutPanel extends Composite implements SessionListener {

    private Label name;
    
    public LogoutPanel() {
        FlowPanel outer = new FlowPanel();
        initWidget(outer);
        
        Label welcome = new Label("Welcome ");
        outer.add(welcome);
        welcome.setStyleName("welcomeLabel");
        name = new Label();
        outer.add(name);
        name.setStyleName("nameLabel");
        final Label logout = new Label("Logout");
        outer.add(logout);
        logout.setStyleName("logoutButton");
        
        logout.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                SessionContext.INSTANCE.logOut();
            }
        });
        
        logout.addMouseOverHandler(new MouseOverHandler() {
            
            @Override
            public void onMouseOver(MouseOverEvent event) {
                logout.addStyleDependentName("hover");
            }
        });
        
        logout.addMouseOutHandler(new MouseOutHandler() {
            
            @Override
            public void onMouseOut(MouseOutEvent event) {
                logout.removeStyleDependentName("hover");
            }
        });
        
        SessionContext.INSTANCE.addListener(this);
        // Initialize
        if (SessionContext.getSessionId() != null) {
            onLogIn();
        } else {
            onLogOut();
        }
    }

    @Override
    public void onLogIn() {
        name.setText(SessionContext.getUserName());
    }

    @Override
    public void onLogOut() {
    }
    
}
