package org.eaglei.ui.gwt;

import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ModelService;
import org.eaglei.model.gwt.rpc.ModelServiceAsync;
import org.eaglei.model.gwt.rpc.ClientModelManager.VersionCallback;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class NewFooterPanel extends Composite {

    interface Binder extends UiBinder<Widget, NewFooterPanel> {
    }

    private static final Binder binder = GWT.create(Binder.class);

    @UiField
    HTML appVersionLabel;
    @UiField
    HTML ontVersionLabel;
    
    public NewFooterPanel() {
        this("");
    }
    
    public NewFooterPanel(String version) {
        initWidget(binder.createAndBindUi(this));
        appVersionLabel.setHTML(appVersionLabel.getText() + version);
        DeferredCommand.addCommand(new Command() {

            @Override
            public void execute() {
                ModelServiceAsync modelService = GWT.create(ModelService.class);
                modelService.getVersion(new AsyncCallback<String>() {

                    @Override
                    public void onFailure(Throwable caught) {
                        //Window.alert("Ontology Version: failure");
                    }

                    @Override
                    public void onSuccess(String result) {
                        if (result != null) {
                            ontVersionLabel.setText(ontVersionLabel.getText() + result);
                        }
                    }
                    
                });
            }
            
        });
    }
   
}
