package org.eaglei.ui.gwt.instance;

import org.eaglei.model.EIInstance;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;

public class ContactSidebarComponent extends Composite {
  
    FlowPanel outerPanel = new FlowPanel();
    
    private EIInstance currentInstance;

    public ContactSidebarComponent() {
        initWidget(outerPanel); 
        setStyleName("contactSidebarComponent");
        
    }

    public void setInstance(final EIInstance instance) {
        // TODO: not all instances will display a contact button
        this.currentInstance = instance;
        
        if (outerPanel.getWidgetCount() > 0) {
            return;
        }
        
        Button contactButton = new Button("Send Message To Resource Contact");
        outerPanel.add(contactButton);
        contactButton.setStyleName("contactButton");
        
        contactButton.addClickHandler(new ClickHandler() {
            
            @Override
            public void onClick(ClickEvent event) {
                ContactPanel popup = new ContactPanel(currentInstance);
                popup.showRelativeTo(ContactSidebarComponent.this);
            }
        });
    }
}
