package org.eaglei.ui.gwt.search;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.suggest.DataSuggestBox;
import org.eaglei.ui.gwt.suggest.DataSuggestOracle;
import org.eaglei.ui.gwt.suggest.AbstractSearchBox.SearchHandler;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;

public class SearchSidebarComponent extends Composite {

    FlowPanel outerPanel = new FlowPanel();
    private FlowPanel searchBarPanel = new FlowPanel();
    DataSuggestBox termBox;

    public SearchSidebarComponent() {
        initWidget(outerPanel);
        setStyleName("searchboxSidebarComponent");
        
        Label title = new Label("Search");
        outerPanel.add(title);
        title.setStyleName("title");
   
        outerPanel.add(searchBarPanel);

        DataSuggestOracle suggestOracle = new DataSuggestOracle();
        termBox = new DataSuggestBox(suggestOracle);
        searchBarPanel.add(termBox);
        termBox.addStyleName("search_widget");

        termBox.addSearchHandler(new SearchHandler() {
    
            @Override
            public void performSearch(String query, String uri) {
                SearchRequest.Term term = 
                    new SearchRequest.Term(query, (uri != null ? EIURI.create(uri) : null));
                SearchRequest request = getSearchRequest();
                SearchContext.INSTANCE.search(request);
            }
            
        }, true, true);
        termBox.setDefaultText();

    }
    
    @Override
    public void setWidth(String width) {
        super.setWidth(width);
        termBox.setWidth(width);
    }
    
    public void setDefaultText() {
        termBox.setDefaultText();
    }
    
    private SearchRequest getSearchRequest() {
        SearchRequest.Term term = null;
        String query = termBox.getText();
        if (query != null) {
            query.trim();
            if (query.length() > 0) {
                term = new SearchRequest.Term(query);
            }
        }
        
        SearchRequest request = new SearchRequest();
        request.setTerm(term);
        return request;
    }

}
