package org.eaglei.ui.gwt.suggest;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AutoSuggestConstants;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.URL;

public class DataSuggestOracle extends SearchSuggestOracle implements AutoSuggestConstants {
	
	private EIURI classURI;
	private EIURI rpInstitution;
	private String property;
	private String paramList;

	public DataSuggestOracle() {
		super(GWT.getModuleBaseURL() + "dataSuggest");
	}

    public void setClass(EIURI classURI) {
    	this.classURI = classURI;
		computeParamList() ;
    }

    public void setResourceProviderInstitution(EIURI rpInstitution) {
    	this.rpInstitution = rpInstitution;
		computeParamList() ;
    }

    public void setProperty(EIURI classURI, EIURI propertyURI) {
    	this.classURI = classURI;
    	this.property = propertyURI.toString();
		computeParamList() ;
    }

    public void setProperty(String property) {
    	this.property = property;
		computeParamList() ;
    }

    private void computeParamList() {
    	this.paramList = "";
    	if (rpInstitution != null) {
			paramList += "&" + RESOURCE_PROVIDER_INSTITUTION_PARAM + "=" + URL.encodeComponent(rpInstitution.toString());
    	}
    	if (classURI != null) {
			paramList += "&" + BINDING_TYPE_PARAM + "=" + URL.encodeComponent(classURI.toString());
    	}
    	if (property != null) {
			paramList += "&" + PROPERTY_PARAM + "=" + URL.encodeComponent(property);
    	}
    }

    protected String createURL(String callbackName, int id, String query) {
        String url = super.createURL(callbackName, id, query);
        if (paramList != null) {
            return url + paramList;
        } else {
            return url;
        }
    }
    
}
