package org.eaglei.ui.gwt.suggest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.user.client.ui.SuggestOracle;

/**
 * @author tbashor
 */
public class SearchSuggestOracle extends SuggestOracle {

    private static class SuggestCallback {
        Element scriptTag;  // script DOM element added page
        SuggestOracle.Request req;  // suggestbox request
        SuggestOracle.Callback callback;   // suggestbox callback
    }

    // Cache the callback information
    private HashMap<Integer, SuggestCallback> callbacks = new HashMap<Integer, SuggestCallback>();

    private int curIndex = 0;
    private final String urlSuggestServlet;
    private ArrayList<SearchSuggestion> curSuggestionList = null;

    public SearchSuggestOracle(String urlSuggestServlet) {
        this.urlSuggestServlet = urlSuggestServlet;
    }
    
    @Override
    public void requestSuggestions(Request request, Callback callback) {
        // Check the query str for special chars before bothering to hit the
        // server?
        String callbackName;
        while (true) {
            if (curIndex == Integer.MAX_VALUE) {
                curIndex = 0;
            }
            if (!callbacks.containsKey(new Integer(curIndex))) {
                // Get a uniqe id and create the cache entry
                SuggestCallback serverCallback = new SuggestCallback();
                serverCallback.callback = callback;
                serverCallback.req = request;
                callbacks.put(new Integer(curIndex), serverCallback);
                // Create the callback function and script element and add it to the document
                callbackName = "__search_suggest_callback" + curIndex;
                setup(this, callbackName);
                String url = createURL(callbackName, curIndex, request.getQuery());
                serverCallback.scriptTag = addScript(callbackName, url);

                curIndex++;
                return;
            }
            curIndex++;
        }
    }

    @Override
    public boolean isDisplayStringHTML() {
        return true;
    }

    /**
     * The server callback method
     * 
     * @param jso
     */
    public void handle(JavaScriptObject jso) {
        JSONObject jsonObj = new JSONObject(jso);
        try {
            String strID = jsonObj.get("id").isString().stringValue();
            Integer id;
            try {
                id = Integer.parseInt(strID);
            } catch (NumberFormatException ex) {
                System.out.println("ERROR: callback id not an integer: " + strID);
                System.out.println(jsonObj.toString());
                return;
            }
            SuggestCallback serverCallback = callbacks.remove(id);
            if (serverCallback == null) {
                System.out.println("ERROR: unrecognized suggest callback id: " + id);
                System.out.println(jsonObj.toString());
                return;
            }
            /*  Commenting out return of the user query input.
             *  It is only used for debugging, and putting user input
             *  into json is a potential security risk.
            String q = jsonObj.get("q").isString().stringValue();
            if (!serverCallback.req.getQuery().equals(q)) {
                System.out
                        .println("ERROR: request value in suggest callback response does not match for id: "
                                + id + "  is: (" + q + ") should be: (" + serverCallback.req.getQuery() + ")");
                System.out.println(jsonObj.toString());
                return;
            }
            */
            // Clean up the script tag that was created for the callback.
            removeScript(serverCallback.scriptTag);

            SuggestOracle.Response response = new SuggestOracle.Response();
            JSONArray jsonSuggestionArray = jsonObj.get("suggestions").isArray();
            ArrayList<SearchSuggestion> listSuggestion = new ArrayList<SearchSuggestion>();
            if (jsonSuggestionArray != null) {
                for (int i = 0; i < jsonSuggestionArray.size(); ) {
                    String displayString = jsonSuggestionArray.get(i++).isString().stringValue();
                    String replacementString = jsonSuggestionArray.get(i++).isString().stringValue();
                    String uriString = jsonSuggestionArray.get(i++).isString().stringValue();
                    String rootTypeString = jsonSuggestionArray.get(i++).isString().stringValue();
                    if (! "<none>".equals(rootTypeString)) {
                    	displayString = 
                    		"<table style=\"width:100%\"><tr><td>"+displayString+"</td><td style=\"text-align:right;vertical-align:middle;margin-left:10px;font-size:80%;font-style:italic;color:blue\">" + rootTypeString + "</td></tr></table>";
                    	//displayString += "<i style=\"font-size:90%;color:black\">" + rootTypeString + "</i>";
                    }
                    SearchSuggestion suggestion = new SearchSuggestion(displayString, replacementString, uriString, rootTypeString);
                    listSuggestion.add(suggestion);
                }
            }
            response.setSuggestions(listSuggestion);

            serverCallback.callback.onSuggestionsReady(serverCallback.req, response);
            
            this.curSuggestionList = listSuggestion;
        } catch (NullPointerException ex) {
            System.out.println("ERROR: NPE probably caused by unexpected JSON response format");
            System.out.println(jsonObj.toString());
            ex.printStackTrace();
        }
    }
    
    public List<SearchSuggestion> getCurrentSuggestionList() {
        return this.curSuggestionList;
    }

    protected String createURL(String callbackName, int id, String query) {
        // Needed to bracket the query with some delimiter, otherwise trailing whitespace gets lost.
        String encode = URL.encodeComponent(query);
        return urlSuggestServlet + "?callback=" + callbackName + "&id=" + id + "&q=\"" + encode + "\"";
    }

    /**
     * Adds the JSONP script to our widget so we can make XSS requests
     * 
     * 
     * @param uniqueId
     *            The unique id of the call
     * @param url
     *            The URL of our Request
     */
    public native Element addScript(String id, String url)
    /*-{
        var elem = document.createElement("script");
        elem.setAttribute("language", "JavaScript");
        elem.setAttribute("src", url);
        document.getElementsByTagName("body")[0].appendChild(elem);
        return elem;
    }-*/;

    public native void removeScript(Element elem)
    /*-{
        document.getElementsByTagName("body")[0].removeChild(elem);
    }-*/;

    /**
     * 
     * Sets up our Javascript cross site JSON call
     * 
     * @param model
     *            Handles our Cross Site JSON call
     * @param callback
     */
    public native static void setup(SearchSuggestOracle myClass, String callback)
    /*-{
        window[callback] = function(someData) 
        {
           myClass.@org.eaglei.ui.gwt.suggest.SearchSuggestOracle::handle(Lcom/google/gwt/core/client/JavaScriptObject;)(someData);
        }
    }-*/;

}
