/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.LogoutPanel;
import org.eaglei.ui.gwt.SearchInstancePanel;
import org.eaglei.ui.gwt.instance.InstanceChangeListener;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.sidebar.SideBar;

public class InstancePage
extends Composite
implements SessionContext.SessionListener,
ApplicationContext.ApplicationPage,
InstanceChangeListener {
    private static final String URI_KEY = "uri";
    private static final Logger log = Logger.getLogger("InstancePage");
    public static final InstanceServiceRemoteAsync instanceService = (InstanceServiceRemoteAsync)GWT.create(InstanceServiceRemote.class);
    private FlowPanel instancePanel;
    private SideBar sidebar = new SideBar();
    private EIURI instanceID;

    public InstancePage() {
        FlowPanel outer = new FlowPanel();
        this.initWidget((Widget)outer);
        LogoutPanel logoutPanel = new LogoutPanel();
        outer.add((Widget)logoutPanel);
        logoutPanel.setStyleName("searchPageLogoutBox");
        FlowPanel innerDiv = new FlowPanel();
        innerDiv.setStyleName("mainPanel");
        HorizontalPanel mainPanel = new HorizontalPanel();
        mainPanel.add((Widget)this.sidebar);
        DOM.setStyleAttribute((Element)DOM.getParent((Element)this.sidebar.getElement()), (String)"borderRight", (String)"1px solid #CCC");
        this.sidebar.getResultsPage().setVisible(false);
        this.sidebar.getInstancePage().setVisible(true);
        this.instancePanel = new FlowPanel();
        this.instancePanel.setStyleName("formPanel");
        mainPanel.add((Widget)this.instancePanel);
        innerDiv.add((Widget)mainPanel);
        outer.add((Widget)innerDiv);
        this.sidebar.getSearchbox().setWidth("180px");
        this.sidebar.getContact().setWidth("180px");
        this.sidebar.getReferences().setWidth("180px");
    }

    @Override
    public Widget asWidget() {
        return this;
    }

    @Override
    public void setPageParams(String params) {
        log.finer("setting page to " + params);
        this.sidebar.getSearchbox().setDefaultText();
        this.sidebar.getReferences().setReferences(null);
        String[] parts = params.split("=");
        if (parts.length != 2) {
            this.instancePanel.clear();
            this.instancePanel.add((Widget)new Label("Invalid URL, cannot display resource."));
        }
        if (!parts[0].equals(URI_KEY)) {
            this.instancePanel.clear();
            this.instancePanel.add((Widget)new Label("Invalid URL, cannot display resource."));
        }
        String uriStr = parts[1];
        this.instanceID = EIURI.create((String)uriStr);
        if (SessionContext.getSessionId() == null) {
            this.onLogOut();
            return;
        }
        this.displayContent(this);
    }

    private void displayContent(final InstanceChangeListener listener) {
        this.instancePanel.clear();
        this.instancePanel.add((Widget)new Image(ApplicationResources.INSTANCE.loading()));
        instanceService.getEIInstance(SessionContext.getSessionId(), this.instanceID, new AsyncCallback<EIInstance>(){

            public void onFailure(Throwable caught) {
                InstancePage.this.instancePanel.clear();
                if (caught instanceof InvalidSessionIdException) {
                    SessionContext.INSTANCE.logOut();
                } else {
                    InstancePage.this.instancePanel.add((Widget)new HTML(caught.getLocalizedMessage()));
                }
            }

            public void onSuccess(EIInstance instance) {
                if (!instance.getInstanceURI().equals((Object)InstancePage.this.instanceID)) {
                    return;
                }
                instanceService.setReferencingResources(SessionContext.getSessionId(), instance, new AsyncCallback<EIInstance>(){

                    public void onSuccess(EIInstance result) {
                        InstancePage.this.instancePanel.clear();
                        SearchInstancePanel propertiesPanel = new SearchInstancePanel(result, listener);
                        InstancePage.this.instancePanel.add((Widget)propertiesPanel);
                        HashMap<EIEntity, List<EIInstanceMinimal>> instanceTypeMap = new HashMap<EIEntity, List<EIInstanceMinimal>>();
                        for (EIInstanceMinimal eiInstanceMinimal : result.getReferencedByList()) {
                            List<EIInstanceMinimal> instanceList;
                            if (instanceTypeMap.containsKey(eiInstanceMinimal.getDataModelRootSuperClass())) {
                                instanceList = (List)instanceTypeMap.get(eiInstanceMinimal.getDataModelRootSuperClass());
                                if (instanceList == null) continue;
                                instanceList.add(eiInstanceMinimal);
                                continue;
                            }
                            instanceList = new ArrayList<EIInstanceMinimal>();
                            instanceList.add(eiInstanceMinimal);
                            instanceTypeMap.put(eiInstanceMinimal.getDataModelRootSuperClass(), instanceList);
                        }
                        InstancePage.this.sidebar.getReferences().setReferences(instanceTypeMap);
                    }

                    public void onFailure(Throwable caught) {
                    }
                });
                InstancePage.this.sidebar.getContact().setInstance(instance);
            }
        });
    }

    @Override
    public void onLogIn() {
        if (this.instanceID != null) {
            this.displayContent(this);
        }
    }

    @Override
    public void onLogOut() {
        this.instancePanel.clear();
        this.sidebar.getReferences().setReferences(null);
        this.instancePanel.add((Widget)new Label("Please login"));
    }

    @Override
    public void onInstanceChanged(EIURI instanceUri) {
        this.setPageParams("uri=" + instanceUri.toString());
    }
}

