/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.ui.gwt.instance.InstanceChangeListener;
import org.eaglei.ui.gwt.instance.MaterializedPropertyWidget;
import org.eaglei.ui.gwt.instance.Renderer;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;

public class MaterializedInversePropRenderer
implements Renderer {
    EIInstance eiInstance;
    FlowPanel materializedPropertiesPanel;
    private final InstanceChangeListener listener;
    private static final Logger log = Logger.getLogger("MaterializedInversePropertyRenderer");
    public static final InstanceServiceRemoteAsync instanceService = (InstanceServiceRemoteAsync)GWT.create(InstanceServiceRemote.class);

    public MaterializedInversePropRenderer(EIInstance eiInstance, FlowPanel materializedPropertiesPanel, InstanceChangeListener listener) {
        this.eiInstance = eiInstance;
        this.materializedPropertiesPanel = materializedPropertiesPanel;
        this.listener = listener;
        this.renderProperties();
    }

    @Override
    public void renderProperties() {
        this.drawMaterializedInverseProperties();
    }

    private void drawMaterializedInverseProperties() {
        Map materializedInverseProperties = this.eiInstance.getMaterializedInverseProperties();
        HashMap instanceTypeMap = new HashMap();
        for (EIEntity entity : materializedInverseProperties.keySet()) {
            log.finer("handling property " + entity.getLabel());
            List entityInverses = (List)materializedInverseProperties.get(entity);
            for (EIInstanceMinimal eiInstanceMinimal : entityInverses) {
                Set<EIInstanceMinimal> instanceList;
                log.finer("property " + entity.getLabel() + " had type " + eiInstanceMinimal.getDataModelRootSuperClass());
                if (instanceTypeMap.containsKey(eiInstanceMinimal.getDataModelRootSuperClass())) {
                    instanceList = (Set)instanceTypeMap.get(eiInstanceMinimal.getDataModelRootSuperClass());
                    if (instanceList == null) continue;
                    instanceList.add(eiInstanceMinimal);
                    continue;
                }
                instanceList = new HashSet<EIInstanceMinimal>();
                instanceList.add(eiInstanceMinimal);
                instanceTypeMap.put(eiInstanceMinimal.getDataModelRootSuperClass(), instanceList);
            }
        }
        ArrayList representedTypes = new ArrayList(instanceTypeMap.keySet());
        Collections.sort(representedTypes);
        for (EIEntity instanceType : representedTypes) {
            MaterializedPropertyWidget materializedPropertyWidget = new MaterializedPropertyWidget(this.eiInstance, instanceType, new ArrayList<EIInstanceMinimal>((Collection)instanceTypeMap.get(instanceType)), this.materializedPropertiesPanel, this.listener);
            this.materializedPropertiesPanel.add((Widget)materializedPropertyWidget);
        }
    }
}

