/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Logger;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.ui.gwt.UIConstants;
import org.eaglei.ui.gwt.instance.InstanceChangeListener;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.instance.widgets.EIInstancePreviewLink;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.SearchInstanceWidgetUtils;

public class MaterializedPropertyWidget
extends Composite {
    private FlowPanel mainPanel;
    List<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
    FlowPanel materializedPanel;
    EIInstance eiInstance;
    private final InstanceChangeListener listener;
    private static final Logger log = Logger.getLogger("MaterializedPropertyWidget");
    private int currentIndex;
    public static final InstanceServiceRemoteAsync instanceService = (InstanceServiceRemoteAsync)GWT.create(InstanceServiceRemote.class);
    private static final int INVERSE_PROPERTIES_COUNT = 10;

    public MaterializedPropertyWidget(EIInstance eiInstance, EIEntity propertyEntity, List<EIInstanceMinimal> eiInstanceMinimalList, FlowPanel mainPanel, InstanceChangeListener listener) {
        this.instanceList = eiInstanceMinimalList;
        this.mainPanel = mainPanel;
        this.materializedPanel = new FlowPanel();
        this.listener = listener;
        this.eiInstance = eiInstance;
        this.initWidget((Widget)this.materializedPanel);
        this.setup();
    }

    private void setup() {
        HashMap<EIEntity, List<EIInstanceMinimal>> instanceTypeMap = new HashMap<EIEntity, List<EIInstanceMinimal>>();
        for (EIInstanceMinimal eiInstanceMinimal : this.instanceList) {
            List<EIInstanceMinimal> instanceList;
            if (instanceTypeMap.containsKey(eiInstanceMinimal.getDataModelRootSuperClass())) {
                instanceList = (List)instanceTypeMap.get(eiInstanceMinimal.getDataModelRootSuperClass());
                if (instanceList == null) continue;
                instanceList.add(eiInstanceMinimal);
                continue;
            }
            instanceList = new ArrayList<EIInstanceMinimal>();
            instanceList.add(eiInstanceMinimal);
            instanceTypeMap.put(eiInstanceMinimal.getDataModelRootSuperClass(), instanceList);
        }
        for (EIEntity instanceType : instanceTypeMap.keySet()) {
            String label = UIConstants.topLevelTypePlurals.get(instanceType.getLabel());
            if (label == null) {
                log.warning("no plural for " + instanceType.getLabel());
                label = instanceType.getLabel();
            }
            DisclosurePanel typePanel = new DisclosurePanel(label);
            typePanel.setStyleName("inversePanel");
            FlowPanel innerPanel = new FlowPanel();
            this.materializedPanel.add((Widget)typePanel);
            List instanceList = (List)instanceTypeMap.get(instanceType);
            Collections.sort(instanceList, new Comparator<EIInstanceMinimal>(){

                @Override
                public int compare(EIInstanceMinimal instance1, EIInstanceMinimal instance2) {
                    return instance1.getInstanceLabel().compareToIgnoreCase(instance2.getInstanceLabel());
                }
            });
            List<EIInstanceMinimal> firstPageList = this.getFirstPage(instanceList);
            this.displayResults(firstPageList, innerPanel, instanceTypeMap, instanceType);
            typePanel.setContent((Widget)innerPanel);
        }
    }

    private void addNextLink(final Map<EIEntity, List<EIInstanceMinimal>> instanceTypeMap, final EIEntity instanceType, final FlowPanel innerPanel) {
        if (this.getCurrentIndex() < instanceTypeMap.get(instanceType).size()) {
            Image next = new Image("images/pagination-rightarrow.png");
            next.setStyleName("nextLink");
            innerPanel.add((Widget)next);
            next.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    List instanceList = (List)instanceTypeMap.get(instanceType);
                    List<EIInstanceMinimal> nextPageList = MaterializedPropertyWidget.this.getNextPage(instanceList);
                    MaterializedPropertyWidget.this.displayResults(nextPageList, innerPanel, instanceTypeMap, instanceType);
                }
            });
        } else {
            Image next = new Image("images/pagination-rightarrow-disabled.png");
            next.setStyleName("nextLink");
            innerPanel.add((Widget)next);
        }
    }

    private void addPrevLink(final Map<EIEntity, List<EIInstanceMinimal>> instanceTypeMap, final EIEntity instanceType, final FlowPanel innerPanel) {
        if (this.getCurrentIndex() > 10) {
            Image prev = new Image("images/pagination-leftarrow.png");
            prev.setStyleName("prevLink");
            innerPanel.add((Widget)prev);
            prev.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    List instanceList = (List)instanceTypeMap.get(instanceType);
                    List<EIInstanceMinimal> prevPageList = MaterializedPropertyWidget.this.getPrevPage(instanceList);
                    MaterializedPropertyWidget.this.displayResults(prevPageList, innerPanel, instanceTypeMap, instanceType);
                }
            });
        } else {
            Image prev = new Image("images/pagination-leftarrow-disabled.png");
            prev.setStyleName("prevLink");
            innerPanel.add((Widget)prev);
        }
    }

    private void displayResults(final List<EIInstanceMinimal> eiInstanceMinimalList, final FlowPanel innerPanel, final Map<EIEntity, List<EIInstanceMinimal>> instanceTypeMap, final EIEntity instanceType) {
        innerPanel.clear();
        ListIterator<EIInstanceMinimal> li = eiInstanceMinimalList.listIterator();
        while (li.hasNext()) {
            final EIInstanceMinimal instance = li.next();
            final int indx = li.nextIndex();
            ClientModelManager.INSTANCE.isModelClassURI(instance.getInstanceURI(), (AsyncCallback)new AsyncCallback<Boolean>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(Boolean result) {
                    if (result.booleanValue()) {
                        Label propertyValue = new Label(instance.getInstanceLabel());
                        innerPanel.add((Widget)propertyValue);
                    } else {
                        String displayValue = InstanceWidgetUtils.formatText(instance.getInstanceLabel());
                        EIInstancePreviewLink a = SearchInstanceWidgetUtils.createPreviewLink(displayValue, instanceService, instance.getEntity(), MaterializedPropertyWidget.this.listener);
                        innerPanel.add((Widget)a);
                    }
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            if (((List)instanceTypeMap.get(instanceType)).size() > 10 && indx == eiInstanceMinimalList.size()) {
                                MaterializedPropertyWidget.this.addPrevLink(instanceTypeMap, instanceType, innerPanel);
                                MaterializedPropertyWidget.this.addNextLink(instanceTypeMap, instanceType, innerPanel);
                            }
                        }
                    });
                }
            });
        }
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public List<EIInstanceMinimal> getFirstPage(List<EIInstanceMinimal> instanceMinimalList) {
        return this.iterateFrom(0, instanceMinimalList);
    }

    public List<EIInstanceMinimal> getNextPage(List<EIInstanceMinimal> instanceMinimalList) {
        return this.iterateFrom(this.getCurrentIndex(), instanceMinimalList);
    }

    public List<EIInstanceMinimal> getPrevPage(List<EIInstanceMinimal> instanceMinimalList) {
        int newStart = this.getCurrentIndex() - 10;
        if (this.getCurrentIndex() % 10 != 0) {
            newStart = this.getCurrentIndex() - this.getCurrentIndex() % 10;
        }
        return this.iterateFrom(newStart -= 10, instanceMinimalList);
    }

    private List<EIInstanceMinimal> iterateFrom(int startIndex, List<EIInstanceMinimal> instanceList) {
        int endIndex;
        int totalSize = instanceList.size();
        this.currentIndex = endIndex = startIndex + 10;
        if (endIndex > totalSize) {
            endIndex = totalSize;
            this.currentIndex = totalSize;
        }
        return instanceList.subList(startIndex, endIndex);
    }
}

