/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.ui.gwt.UIConstants;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public class ReferencedBySidebarComponent
extends Composite {
    protected FlowPanel outerPanel = new FlowPanel();
    protected FlowPanel linksPanel = new FlowPanel();

    public ReferencedBySidebarComponent() {
        this.initWidget((Widget)this.outerPanel);
        this.setStyleName("referencedBySidebarComponent");
        Label title = new Label("Related Resources");
        this.outerPanel.add((Widget)title);
        title.setStyleName("title");
        this.outerPanel.add((Widget)this.linksPanel);
        this.linksPanel.setStyleName("referencesPanel");
        this.setVisible(false);
    }

    public void setWidth(String width) {
        super.setWidth(width);
    }

    public void setReferences(Map<EIEntity, List<EIInstanceMinimal>> listReferences) {
        this.setVisible(false);
        if (listReferences == null || listReferences.size() == 0) {
            return;
        }
        this.linksPanel.clear();
        LinkedList<EIEntity> instanceTypes = new LinkedList<EIEntity>(listReferences.keySet());
        Collections.sort(instanceTypes);
        for (EIEntity instanceType : instanceTypes) {
            String rootTypeString = UIConstants.topLevelTypePlurals.containsKey(instanceType.getLabel()) ? UIConstants.topLevelTypePlurals.get(instanceType.getLabel()) : instanceType.getLabel();
            Label rootTypeLabel = new Label(rootTypeString);
            rootTypeLabel.setStyleName("relatedResourcesGroupTitle");
            this.linksPanel.add((Widget)rootTypeLabel);
            List<EIInstanceMinimal> references = listReferences.get(instanceType);
            Collections.sort(references);
            for (EIInstanceMinimal eiInstanceMinimal : references) {
                Hyperlink instanceLink = new Hyperlink(InstanceWidgetUtils.formatText(eiInstanceMinimal.getInstanceLabel()), "inst/uri=" + eiInstanceMinimal.getInstanceURI().toString());
                this.linksPanel.add((Widget)instanceLink);
                instanceLink.addStyleName("link");
            }
        }
        this.setVisible(true);
    }
}

