/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.ui.gwt.instance.EIEmbeddedResourceViewWidgetSearch;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.InstanceChangeListener;
import org.eaglei.ui.gwt.instance.OntologyPropertiesRenderer;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.instance.widgets.EIInstancePreviewLink;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;
import org.eaglei.ui.gwt.instance.widgets.SearchInstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.SearchLabelValuesWidget;
import org.eaglei.ui.gwt.security.SessionContext;

public class SearchOntologyPropViewRenderer
extends OntologyPropertiesRenderer {
    private static final String NO_INFORMATION_FOR_RESOURCE = "The resource has no information associated with it.";
    private final InstanceChangeListener listener;
    private static final Logger log = Logger.getLogger("SearchOntologyPropViewRenderer");
    Map<EIURI, String> mapTermToDefinition = new HashMap<EIURI, String>();
    public static final InstanceServiceRemoteAsync instanceService = (InstanceServiceRemoteAsync)GWT.create(InstanceServiceRemote.class);

    public SearchOntologyPropViewRenderer(EIInstance eiInstance, FlowPanel ontologyPanel, InstanceChangeListener listener) {
        super(eiInstance, ontologyPanel);
        this.listener = listener;
    }

    private void getTerms() {
        instanceService.getToolTips(SessionContext.getSessionId(), this.eiInstance.getInstanceURI(), new AsyncCallback<Map<EIURI, String>>(){

            public void onFailure(Throwable caught) {
                log.log(Level.INFO, "Error retrieving tool tips");
            }

            public void onSuccess(Map<EIURI, String> resultMap) {
                SearchOntologyPropViewRenderer.this.mapTermToDefinition = resultMap;
                SearchOntologyPropViewRenderer.this.finishSetup();
            }
        });
    }

    @Override
    protected void drawDataProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<String> propertyValues) {
        LabelValuesWidget widget = new LabelValuesWidget(propertyEntity, propertyDefinition, isRequired);
        this.ontologyPanel.add((Widget)widget);
        for (String value : propertyValues) {
            widget.add(this.handleReadOnlyTextProperty(value));
        }
    }

    @Override
    protected void drawObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues) {
        if (this.eiInstance.isPropertyValueAnEmbeddedInstance(propertyEntity)) {
            for (EIEntity propertyValue : propertyValues) {
                if (this.isObjectValueToIgnore(propertyValue)) continue;
                EIEmbeddedResourceViewWidgetSearch embeddedWidget = new EIEmbeddedResourceViewWidgetSearch(this.eiInstance.getEmbeddedInstance(propertyValue), propertyEntity, propertyDefinition, this.listener);
                this.ontologyPanel.add((Widget)embeddedWidget);
            }
        } else {
            if (propertyValues.size() == 0) {
                return;
            }
            final LabelValuesWidget widget = new LabelValuesWidget(propertyEntity, propertyDefinition, isRequired);
            boolean hadValue = false;
            for (final EIEntity propertyValue : propertyValues) {
                if (this.isObjectValueToIgnore(propertyValue)) continue;
                hadValue = true;
                final String displayValue = this.eiInstance.isPropertyValueAStub(propertyEntity, propertyValue) ? "* " + propertyValue.getLabel() : propertyValue.getLabel();
                ClientModelManager.INSTANCE.isModelClassURI(propertyValue.getURI(), (AsyncCallback)new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Boolean result) {
                        if (result.booleanValue()) {
                            HorizontalPanel valuePanel = new HorizontalPanel();
                            widget.add((Widget)valuePanel);
                            Label propertyValueLabel = new Label(displayValue);
                            valuePanel.add((Widget)propertyValueLabel);
                            if (SearchOntologyPropViewRenderer.this.mapTermToDefinition != null && !SearchOntologyPropViewRenderer.this.mapTermToDefinition.get(propertyValue.getURI()).equals("null") && !SearchOntologyPropViewRenderer.this.mapTermToDefinition.get(propertyValue.getURI()).equals("")) {
                                Image toolTipImage = new Image("images/information.png");
                                toolTipImage.setStyleName("iconInformation");
                                final DecoratedPopupPanel simplePopup = new DecoratedPopupPanel(true);
                                toolTipImage.addMouseOverHandler(new MouseOverHandler(){

                                    public void onMouseOver(MouseOverEvent event) {
                                        SearchOntologyPropViewRenderer.this.showToolTip(propertyValue, simplePopup, (GwtEvent)event);
                                    }
                                });
                                toolTipImage.addMouseOutHandler(new MouseOutHandler(){

                                    public void onMouseOut(MouseOutEvent event) {
                                        if (simplePopup.isShowing()) {
                                            simplePopup.hide();
                                        }
                                    }
                                });
                                valuePanel.add((Widget)toolTipImage);
                            }
                        } else {
                            EIInstancePreviewLink a = SearchInstanceWidgetUtils.createPreviewLink(displayValue, instanceService, propertyValue, SearchOntologyPropViewRenderer.this.listener);
                            widget.add((Widget)a);
                        }
                    }
                });
                if (!hadValue) continue;
                this.ontologyPanel.add((Widget)widget);
            }
        }
    }

    private void showToolTip(EIEntity propertyValue, DecoratedPopupPanel simplePopup, GwtEvent event) {
        simplePopup.setStyleName("fakeTooltip");
        simplePopup.setWidget((Widget)new HTML(this.mapTermToDefinition.get(propertyValue.getURI())));
        Widget source = (Widget)event.getSource();
        int left = source.getAbsoluteLeft() + 10;
        int top = source.getAbsoluteTop() + 10;
        simplePopup.setPopupPosition(left, top);
        if (!simplePopup.isShowing()) {
            simplePopup.show();
        }
    }

    private boolean isObjectValueToIgnore(EIEntity propertyValue) {
        return propertyValue == null || propertyValue == EIEntity.NULL_ENTITY || propertyValue.getLabel().equals(EIEntity.NULL_ENTITY.getLabel()) || propertyValue.getLabel().equals(propertyValue.getURI().toString());
    }

    protected Widget handleReadOnlyTextProperty(String value) {
        if (value.startsWith("www") || value.startsWith("http")) {
            return new Anchor(InstanceWidgetUtils.formatText(value), InstanceWidgetUtils.formatText(value), "_blank");
        }
        HTML valueField = new HTML(InstanceWidgetUtils.formatText(InstanceWidgetUtils.insertBreaks(value)));
        valueField.setStyleName("formLabelValue");
        return valueField;
    }

    @Override
    public Collection<EIEntity> getDataTypeEntities() {
        return this.eiInstance.getDatatypeProperties().keySet();
    }

    @Override
    public Collection<EIEntity> getObjectTypeEntities() {
        return this.eiInstance.getObjectProperties().keySet();
    }

    @Override
    public void addFormTitle(String type) {
        if (this.eiInstance.isEmbeddedInstance()) {
            return;
        }
        HTML stubsMessage = null;
        if (this.eiInstance.hasStubs()) {
            stubsMessage = new HTML("* This resource links to unfinished resources.");
        } else if (this.eiInstance.isStub()) {
            stubsMessage = new HTML("This resource is unfinished. Please review and save.");
        }
        if (stubsMessage != null) {
            stubsMessage.setStyleName("StubMessage");
            this.ontologyPanel.add((Widget)stubsMessage);
        }
        String shortName = InstanceWidgetUtils.getNodeNameFromURL(this.eiInstance.getInstanceURI().toString());
        String university = InstanceWidgetUtils.getUniversity(this.eiInstance.getInstanceURI().toString());
        log.fine("short name = " + shortName + "; university = " + university + "; logo = " + "images/logo_" + shortName + "-small.png");
        if (university != null) {
            FlowPanel logoPanel = new FlowPanel();
            logoPanel.setStyleName("logoPanel");
            Image logo = new Image();
            logo.setUrl("images/logo_" + shortName + "-small.png");
            logo.setStyleName("logoPanelLogoImage");
            logoPanel.add((Widget)logo);
            HTML universityName = new HTML(university);
            universityName.setStyleName("logoPanelSchoolName");
            logoPanel.add((Widget)universityName);
            this.ontologyPanel.add((Widget)logoPanel);
        }
    }

    @Override
    public void fetchConstants() {
        if (this.eiInstance.hasEmbeddedInstances()) {
            ClientModelManager.INSTANCE.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_embedded_class", new ClientModelManager.ClassesInGroupCallback(){

                public void onSuccess(List<EIClass> result) {
                    SearchOntologyPropViewRenderer.this.getTerms();
                }
            });
        } else {
            this.getTerms();
        }
    }

    @Override
    protected void addNameProperty(String labelPrefix) {
        if (this.eiInstance.isEmbeddedInstance()) {
            EIEntity namePropEntity = EIEntity.create((EIURI)EagleIEntityConstants.RDFS_LABEL_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel(labelPrefix, EagleIEntityConstants.RDFS_LABEL_ENTITY.getLabel(), true));
            this.drawDataProperty(namePropEntity, "", true, this.makeSetFromSingle(this.eiInstance.getInstanceLabel()));
        } else {
            SearchLabelValuesWidget searchLabelWidget = new SearchLabelValuesWidget(this.ontologyPanel);
            searchLabelWidget.add(this.eiInstance.getInstanceLabel(), "instanceTitle", "");
        }
    }

    @Override
    protected void addTypeProperty(String labelPrefix) {
        if (this.eiInstance.isEmbeddedInstance()) {
            EIEntity typePropEntity = EIEntity.create((EIURI)EagleIEntityConstants.RDF_TYPE_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel(labelPrefix, EagleIEntityConstants.RDF_TYPE_ENTITY.getLabel(), true));
            this.drawObjectProperty(typePropEntity, "", true, this.makeSetFromSingleEntity(this.eiInstance.getInstanceType()));
        } else {
            SearchLabelValuesWidget searchLabelWidget = new SearchLabelValuesWidget(this.ontologyPanel);
            String title = this.mapTermToDefinition == null ? "" : this.mapTermToDefinition.get(this.eiInstance.getInstanceType().getURI());
            searchLabelWidget.add(this.eiInstance.getInstanceType().getLabel(), "instanceType", title);
        }
    }
}

