/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance.widgets;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eaglei.model.EIEntity;
import org.eaglei.model.SearchEIInstancePreview;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.instance.widgets.EIInstancePreviewPopup;
import org.eaglei.ui.gwt.security.SessionContext;

public class EIInstancePreviewLink
extends Anchor {
    private EIInstancePreviewPopup popup;
    private final InstanceServiceRemoteAsync instanceService;
    private final Logger log = Logger.getLogger("EIInstancePreviewLink");
    private boolean mouseOver = false;

    public EIInstancePreviewLink(String text, InstanceServiceRemoteAsync service, EIEntity propertyValue) {
        super(text, true);
        this.instanceService = service;
        this.addMouseOverHandler(new EIInstancePreviewMouseOverHandler(propertyValue));
        this.addMouseOutHandler(new EIInstancePreviewMouseOutHandler());
        this.addClickHandler(new EIPreviewPopUpClickHandler());
        this.addKeyDownHandler(new EIFocusKeyHandler());
    }

    private class EIPreviewPopUpClickHandler
    implements ClickHandler {
        private EIPreviewPopUpClickHandler() {
        }

        public void onClick(ClickEvent event) {
            EIInstancePreviewLink.this.mouseOver = false;
            if (EIInstancePreviewLink.this.popup != null) {
                EIInstancePreviewLink.this.popup.hide();
            }
        }
    }

    private class EIFocusKeyHandler
    implements KeyDownHandler {
        private EIFocusKeyHandler() {
        }

        public void onKeyDown(KeyDownEvent event) {
            if (event.getNativeKeyCode() == 113 && EIInstancePreviewLink.this.mouseOver && EIInstancePreviewLink.this.popup != null) {
                EIInstancePreviewLink.this.popup.switchFocusMode(true);
            }
        }
    }

    private class EIPreviewPopupCallback
    implements AsyncCallback<SearchEIInstancePreview> {
        private EIPreviewPopupCallback() {
        }

        public void onFailure(Throwable caught) {
            EIInstancePreviewLink.this.log.log(Level.SEVERE, "Unable to retrieve instance preview from callback.", caught);
        }

        public void onSuccess(SearchEIInstancePreview result) {
            EIInstancePreviewLink.this.popup = new EIInstancePreviewPopup(result);
            if (EIInstancePreviewLink.this.mouseOver) {
                int left = EIInstancePreviewLink.this.getAbsoluteLeft();
                int top = EIInstancePreviewLink.this.getAbsoluteTop() + EIInstancePreviewLink.this.getOffsetHeight() + 5;
                EIInstancePreviewLink.this.popup.setPopupPosition(left, top);
                EIInstancePreviewLink.this.popup.show();
            }
            EIInstancePreviewLink.this.log.info("Retrieved instance preview from callback with " + result.getPropertyCount() + " properties.");
        }
    }

    private class EIInstancePreviewMouseOutHandler
    implements MouseOutHandler {
        private EIInstancePreviewMouseOutHandler() {
        }

        public void onMouseOut(MouseOutEvent event) {
            EIInstancePreviewLink.this.mouseOver = false;
            EIInstancePreviewLink.this.setFocus(false);
            if (EIInstancePreviewLink.this.popup != null) {
                EIInstancePreviewLink.this.popup.hide();
            }
        }
    }

    private class EIInstancePreviewMouseOverHandler
    implements MouseOverHandler {
        private EIEntity property;

        public EIInstancePreviewMouseOverHandler(EIEntity propertyValue) {
            this.property = propertyValue;
        }

        public void onMouseOver(MouseOverEvent event) {
            EIInstancePreviewLink.this.mouseOver = true;
            EIInstancePreviewLink.this.setFocus(true);
            if (EIInstancePreviewLink.this.popup == null) {
                try {
                    EIInstancePreviewLink.this.instanceService.getObjectPropertyValuePreview(SessionContext.getSessionId(), this.property.getURI(), new EIPreviewPopupCallback());
                }
                catch (RepositoryProviderException e) {
                    EIInstancePreviewLink.this.log.log(Level.SEVERE, "Unable to retrieve instance preview from callback.", e);
                }
            } else if (!EIInstancePreviewLink.this.popup.isShowing()) {
                EIInstancePreviewLink.this.popup.switchFocusMode(false);
            }
            if (EIInstancePreviewLink.this.popup != null) {
                int left = EIInstancePreviewLink.this.getAbsoluteLeft();
                int top = EIInstancePreviewLink.this.getAbsoluteTop() + EIInstancePreviewLink.this.getOffsetHeight() + 5;
                EIInstancePreviewLink.this.popup.setPopupPosition(left, top);
                EIInstancePreviewLink.this.popup.show();
            }
        }
    }
}

