/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance.widgets;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.SearchEIInstancePreview;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public class EIInstancePreviewPopup
extends PopupPanel
implements ValueChangeHandler<String> {
    private static final String MORE_INFO_LABEL_TEXT1 = "Press F2 to focus.";
    private static final String MORE_INFO_LABEL_TEXT2 = "Press F2 to show more information.";
    private static final String TYPE_PROPERTY_LABEL_TEXT = "Type: ";
    private static final String NAME_PROPERTY_LABEL_TEXT = "Name: ";
    private static final String MORE_INFO_LABEL_STYLE = "moreInfo";
    private static final String PROPERTY_VALUE_STYLE = "previewPopupRowValue";
    private static final String PROPERTY_LABEL_STYLE = "previewPopupLabel";
    private static final String POPUP_STYLE = "previewPopup";
    private static final String CLOSE_BUTTON_STYLE = "previewCloseButton";
    private static final String POPUP_CONTENT_STYLE = "previewPopupContent";
    private static final String POPUP_CONTENT_SCROLL_STYLE = "previewPopupContentScroll";
    private static Logger log = Logger.getLogger("EIInstancePreviewPopup");
    private final FlowPanel displayPanel;
    private FlowPanel instancePanel;
    private final SimplePanel controlPanel;
    private ScrollPanel scrollPanel;
    private static final int MAX_DISPLAYED_PROPERTIES = 3;
    private final Label moreInfoLabel;
    private final Label nameFieldLabel;
    private final Label nameFieldValue;
    private final Label typeFieldLabel;
    private final Label typeFieldValue;
    private boolean focusMode;
    private Button closeButton;
    private final SearchEIInstancePreview preview;
    private ArrayList<EIProperty> orderedProperties;

    public EIInstancePreviewPopup(SearchEIInstancePreview preview) {
        super(true);
        this.preview = preview;
        this.displayPanel = new FlowPanel();
        this.displayPanel.setStyleName(POPUP_STYLE);
        this.add((Widget)this.displayPanel);
        this.controlPanel = new SimplePanel();
        this.displayPanel.add((Widget)this.controlPanel);
        this.moreInfoLabel = new Label(MORE_INFO_LABEL_TEXT1);
        this.moreInfoLabel.setStyleName(MORE_INFO_LABEL_STYLE);
        this.controlPanel.add((Widget)this.moreInfoLabel);
        this.scrollPanel = new ScrollPanel();
        this.scrollPanel.setAlwaysShowScrollBars(false);
        this.scrollPanel.setStyleName(POPUP_CONTENT_SCROLL_STYLE);
        this.nameFieldLabel = new Label(NAME_PROPERTY_LABEL_TEXT);
        this.nameFieldLabel.setStyleName(PROPERTY_LABEL_STYLE);
        this.nameFieldValue = new Label(preview.getInstanceLabel());
        this.nameFieldValue.setStyleName(PROPERTY_VALUE_STYLE);
        this.typeFieldLabel = new Label(TYPE_PROPERTY_LABEL_TEXT);
        this.typeFieldLabel.setStyleName(PROPERTY_LABEL_STYLE);
        this.typeFieldValue = new Label(preview.getInstanceType().getLabel());
        this.typeFieldValue.setStyleName(PROPERTY_VALUE_STYLE);
        this.closeButton = new Button();
        this.closeButton.setStyleName(CLOSE_BUTTON_STYLE);
        this.closeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EIInstancePreviewPopup.this.close();
            }
        });
        this.focusMode = false;
        History.addValueChangeHandler((ValueChangeHandler)this);
        this.initializeInstancePanel();
        if (preview.getPropertyCount() > 0) {
            this.initializeProperties();
        } else {
            this.orderedProperties = new ArrayList(0);
        }
    }

    private void initializeProperties() {
        ClientModelManager.INSTANCE.getProperties(this.preview.getRealInstance().getInstanceClass(), new ClientModelManager.PropertyCallback(){

            public void onSuccess(EIClass result) {
                ClientModelManager.INSTANCE.getPropertyDefinitions(result.getProperties(), new ClientModelManager.PropertyDefinitionCallback(){

                    public void onSuccess(List<EIProperty> properties) {
                        EIInstancePreviewPopup.this.reorderProperties(properties);
                        EIInstancePreviewPopup.this.removeInvalidProperties();
                        EIInstancePreviewPopup.this.addProperties();
                    }
                });
            }
        });
    }

    private void removeInvalidProperties() {
        Map objectPropMap = this.preview.getRealInstance().getObjectProperties();
        HashSet<EIProperty> propsToRemove = new HashSet<EIProperty>();
        for (EIProperty property : this.orderedProperties) {
            if (!this.propertyIsInvalid(property.getEntity(), objectPropMap)) continue;
            this.preview.getRealInstance().getObjectProperties().remove(property.getEntity());
            propsToRemove.add(property);
        }
        this.orderedProperties.removeAll(propsToRemove);
    }

    private void reorderProperties(List<EIProperty> properties) {
        ArrayList<EIProperty> personProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> contactProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> providerProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> dateProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> primaryProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> secondaryProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> restOfProperties = new ArrayList<EIProperty>();
        Set dataprops = this.preview.getRealInstance().getDatatypeProperties().keySet();
        this.orderedProperties = new ArrayList(properties.size());
        for (EIProperty property : properties) {
            if (property.getEntity().equals((Object)EagleIEntityConstants.RESOURCE_DESCRIPTION_ENTITY) && dataprops.contains(property.getEntity())) {
                this.orderedProperties.add(0, property);
                continue;
            }
            if (property.getEntity().equals((Object)EagleIEntityConstants.SYNONYM_ENTITY) && dataprops.contains(property.getEntity())) {
                this.orderedProperties.add(0, property);
                continue;
            }
            if (this.hasPersonRange(property)) {
                personProperties.add(property);
                continue;
            }
            if (property.getEntity().getLabel().contains("date")) {
                dateProperties.add(property);
                continue;
            }
            Set annotations = property.getAnnotations();
            if (annotations.contains("http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab")) {
                providerProperties.add(property);
                continue;
            }
            if (annotations.contains("http://eagle-i.org/ont/app/1.0/PropertyGroup_ContactLocation") || annotations.contains("http://eagle-i.org/ont/app/1.0/PropertyGroup_EmailContact")) {
                contactProperties.add(property);
                continue;
            }
            if (annotations.contains("http://eagle-i.org/ont/app/1.0/PropertyGroup_PrimaryProperties")) {
                primaryProperties.add(property);
                continue;
            }
            if (annotations.contains("http://eagle-i.org/ont/app/1.0/PropertyGroup_SecondaryProperties")) {
                secondaryProperties.add(property);
                continue;
            }
            restOfProperties.add(property);
        }
        this.orderedProperties.addAll(providerProperties);
        this.orderedProperties.addAll(personProperties);
        this.orderedProperties.addAll(contactProperties);
        Collections.reverse(dateProperties);
        this.orderedProperties.addAll(dateProperties);
        this.orderedProperties.addAll(primaryProperties);
        this.orderedProperties.addAll(secondaryProperties);
        this.orderedProperties.addAll(restOfProperties);
    }

    private void addProperties() {
        StringBuilder strBuild = new StringBuilder();
        Map dataPropMap = this.preview.getRealInstance().getDatatypeProperties();
        Map objectPropMap = this.preview.getRealInstance().getObjectProperties();
        int count = 0;
        for (int i = 0; i < this.orderedProperties.size() && (this.focusMode || count < 3); ++i) {
            EIProperty property = this.orderedProperties.get(i);
            EIEntity propertyEntity = property.getEntity();
            boolean isObjectProp = objectPropMap.containsKey(propertyEntity);
            boolean isDataProp = dataPropMap.containsKey(propertyEntity);
            if (!isObjectProp && !isDataProp) {
                log.log(Level.FINER, "No data found for property: " + propertyEntity.getLabel());
                continue;
            }
            Label propertyFieldLabel = new Label(propertyEntity.getLabel() + ": ");
            propertyFieldLabel.setStyleName(PROPERTY_LABEL_STYLE);
            this.instancePanel.add((Widget)propertyFieldLabel);
            Object[] propertyValArry = isObjectProp ? ((Set)objectPropMap.get(propertyEntity)).toArray() : ((Set)dataPropMap.get(propertyEntity)).toArray();
            log.log(Level.FINER, propertyValArry.length + " values found for property: " + propertyEntity.getLabel());
            for (int j = 0; j < propertyValArry.length; ++j) {
                if (strBuild.length() > 0) {
                    if (propertyValArry.length > 2) {
                        strBuild.append(", ");
                    }
                    if (j == propertyValArry.length - 1) {
                        strBuild.append(" and ");
                    }
                }
                String val = isObjectProp ? ((EIEntity)propertyValArry[j]).getLabel() : (String)propertyValArry[j];
                strBuild.append(InstanceWidgetUtils.formatText(val));
            }
            log.finer("adding property value " + strBuild.toString());
            Label propertyFieldValue = new Label(strBuild.toString());
            propertyFieldValue.setStyleName(PROPERTY_VALUE_STYLE);
            this.instancePanel.add((Widget)propertyFieldValue);
            strBuild.delete(0, strBuild.length());
            ++count;
        }
        if (!this.focusMode) {
            if (this.preview.getPropertyCount() > 3) {
                this.moreInfoLabel.setText(MORE_INFO_LABEL_TEXT2);
            } else {
                this.moreInfoLabel.setText(MORE_INFO_LABEL_TEXT1);
            }
        }
    }

    private boolean propertyIsInvalid(EIEntity propertyEntity, Map<EIEntity, Set<EIEntity>> objectPropMap) {
        EIEntity[] valueArry;
        EIEntity valueEntity;
        if (objectPropMap.containsKey(propertyEntity) && ((valueEntity = (valueArry = objectPropMap.get(propertyEntity).toArray(new EIEntity[0]))[0]).getLabel() == null || valueEntity.getLabel().equals(valueEntity.getURI().toString()) || valueEntity.getLabel().equals(""))) {
            log.finer("property " + propertyEntity.getLabel() + " had invalid value");
            return true;
        }
        return false;
    }

    private boolean hasPersonRange(EIProperty property) {
        if (!(property instanceof EIObjectProperty)) {
            return false;
        }
        List ranges = ((EIObjectProperty)property).getRangeList();
        return ranges.size() == 1 && ((EIClass)ranges.get(0)).getEntity().getURI().equals((Object)EagleIEntityConstants.FOAF_PERSON_URI);
    }

    public void switchFocusMode(boolean shouldBeFocused) {
        if (!this.focusMode && shouldBeFocused) {
            this.focusMode = true;
            this.instancePanel.removeFromParent();
            this.displayPanel.add((Widget)this.scrollPanel);
            this.moreInfoLabel.removeFromParent();
            this.controlPanel.add((Widget)this.closeButton);
            this.initializeInstancePanel();
            this.addProperties();
            this.scrollPanel.add((Widget)this.instancePanel);
            this.setAutoHideEnabled(false);
        } else if (this.focusMode && !shouldBeFocused) {
            this.focusMode = false;
            this.instancePanel.removeFromParent();
            this.scrollPanel.removeFromParent();
            this.closeButton.removeFromParent();
            this.controlPanel.add((Widget)this.moreInfoLabel);
            this.initializeInstancePanel();
            this.addProperties();
            this.displayPanel.add((Widget)this.instancePanel);
            this.setAutoHideEnabled(true);
        }
    }

    private void close() {
        super.hide();
    }

    public void hide() {
        if (!this.focusMode) {
            super.hide();
        }
    }

    public void onValueChange(ValueChangeEvent<String> event) {
        this.close();
    }

    private void initializeInstancePanel() {
        this.instancePanel = new FlowPanel();
        this.instancePanel.setStyleName(POPUP_CONTENT_STYLE);
        this.displayPanel.add((Widget)this.instancePanel);
        this.instancePanel.add((Widget)this.nameFieldLabel);
        this.instancePanel.add((Widget)this.nameFieldValue);
        this.instancePanel.add((Widget)this.typeFieldLabel);
        this.instancePanel.add((Widget)this.typeFieldValue);
    }
}

