/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.suggest.AbstractSearchBox;
import org.eaglei.ui.gwt.suggest.DataSuggestBox;
import org.eaglei.ui.gwt.suggest.DataSuggestOracle;

public class DataSuggestSearchBar
extends Composite
implements SearchContext.SearchListener {
    private static final boolean STICKY_SIDEBAR = false;
    DataSuggestBox termBox;
    Image searchButton;

    public DataSuggestSearchBar() {
        this(true);
    }

    public DataSuggestSearchBar(boolean hasResourceSelect) {
        FlowPanel outer = new FlowPanel();
        this.initWidget((Widget)outer);
        DataSuggestOracle suggestOracle = new DataSuggestOracle();
        this.termBox = new DataSuggestBox(suggestOracle);
        outer.add((Widget)this.termBox);
        this.termBox.addStyleName("searchBoxResults");
        this.searchButton = new Image("images/button-search3.png");
        this.searchButton.setSize("130px", "38px");
        outer.add((Widget)this.searchButton);
        this.searchButton.setStyleName("buttonPadding");
        this.searchButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String query = DataSuggestSearchBar.this.termBox.getText();
                if (query.equals(DataSuggestSearchBar.this.termBox.getLastSetText())) {
                    return;
                }
                SearchRequest.Term term = query.length() == 0 ? null : new SearchRequest.Term(query);
                DataSuggestSearchBar.this.executeSearch(term, null, false);
            }
        });
        this.termBox.addSearchHandler(new AbstractSearchBox.SearchHandler(){

            @Override
            public void performSearch(SearchRequest.Term term, SearchRequest.TypeBinding binding, boolean isSuggestSelect) {
                DataSuggestSearchBar.this.executeSearch(term, binding, isSuggestSelect);
            }
        }, true, true);
        this.termBox.setDefaultText();
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            this.setSearchRequest(SearchContext.INSTANCE.getCurrentRequest());
        }
        SearchContext.INSTANCE.addListener(this);
    }

    private void executeSearch(SearchRequest.Term term, SearchRequest.TypeBinding binding, boolean isSuggestSelect) {
        SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
        SearchRequest newRequest = new SearchRequest();
        newRequest.setTerm(term);
        newRequest.setBinding(binding);
        SearchContext.INSTANCE.search(newRequest);
    }

    public void sizeToParent(int maxWidth) {
        int termBoxWidth = maxWidth - 130;
        this.termBox.setWidth(termBoxWidth + "px");
    }

    private void setSearchRequest(SearchRequest request) {
        if (request != null && request.getTerm() != null) {
            this.termBox.setText(request.getTerm().getQuery());
        } else {
            this.termBox.setDefaultText();
        }
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (request == null) {
            return;
        }
        if (!this.isAttached()) {
            return;
        }
        String query = this.termBox.getText();
        if (request.getTerm() == null || request.getTerm().getQuery().length() == 0) {
            if (query.length() > 0) {
                request.setTerm(new SearchRequest.Term(query));
            }
        } else if (request.getTerm() != null && request.getTerm().getQuery().length() > 0 && !request.getTerm().getQuery().equals(query)) {
            if (query.length() > 0) {
                request.setTerm(new SearchRequest.Term(query));
            } else {
                request.setTerm(null);
            }
        }
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        this.setSearchRequest(request);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
    }
}

