/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.suggest.client.AbstractSearchBox;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.TermSuggestBox;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;

public class SearchBar
extends Composite
implements SearchContext.SearchListener {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    TermSuggestBox termBox;
    @UiField
    Image searchButton;

    public SearchBar() {
        this(true);
    }

    public SearchBar(boolean hasResourceSelect) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.searchButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String query = SearchBar.this.termBox.getText();
                SearchBar.this.executeSearch(query, null);
            }
        });
        this.termBox.addSearchHandler(new AbstractSearchBox.SearchHandler(){

            public void performSearch(String query, String uri) {
                SearchBar.this.executeSearch(query, uri);
            }
        }, true, true);
        this.termBox.setDefaultText();
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            this.setSearchRequest(SearchContext.INSTANCE.getCurrentRequest());
        }
        SearchContext.INSTANCE.addListener(this);
    }

    private void executeSearch(String query, String uri) {
        SearchRequest newRequest;
        SearchRequest.Term term = query.length() == 0 && uri == null ? null : new SearchRequest.Term(query, uri != null ? EIURI.create((String)uri) : null);
        SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
        if (previousRequest != null) {
            newRequest = new SearchRequest(previousRequest.toURLParams());
            newRequest.setStartIndex(0);
        } else {
            newRequest = new SearchRequest();
        }
        newRequest.setTerm(term);
        SearchContext.INSTANCE.search(newRequest);
    }

    public void sizeToParent(int maxWidth) {
        int termBoxWidth = maxWidth - 130;
        this.termBox.setWidth(termBoxWidth + "px");
    }

    private void setSearchRequest(SearchRequest request) {
        if (request != null && request.getTerm() != null) {
            this.termBox.setText(request.getTerm().getQuery());
        } else {
            this.termBox.setDefaultText();
        }
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (request == null) {
            return;
        }
        if (!this.isAttached()) {
            return;
        }
        String query = this.termBox.getText();
        if (request.getTerm() == null || request.getTerm().getQuery().length() == 0) {
            if (query.length() > 0) {
                request.setTerm(new SearchRequest.Term(query));
            }
        } else if (request.getTerm() != null && request.getTerm().getQuery().length() > 0 && !request.getTerm().getQuery().equals(query)) {
            if (query.length() > 0) {
                request.setTerm(new SearchRequest.Term(query));
            } else {
                request.setTerm(null);
            }
        }
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        this.setSearchRequest(request);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
    }

    static interface MyUiBinder
    extends UiBinder<Widget, SearchBar> {
    }
}

