/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.ui.gwt.search.results.NavBar;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;

public class InnerNavBar
extends Composite {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    private NavBar.NavListener listener;
    private Map<EIURI, String> mapInstURIToLabel = null;
    private static final String SEPARATOR = " - ";
    @UiField
    Element countLabel;
    @UiField
    Anchor previousButton;
    @UiField
    Anchor nextButton;
    @UiField
    SpanElement breadcrumbSpan;

    public InnerNavBar() {
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
        this.previousButton.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                InnerNavBar.this.previousButton.addStyleDependentName("hovering");
            }
        });
        this.previousButton.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                InnerNavBar.this.previousButton.removeStyleDependentName("hovering");
            }
        });
        this.nextButton.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                InnerNavBar.this.nextButton.addStyleDependentName("hovering");
            }
        });
        this.nextButton.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                InnerNavBar.this.nextButton.removeStyleDependentName("hovering");
            }
        });
        this.initInstitutionList();
    }

    public void addNavListener(NavBar.NavListener listener) {
        this.listener = listener;
    }

    public void update(ClientSearchResultSet results) {
        SearchResultSet resultSet = results.getResultSet();
        int startIndex = resultSet.getStartIndex();
        int count = resultSet.getTotalCount();
        int max = resultSet.getStartIndex() + 10;
        if (max > count) {
            max = count;
        }
        this.setVisibility((Widget)this.previousButton, startIndex != 0);
        this.setVisibility((Widget)this.nextButton, startIndex + 10 < count);
        if (count == 0) {
            this.countLabel.setInnerText("");
        } else {
            this.countLabel.setInnerText("" + (startIndex + 1) + SEPARATOR + max + " of " + count);
        }
        this.updateBreadCrumbs(results);
    }

    private void updateBreadCrumbs(ClientSearchResultSet results) {
        SearchRequest.Term term;
        EIEntity entity;
        String providerLabel;
        StringBuilder crumbBuilder = new StringBuilder();
        boolean first = true;
        EIURI instUri = results.getResultSet().getRequest().getProviderInstitution();
        if (instUri != null) {
            crumbBuilder.append(this.mapInstURIToLabel.get(instUri));
            first = false;
        }
        if ((providerLabel = results.getResultSet().getRequest().getProviderTypeLabel()) != null) {
            if (!first) {
                crumbBuilder.append(SEPARATOR);
            }
            crumbBuilder.append(providerLabel);
            first = false;
        }
        if ((entity = results.getBindingEntity()) != null) {
            if (!first) {
                crumbBuilder.append(SEPARATOR);
            }
            crumbBuilder.append(entity.getLabel());
            first = false;
        }
        if ((term = results.getResultSet().getRequest().getTerm()) != null) {
            if (!first) {
                crumbBuilder.append(SEPARATOR);
            }
            crumbBuilder.append("\"" + term.getQuery() + "\"");
        }
        this.breadcrumbSpan.setInnerText(crumbBuilder.toString());
    }

    @UiHandler(value={"previousButton"})
    void onNewerClicked(ClickEvent event) {
        this.listener.onPreviousPage();
    }

    @UiHandler(value={"nextButton"})
    void onOlderClicked(ClickEvent event) {
        this.listener.onNextPage();
    }

    private void setVisibility(Widget widget, boolean visible) {
        widget.setVisible(visible);
    }

    private void initInstitutionList() {
        SearchServiceRemoteAsync searchService = (SearchServiceRemoteAsync)GWT.create(SearchServiceRemote.class);
        searchService.getInstitutions(new AsyncCallback<List<EIEntity>>(){

            public void onSuccess(List<EIEntity> result) {
                InnerNavBar.this.mapInstURIToLabel = new HashMap(result.size());
                for (EIEntity entity : result) {
                    InnerNavBar.this.mapInstURIToLabel.put(entity.getURI(), entity.getLabel());
                }
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    @UiTemplate(value="InnerNavBar.ui.xml")
    static interface Binder
    extends UiBinder<Widget, InnerNavBar> {
    }
}

