/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.eaglei.model.EIEntity;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.results.InnerNavBar;
import org.eaglei.ui.gwt.search.results.NavBar;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;

public class ResourcesGrid
extends FlowPanel
implements NavBar.NavListener {
    public static final int PAGE_SIZE = 10;
    private static final int FIRST_RESULT_ROW = 2;
    private static final int BOTTOM_THRESHOLD = 7;
    private final Map<SearchRequest.DataSet, DataSetRenderer> mapDSToRenderer = new HashMap<SearchRequest.DataSet, DataSetRenderer>();
    private ClientSearchResultSet currentResults;
    private DataSetRenderer currentRenderer;
    private final NavBar navBar1;
    private final InnerNavBar navBar2;
    private Label status;
    private final FlowPanel statusRow;
    private final FlowPanel progressRow;

    public ResourcesGrid(NavBar navBar1, InnerNavBar navBar2) {
        this.setStyleName("ResultPanel");
        this.navBar1 = navBar1;
        this.navBar2 = navBar2;
        navBar1.addNavListener(this);
        navBar2.addNavListener(this);
        this.status = new Label();
        this.statusRow = new FlowPanel();
        this.statusRow.add((Widget)this.status);
        this.add((Widget)this.statusRow);
        this.progressRow = new FlowPanel();
        this.progressRow.add((Widget)new Image(ApplicationResources.INSTANCE.loading()));
        this.add((Widget)this.progressRow);
    }

    public ClientSearchResultSet getCurrentResults() {
        return this.currentResults;
    }

    public void addRenderer(DataSetRenderer renderer) {
        this.mapDSToRenderer.put(renderer.getDataset(), renderer);
    }

    public void displaySearchPending() {
        this.currentResults = null;
        this.navBar1.setVisible(false);
        this.navBar2.setVisible(false);
        this.statusRow.setVisible(false);
        this.progressRow.setVisible(true);
        for (int i = this.getWidgetCount() - 1; i >= 2; --i) {
            this.remove(i);
        }
    }

    public void displayStatusMessage(String message) {
        this.displayStatusMessage(message, false);
    }

    public void displayStatusMessage(String message, boolean showNavBar) {
        this.status.setText(message);
        this.currentResults = null;
        this.navBar1.setVisible(showNavBar);
        this.navBar2.setVisible(false);
        this.statusRow.setVisible(true);
        this.progressRow.setVisible(false);
        for (int i = this.getWidgetCount() - 1; i >= 2; --i) {
            this.remove(i);
        }
    }

    public void displaySearchResults(ClientSearchResultSet results) {
        if (results.getResultSet().getRequest().getDataset() == SearchRequest.DataSet.NIF_RESOURCES) {
            this.displayStatusMessage("This feature (NIF search) is temporarily unavailable.", false);
            return;
        }
        if (results.getResultSet().getResults().size() == 0) {
            this.navBar1.update(results);
            this.navBar2.update(results);
            if (results.getResultSet().getResults().size() < 7) {
                this.navBar2.setVisible(false);
            }
            this.displayStatusMessage("No results found.", true);
            return;
        }
        if (this.currentRenderer == null || this.currentRenderer.getDataset() != results.getResultSet().getRequest().getDataset()) {
            this.currentRenderer = this.mapDSToRenderer.get(results.getResultSet().getRequest().getDataset());
            this.currentRenderer.displayHeaderRow();
        }
        this.currentResults = results;
        this.progressRow.setVisible(false);
        this.navBar1.update(results);
        this.navBar2.update(results);
        this.navBar1.setVisible(true);
        this.navBar2.setVisible(results.getResultSet().getResults().size() >= 7);
        this.statusRow.setVisible(false);
        int row = 2;
        SearchRequest.DataSet dataset = results.getResultSet().getRequest().getDataset();
        for (SearchResult result : results.getResultSet().getResults()) {
            this.currentRenderer.createInstanceRow(row++, dataset, result);
        }
    }

    @Override
    public void onPreviousPage() {
        int startIndex = this.currentResults.getResultSet().getStartIndex() - 10;
        assert (startIndex >= 0) : "paged beyond the start of the result list";
        this.executeNewPageSearch(startIndex);
    }

    @Override
    public void onNextPage() {
        int startIndex = this.currentResults.getResultSet().getStartIndex() + 10;
        assert (startIndex < this.currentResults.getResultSet().getTotalCount()) : "paged beyond the end of the result list";
        this.executeNewPageSearch(startIndex);
    }

    private void executeNewPageSearch(int startIndex) {
        SearchRequest newRequest = new SearchRequest(this.currentResults.getResultSet().getRequest().toURLParams());
        newRequest.setStartIndex(startIndex);
        SearchContext.INSTANCE.search(newRequest);
    }

    public static class DataSetRenderer {
        protected String[] columnHeaderNames;
        protected SearchRequest.DataSet dataset;
        protected ResourcesGrid resultsTable;

        public DataSetRenderer(ResourcesGrid resultsTable, SearchRequest.DataSet dataset, String[] columnHeaderNames) {
            this.resultsTable = resultsTable;
            this.dataset = dataset;
            this.columnHeaderNames = columnHeaderNames;
        }

        public SearchRequest.DataSet getDataset() {
            return this.dataset;
        }

        public String[] getHeaderColumnNames() {
            return this.columnHeaderNames;
        }

        public void displayHeaderRow() {
            FlowPanel headerRow = new FlowPanel();
            for (String colName : this.getHeaderColumnNames()) {
                HTML contents = new HTML("<b>" + colName + "</b>");
                contents.setStyleName("listGridHeader");
                headerRow.add((Widget)contents);
            }
        }

        public void createInstanceRow(int row, SearchRequest.DataSet dataset, SearchResult searchResult) {
            Hyperlink labLink;
            Anchor instanceLink;
            FlowPanel rowPanel = new FlowPanel();
            rowPanel.setStyleName("ResultPanelRow");
            if (dataset == SearchRequest.DataSet.EI_RESOURCES) {
                instanceLink = new Hyperlink(searchResult.getEntity().getLabel(), "inst/uri=" + searchResult.getEntity().getURI().toString());
            } else {
                instanceLink = new Anchor(searchResult.getEntity().getLabel(), searchResult.getEntity().getURI().toString());
                instanceLink.setTarget("_blank");
            }
            instanceLink.setStyleName("ResultNameLabel");
            HTML snippit = null;
            if (searchResult.getHighlight() != null) {
                snippit = new HTML(searchResult.getHighlight());
            }
            CellPanel cp = new CellPanel();
            cp.setContent((Widget)instanceLink, (Widget)snippit);
            rowPanel.add((Widget)cp);
            Label typeLabel = new Label(searchResult.getType().getLabel());
            Label rootTypeLabel = null;
            EIEntity rootTypeEntity = this.resultsTable.currentResults.getMapURIToRootEntity().get(searchResult.getType().getURI());
            if (rootTypeEntity != null) {
                rootTypeLabel = new Label(rootTypeEntity.getLabel());
            }
            cp = new CellPanel();
            cp.setContent((Widget)typeLabel, (Widget)rootTypeLabel);
            if (rootTypeLabel != null) {
                rootTypeLabel.addStyleName("rootType");
            }
            rowPanel.add((Widget)cp);
            EIEntity lab = searchResult.getProvider();
            if (lab != null) {
                labLink = new Hyperlink(lab.getLabel(), "inst/uri=" + lab.getURI().toString());
                labLink.setStyleName("resultsLabLink");
            } else {
                labLink = null;
            }
            Label instLabel = new Label(searchResult.getInstitution().getLabel());
            cp = new CellPanel();
            if (ApplicationContext.IS_INSTITUTION) {
                if (labLink != null) {
                    cp.setContent((Widget)labLink, null);
                }
            } else {
                cp.setContent((Widget)instLabel, (Widget)labLink);
            }
            rowPanel.add((Widget)cp);
            this.resultsTable.add((Widget)rowPanel);
        }
    }

    public static class CellPanel
    extends FlowPanel {
        CellPanel() {
            this.setStyleName("resultsTableCell");
        }

        void setContent(Widget primary, Widget secondary) {
            this.clear();
            this.add(primary);
            primary.addStyleName("primary");
            if (secondary != null) {
                this.add(secondary);
                secondary.addStyleName("secondary");
            }
        }
    }
}

