/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.harvest.PollingDataHarvester;
import org.eaglei.search.logging.AsynchronousLoggerCount;
import org.eaglei.search.logging.AsynchronousLoggerSearch;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.SecurityProvider;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.rpc.LoggedException;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SearchServlet
extends RemoteServiceServlet
implements SearchServiceRemote {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(SearchServlet.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private SearchProvider searchProvider;
    private PollingDataHarvester dataHarvester;
    private SecurityProvider securityProvider;
    private EIOntModel eagleiOntModel;
    private InstitutionRegistry institutionRegistry;
    private List<EIClass> searchCategoryClasses;
    private HashSet<EIURI> searchCategoryURIs;
    private AsynchronousLoggerSearch asyncLoggerSearch;
    private static final String SEARCH_LOG_TABLE_NAME = "SEARCH_SERVLET_LOG";
    private AsynchronousLoggerCount asyncLoggerCount;
    private static final String COUNT_LOG_TABLE_NAME = "SEARCH_SERVLET_COUNT_LOG";
    private String ontologyVersion = "";

    public void init() {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.searchProvider = (SearchProvider)ctx.getBean("rootSearchProvider", SearchProvider.class);
        this.securityProvider = (SecurityProvider)ctx.getBean("securityProvider", SecurityProvider.class);
        this.eagleiOntModel = (EIOntModel)ctx.getBean(EIOntModel.class);
        this.institutionRegistry = (InstitutionRegistry)ctx.getBean(InstitutionRegistry.class);
        List searchCategories = (List)ctx.getBean("searchCategories");
        this.searchCategoryClasses = new ArrayList<EIClass>(searchCategories.size());
        this.searchCategoryURIs = new HashSet(searchCategories.size());
        for (String uriStr : searchCategories) {
            EIURI uri = EIURI.create((String)uriStr);
            this.searchCategoryClasses.add(this.eagleiOntModel.getClass(uri));
            this.searchCategoryURIs.add(uri);
        }
        try {
            this.searchProvider.init();
            logger.info((Object)"SearchProvider created and initialized");
        }
        catch (Throwable t) {
            logger.error((Object)"Initialization of search provider failed", t);
            throw new RuntimeException("Initialization of search provider failed", t);
        }
        String buildID = "Unknown";
        InputStream inputStream = null;
        try {
            inputStream = ctx.getResource("/buildversion.properties").getInputStream();
            if (inputStream == null) {
                logger.info((Object)"/buildversion.properties not found");
                inputStream = ctx.getResource("/institution/buildversion.properties").getInputStream();
                if (inputStream == null) {
                    logger.info((Object)"/institution/buildversion.properties not found");
                }
            }
            if (inputStream != null) {
                Properties props = new Properties();
                props.load(inputStream);
                buildID = props.getProperty("buildversion", "Unknown");
            }
        }
        catch (IOException ioe) {
            logger.error((Object)"Failed to find buildversion.properties");
        }
        logger.debug((Object)("SearchServlet: Context Display name = " + ctx.getDisplayName()));
        logger.debug((Object)("SearchServlet: Context ID = " + ctx.getId()));
        if (ctx.getParent() == null) {
            logger.debug((Object)"SearchServlet: Context Parent is null.");
        } else {
            logger.debug((Object)("SearchServlet: Context Parent Display name = " + ctx.getParent().getDisplayName()));
        }
        if (ctx.getServletContext() == null) {
            logger.debug((Object)"SearchServlet: ServletContext is null.");
        } else {
            logger.debug((Object)("SearchServlet: ServletContext path = " + ctx.getServletContext().getContextPath()));
            logger.debug((Object)("SearchServlet: ServletContext context name = " + ctx.getServletContext().getServletContextName()));
        }
        this.ontologyVersion = this.eagleiOntModel.getVersion();
        this.asyncLoggerSearch = new AsynchronousLoggerSearch(SEARCH_LOG_TABLE_NAME, buildID, this.ontologyVersion);
        this.asyncLoggerCount = new AsynchronousLoggerCount(COUNT_LOG_TABLE_NAME, buildID, this.ontologyVersion);
        this.dataHarvester = (PollingDataHarvester)ctx.getBean("dataHarvester");
        this.dataHarvester.startPolling();
    }

    public void destroy() {
    }

    @Override
    public List<EIEntity> getInstitutions() throws LoggedException, InvalidSessionIdException {
        try {
            return this.institutionRegistry.getInstitutions();
        }
        catch (Throwable t) {
            logger.error((Object)"Error in getInstitutions", t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public List<EIClass> getTopLevelSearchCategories() throws LoggedException {
        try {
            return this.searchCategoryClasses;
        }
        catch (Throwable t) {
            logger.error((Object)"Error in getTopLevelSearchCategories", t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public ClientSearchResultSet search(String sessionId, SearchRequest request) throws InvalidSessionIdException, LoggedException {
        try {
            this.securityProvider.isValid(sessionId, true);
        }
        catch (RepositoryProviderException e) {
            throw new InvalidSessionIdException("Error validating session.", e);
        }
        if (!this.dataHarvester.hasInitialData()) {
            throw new LoggedException("Search application is initializing...  Please retry in a few minutes.");
        }
        long start = System.currentTimeMillis();
        try {
            if (request == null) {
                logger.error((Object)"Null search request");
                throw new LoggedException();
            }
            if (DEBUG) {
                logger.debug((Object)("Search request:  " + request.toString()));
            }
            SearchResultSet resultSet = this.searchProvider.query(request);
            EIEntity bindingEntity = request.getBinding() != null ? this.eagleiOntModel.getClass(request.getBinding().getType()).getEntity() : null;
            EIURI bindingCategoryURI = null;
            if (request.getBinding() != null) {
                if (this.searchCategoryURIs.contains(request.getBinding().getType())) {
                    bindingCategoryURI = request.getBinding().getType();
                } else {
                    List superclasses = this.eagleiOntModel.getSuperClasses(request.getBinding().getType());
                    for (int i = superclasses.size() - 1; i >= 0; --i) {
                        EIURI superclassURI = ((EIClass)superclasses.get(i)).getEntity().getURI();
                        if (!this.searchCategoryURIs.contains(superclassURI)) continue;
                        bindingCategoryURI = superclassURI;
                        break;
                    }
                }
            }
            HashMap<EIURI, EIEntity> mapURIToRootEntity = new HashMap<EIURI, EIEntity>();
            for (SearchResult result : resultSet.getResults()) {
                List superclasses = this.eagleiOntModel.getSuperClasses(result.getType().getURI());
                if (superclasses.size() <= 0) continue;
                mapURIToRootEntity.put(result.getType().getURI(), ((EIClass)superclasses.get(superclasses.size() - 1)).getEntity());
            }
            long end = System.currentTimeMillis();
            long count = resultSet.getTotalCount();
            this.asyncLoggerSearch.log(this.securityProvider.getSession(sessionId), start, end, request, count);
            return new ClientSearchResultSet(resultSet, bindingEntity, bindingCategoryURI, mapURIToRootEntity);
        }
        catch (Throwable t) {
            logger.error((Object)("Unexpected error in search: " + request.toString()), t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public SearchCounts count(String sessionId, SearchCountRequest request) throws InvalidSessionIdException, LoggedException {
        try {
            this.securityProvider.isValid(sessionId, true);
        }
        catch (RepositoryProviderException e) {
            throw new InvalidSessionIdException("Error validating session.", e);
        }
        if (!this.dataHarvester.hasInitialData()) {
            throw new LoggedException("Search application is initializing...  Please retry in a few minutes.");
        }
        try {
            if (request == null) {
                logger.error((Object)"Null search request");
                throw new LoggedException();
            }
            if (DEBUG) {
                logger.debug((Object)request.toString());
            }
            for (EIClass c : this.searchCategoryClasses) {
                EIURI uri = c.getEntity().getURI();
                if (request.getRequest().getBinding() != null && uri.equals((Object)request.getRequest().getBinding().getType())) continue;
                request.addCountType(uri);
            }
            if (request.getRequest().getBinding() != null) {
                request.addCountType(null);
            }
            return this.searchProvider.count(request);
        }
        catch (Throwable t) {
            logger.error((Object)("Unexpected error in count: " + request.toString()), t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public ClassCountResult getResourceCounts(String sessionId, SearchRequest request) throws InvalidSessionIdException, LoggedException {
        try {
            this.securityProvider.isValid(sessionId, true);
        }
        catch (RepositoryProviderException e) {
            throw new InvalidSessionIdException("Error validating session.", e);
        }
        if (!this.dataHarvester.hasInitialData()) {
            throw new LoggedException("Search application is initializing...  Please retry in a few minutes.");
        }
        try {
            if (DEBUG) {
                logger.debug((Object)("Count request:  " + request.toString()));
            }
            long start = System.currentTimeMillis();
            ClassCountResult result = this.searchProvider.getResourceCount(request);
            long end = System.currentTimeMillis();
            this.asyncLoggerCount.log(this.securityProvider.getSession(sessionId), start, end, request);
            return result;
        }
        catch (Throwable t) {
            logger.error((Object)("Unexpected error in count: " + request.toString()), t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public ClassCountResult getProviderTypeCounts(String sessionId, SearchRequest request) throws InvalidSessionIdException, LoggedException {
        try {
            this.securityProvider.isValid(sessionId, true);
        }
        catch (RepositoryProviderException e) {
            throw new InvalidSessionIdException("Error validating session.", e);
        }
        if (!this.dataHarvester.hasInitialData()) {
            throw new LoggedException("Search application is initializing...  Please retry in a few minutes.");
        }
        try {
            ClassCountResult result = this.searchProvider.getProviderTypeCount(request);
            return result;
        }
        catch (Throwable t) {
            logger.error((Object)("Unexpected error in provider type count: " + request.toString()), t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }
}

