/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.sidebar;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.SortedSet;
import java.util.logging.Logger;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.CountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.sidebar.AbstractCountNavigatorPanel;

public abstract class AbstractClassCountNavigatorPanel
extends AbstractCountNavigatorPanel {
    protected SearchRequest currentRequest;
    private static final String outerStyleName = "resourceList";
    private static final String ALL_RESOURCES_STYLE = "allResources";
    private static final String ALL_RESOURCES_SELECTED_STYLE = "allResourcesSelected";
    private static final String DEFAULT_RESOURCE_STYLE = "resourceWrapper";
    private static final String TOP_RESOURCE_STYLE = "topResource";
    private static final String DEFAULT_RESOURCE_LINK_STYLE = "resourceTitle";
    private static final String TOP_RESOURCE_LINK_STYLE = "topResourceTitle";
    private static final Logger log = Logger.getLogger("AbstractClassCountNavigatorPanel");

    protected AbstractClassCountNavigatorPanel() {
    }

    public void setClassCountResult(ClassCountResult result) {
        this.currentRequest = result.getSearchRequest();
        this.displayResult(result);
    }

    private void displayResult(ClassCountResult c) {
        SortedSet subClassCounts;
        log.finer("displaying new result");
        this.outer.clear();
        this.outer.setStyleName(outerStyleName);
        Panel allPanel = null;
        allPanel = this.addDiv((Panel)this.outer, "");
        allPanel.setStyleName(ALL_RESOURCES_STYLE);
        if (c.getEntity() == null) {
            this.addLabel(allPanel, this.getAllLinkLabel(), ALL_RESOURCES_SELECTED_STYLE);
        } else {
            this.addLink(allPanel, this.getAllLinkLabel(), null, "link", false, false);
        }
        FlowPanel latestPanel = this.outer;
        String divStyleName = TOP_RESOURCE_STYLE;
        String linkStyleName = TOP_RESOURCE_LINK_STYLE;
        List superClassCounts = c.getSuperClassCounts();
        if (superClassCounts != null && superClassCounts.size() > 0) {
            for (CountResult superClass : superClassCounts) {
                Panel newDiv = this.addDiv((Panel)latestPanel, divStyleName);
                this.addAncestorLink(newDiv, linkStyleName, divStyleName, superClass);
                latestPanel = newDiv;
                divStyleName = DEFAULT_RESOURCE_STYLE;
                linkStyleName = DEFAULT_RESOURCE_LINK_STYLE;
            }
        }
        if (c.getEntity() != null) {
            Panel newDiv = this.addDiv((Panel)latestPanel, divStyleName);
            this.addLink(newDiv, c.getClassCount(), linkStyleName, divStyleName, true);
            latestPanel = newDiv;
            divStyleName = DEFAULT_RESOURCE_STYLE;
            linkStyleName = DEFAULT_RESOURCE_LINK_STYLE;
        }
        if ((subClassCounts = c.getSubClassCounts()) != null && subClassCounts.size() > 0) {
            Panel newDiv = this.addDiv((Panel)latestPanel, divStyleName);
            latestPanel = newDiv;
            for (CountResult child : subClassCounts) {
                this.addSubClassLink((Panel)latestPanel, linkStyleName, divStyleName, child);
            }
        }
    }

    @Override
    protected void onEntityClick(EIURI typeBindingURI) {
        SearchRequest newRequest;
        SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
        if (previousRequest != null) {
            newRequest = new SearchRequest(previousRequest.toURLParams());
            newRequest.setStartIndex(0);
        } else {
            newRequest = new SearchRequest();
        }
        if (typeBindingURI == null) {
            newRequest.setBinding(null);
        } else {
            newRequest.setBinding(new SearchRequest.TypeBinding(typeBindingURI));
        }
        SearchContext.INSTANCE.search(newRequest);
    }

    private Panel addDiv(Panel container, String styleName) {
        FlowPanel newDiv = new FlowPanel();
        newDiv.setStyleName(styleName);
        container.add((Widget)newDiv);
        return newDiv;
    }
}

