/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.sidebar;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.CountResult;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.UIConstants;

public abstract class AbstractCountNavigatorPanel
extends Composite {
    protected final FlowPanel outer = new FlowPanel();
    private Image loadingImage = new Image(ApplicationResources.INSTANCE.loadingSmall());

    protected AbstractCountNavigatorPanel() {
        this.initWidget((Widget)this.outer);
        this.setStyleName("resourceList");
    }

    protected String createLabelString(String label, int count) {
        String newLabel = label;
        if (UIConstants.topLevelTypePlurals.containsKey(label)) {
            newLabel = UIConstants.topLevelTypePlurals.get(label);
        }
        return newLabel + " (" + count + ")";
    }

    protected String createLabelString(CountResult c) {
        return this.createLabelString(c.getEntity().getLabel(), c.getCount());
    }

    protected UIObject addLabel(Panel container, CountResult c) {
        UIObject ui = this.addLabel(container, this.createLabelString(c));
        ui.setTitle(c.getDefinition());
        return ui;
    }

    protected UIObject addLabel(Panel container, String labelString) {
        Label l = new Label(labelString);
        container.add((Widget)l);
        return l;
    }

    protected UIObject addLabel(Panel container, String labelString, String styleName) {
        Label l = new Label(labelString);
        l.setStyleName(styleName);
        container.add((Widget)l);
        return l;
    }

    protected UIObject addAncestorLink(Panel container, String linkStyle, String containerStyle, CountResult c) {
        UIObject ui = this.addLink(container, c, linkStyle, containerStyle, false);
        return ui;
    }

    protected UIObject addSubClassLink(Panel container, String linkStyle, String containerStyle, CountResult c) {
        UIObject ui = this.addLink(container, c, linkStyle, containerStyle, c.hasSubEntity());
        return ui;
    }

    protected UIObject addLink(Panel container, CountResult c, String linkStyle, String containerStyle, boolean isSelected) {
        Label ui = this.addLink(container, this.createLabelString(c), c.getEntity().getURI(), linkStyle, false, isSelected);
        ui.setTitle(c.getDefinition());
        return ui;
    }

    protected Label addLink(Panel container, String labelString, final EIURI entityURI, String linkStyle, boolean isInferred, boolean selected) {
        final Label l = new Label(labelString);
        l.setStyleName("link");
        if (!linkStyle.equals("link")) {
            l.addStyleName(linkStyle);
        }
        if (selected) {
            l.addStyleName("selectedResourceType");
        }
        if (isInferred) {
            l.addStyleDependentName("inferred");
        }
        l.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                l.addStyleDependentName("hovering");
            }
        });
        l.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                l.removeStyleDependentName("hovering");
            }
        });
        l.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AbstractCountNavigatorPanel.this.onEntityClick(entityURI);
            }
        });
        container.add((Widget)l);
        return l;
    }

    protected abstract void onEntityClick(EIURI var1);

    protected abstract String getAllLinkLabel();

    public void setRequestPending() {
        this.outer.clear();
        this.outer.add((Widget)this.loadingImage);
    }

    protected void removeLoading() {
        this.outer.remove(this.outer.getWidgetCount() - 1);
    }
}

