/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.sidebar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.SortedSet;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.CountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.ApplicationResources;
import org.eaglei.ui.gwt.UIConstants;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.results.AbstractInstitutionPropertyFilter;
import org.eaglei.ui.gwt.search.results.PropertyFilter;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;
import org.eaglei.ui.gwt.search.sidebar.AbstractSidebarComponent;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.suggest.DataSuggestBox;
import org.eaglei.ui.gwt.suggest.DataSuggestOracle;

public class ResourceProviderSidebarComponent
extends AbstractSidebarComponent
implements SearchContext.SearchListener {
    private InstitutionFilter institutionFilter;
    private ProviderTypeFilter providerTypeFilter;
    private ClassCountResult currentCountResult = null;

    public ResourceProviderSidebarComponent() {
        super("Resource Location");
        if (!ApplicationContext.IS_INSTITUTION) {
            this.institutionFilter = new InstitutionFilter();
            this.main.add((Widget)this.institutionFilter);
        }
        this.providerTypeFilter = new ProviderTypeFilter();
        this.main.add((Widget)this.providerTypeFilter);
        SearchContext.INSTANCE.addListener(this);
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            this.onRequestPending(SearchContext.INSTANCE.getCurrentRequest(), false);
        }
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            this.onResults(SearchContext.INSTANCE.getCurrentResults());
        }
    }

    public void setInstitutions(SortedSet<EIEntity> institutions) {
    }

    public void setSearchRequest(SearchRequest request) {
        if (this.institutionFilter != null) {
            this.institutionFilter.setSearchRequest(request);
        }
    }

    public void setRequestPending() {
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        if (!this.isAttached()) {
            return;
        }
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        if (isPageRequest) {
            return;
        }
        this.setSearchRequest(request);
        this.getProviderTypeCounts(request);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        this.setSearchRequest(results.getResultSet().getRequest());
        if (this.currentCountResult != null) {
            if (!results.getResultSet().getRequest().equals((Object)this.currentCountResult.getSearchRequest())) {
                return;
            }
            this.providerTypeFilter.setClassCountResult(this.currentCountResult);
        }
    }

    private void getProviderTypeCounts(final SearchRequest searchRequest) {
        this.providerTypeFilter.setRequestPending();
        if (searchRequest == null) {
            return;
        }
        if (searchRequest.getDataset() != SearchRequest.DataSet.EI_RESOURCES) {
            return;
        }
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                SearchContext.searchService.getProviderTypeCounts(SessionContext.getSessionId(), searchRequest, new AsyncCallback<ClassCountResult>(){

                    public void onFailure(Throwable caught) {
                        if (caught instanceof InvalidSessionIdException) {
                            SessionContext.INSTANCE.logOut();
                            return;
                        }
                    }

                    public void onSuccess(ClassCountResult result) {
                        if (SearchContext.INSTANCE.getCurrentRequest() == null || !SearchContext.INSTANCE.getCurrentRequest().equals((Object)result.getSearchRequest())) {
                            return;
                        }
                        ResourceProviderSidebarComponent.this.currentCountResult = result;
                        if (SearchContext.INSTANCE.getCurrentResults() != null) {
                            ResourceProviderSidebarComponent.this.providerTypeFilter.setClassCountResult(ResourceProviderSidebarComponent.this.currentCountResult);
                        }
                    }
                });
            }
        });
    }

    static class LaboratorySuggestBox
    extends DataSuggestBox {
        public LaboratorySuggestBox(DataSuggestOracle oracle) {
            super(oracle);
        }

        @Override
        public String getDefaultText() {
            return "Resource Location Name";
        }
    }

    class ProviderTypeFilter
    extends PropertyFilter {
        protected final VerticalPanel outer;
        private Image loadingImage;

        protected ProviderTypeFilter() {
            super(null);
            this.outer = new VerticalPanel();
            this.loadingImage = new Image(ApplicationResources.INSTANCE.loadingSmall());
            this.add((Widget)this.outer);
        }

        public void setClassCountResult(ClassCountResult c) {
            this.outer.clear();
            EIURI providerType = c.getSearchRequest().getProviderType();
            for (CountResult r : c.getSubClassCounts()) {
                final EIEntity entity = r.getEntity();
                CheckBox checkBox = new CheckBox(UIConstants.topLevelOrganizationTypePlurals.get(entity.getLabel()) + " (" + r.getCount() + ")");
                checkBox.setValue(Boolean.valueOf(entity.getURI().equals((Object)providerType)), false);
                checkBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        ProviderTypeFilter.this.executeSearch((Boolean)event.getValue() != false ? entity : null);
                    }
                });
                this.outer.add((Widget)checkBox);
            }
        }

        public void setRequestPending() {
            this.outer.clear();
            this.outer.add((Widget)this.loadingImage);
        }

        private void executeSearch(EIEntity providerEntity) {
            SearchRequest newRequest;
            SearchRequest previousRequest = SearchContext.INSTANCE.getCurrentRequest();
            if (previousRequest != null) {
                newRequest = new SearchRequest(previousRequest.toURLParams());
                newRequest.setStartIndex(0);
            } else {
                newRequest = new SearchRequest();
            }
            newRequest.setProviderType(providerEntity != null ? providerEntity.getURI() : null);
            newRequest.setProviderTypeLabel(providerEntity != null ? providerEntity.getLabel() : null);
            SearchContext.INSTANCE.search(newRequest);
        }
    }

    class InstitutionFilter
    extends AbstractInstitutionPropertyFilter {
        InstitutionFilter() {
            super(null);
        }

        @Override
        protected String getDefaultItem() {
            return "All Institutions";
        }

        @Override
        protected void fetchInstitutionList() {
            SearchServiceRemoteAsync searchService = (SearchServiceRemoteAsync)GWT.create(SearchServiceRemote.class);
            searchService.getInstitutions(new AsyncCallback<List<EIEntity>>(){

                public void onSuccess(List<EIEntity> result) {
                    InstitutionFilter.this.initInstitutionList(result);
                }

                public void onFailure(Throwable caught) {
                }
            });
        }
    }
}

