/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.suggest.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.lexical.EntityMatchRequest;
import org.eaglei.lexical.SuggestionProvider;
import org.eaglei.lexical.lucene.EntityMatchImpl;
import org.eaglei.model.EIURI;
import org.eaglei.search.harvest.DataHarvester;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DataSuggestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Map<String, String> mapURIToPlural = new HashMap<String, String>(){
        private static final long serialVersionUID = 184521309834214679L;
        {
            this.put("http://purl.obolibrary.org/obo/ERO_0000004", "in Instruments");
            this.put("http://purl.obolibrary.org/obo/ERO_0000005", "in Services");
            this.put("http://purl.obolibrary.org/obo/OBI_0000272", "in Protocols");
            this.put("http://purl.obolibrary.org/obo/ERO_0000071", "in Software");
            this.put("http://purl.obolibrary.org/obo/ERO_0000006", "in Reagents");
            this.put("http://purl.obolibrary.org/obo/ERO_0000015", "in Human Studies");
            this.put("http://purl.obolibrary.org/obo/OBI_0100026", "in Organisms and Viruses");
            this.put("http://purl.obolibrary.org/obo/ERO_0000595", "in Research Opportunities");
            this.put("http://purl.obolibrary.org/obo/ERO_0000020", "in Biological Specimens");
            this.put("http://purl.org/obo/owl/SO%23SO_0001059", "in Genetic Alterations");
            this.put("http://purl.obolibrary.org/obo/ERO_0000002", "in Core Laboratories");
        }
    };
    protected static final Log logger = LogFactory.getLog(DataSuggestServlet.class);
    protected static final boolean DEBUG = logger.isDebugEnabled();
    private SuggestionProvider provider;
    private DataHarvester dataHarvester;

    public void init() {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.provider = (SuggestionProvider)ctx.getBean("autoSuggestProvider");
        this.dataHarvester = (DataHarvester)ctx.getBean("dataHarvester");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        EntityMatchRequest entityRequest = null;
        try {
            String id = request.getParameter("id");
            String asyncCallback = request.getParameter("callback");
            entityRequest = DataSuggestServlet.createRequest(request);
            entityRequest.setMaxMatches(50);
            List suggestions = null;
            if (this.dataHarvester.hasInitialData()) {
                suggestions = this.provider.suggest(entityRequest);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(asyncCallback);
            sb.append("({");
            DataSuggestServlet.writeJsonNameValueString(sb, "id", id);
            sb.append(',');
            sb.append("suggestions");
            sb.append(":[");
            if (suggestions != null && suggestions.size() > 0) {
                int i = 0;
                while (true) {
                    String bindingLabel;
                    EntityMatchImpl suggestion;
                    String bindingURI;
                    String string = bindingURI = (suggestion = (EntityMatchImpl)suggestions.get(i++)).getBindingType() != null ? suggestion.getBindingType() : "<null>";
                    if (suggestion.getBindingType() != null) {
                        bindingLabel = mapURIToPlural.get(suggestion.getBindingType());
                        if (bindingLabel == null) {
                            bindingLabel = "in " + suggestion.getBindingType();
                            logger.error((Object)("No plural display label found for binding uri: " + suggestion.getBindingType()));
                        }
                    } else {
                        bindingLabel = "<null>";
                    }
                    sb.append("\"");
                    sb.append(suggestion.getHighlight());
                    sb.append("\"");
                    sb.append(',');
                    DataSuggestServlet.writeJsonValueString(sb, suggestion.getMatchLabel());
                    sb.append(',');
                    DataSuggestServlet.writeJsonValueString(sb, bindingURI);
                    sb.append(',');
                    DataSuggestServlet.writeJsonValueString(sb, bindingLabel);
                    if (i == suggestions.size()) break;
                    sb.append(',');
                }
            }
            sb.append("]");
            sb.append("})");
            String output = sb.toString();
            response.setContentType("text/javascript");
            response.setCharacterEncoding("UTF-8");
            response.addHeader("Pragma", "no-cache");
            response.setStatus(200);
            PrintWriter out = response.getWriter();
            out.println(output);
        }
        catch (Throwable t) {
            logger.error((Object)("Unexpected error getting suggestions: request: " + entityRequest != null ? entityRequest.toString() : "null"), t);
            throw new ServletException(t);
        }
    }

    private static void writeJsonNameValueString(StringBuilder sb, String name, String value) {
        sb.append(name);
        sb.append(":");
        DataSuggestServlet.writeJsonValueString(sb, value);
    }

    private static void writeJsonValueString(StringBuilder sb, String value) {
        sb.append("\"");
        sb.append(value);
        sb.append("\"");
    }

    private static EntityMatchRequest createRequest(HttpServletRequest httpRequest) {
        String q = httpRequest.getParameter("q");
        q = q.substring(1, q.length() - 1);
        try {
            q = new String(q.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        String classid = httpRequest.getParameter("bt");
        EntityMatchRequest searchRequest = null;
        if (classid == null) {
            searchRequest = new EntityMatchRequest(q);
        } else {
            try {
                String decodedClassId = URLDecoder.decode(classid, "UTF-8");
                searchRequest = new EntityMatchRequest(q, EIURI.create((String)decodedClassId));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e);
            }
        }
        String property = httpRequest.getParameter("prop");
        if (property != null) {
            searchRequest.setProperty(property);
        }
        return searchRequest;
    }
}

