/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.load.java.components.DescriptorResolverUtils;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.load.kotlin.BinaryClassAnnotationAndConstantLoaderImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BinaryClassAnnotationAndConstantLoaderImpl
extends AbstractBinaryClassAnnotationAndConstantLoader<AnnotationDescriptor, ConstantValue<?>> {
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final NotFoundClasses notFoundClasses;
    @NotNull
    private final AnnotationDeserializer annotationDeserializer;

    public BinaryClassAnnotationAndConstantLoaderImpl(@NotNull ModuleDescriptor module, @NotNull NotFoundClasses notFoundClasses, @NotNull StorageManager storageManager, @NotNull KotlinClassFinder kotlinClassFinder) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)notFoundClasses, (String)"notFoundClasses");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"kotlinClassFinder");
        super(storageManager, kotlinClassFinder);
        this.module = module;
        this.notFoundClasses = notFoundClasses;
        this.annotationDeserializer = new AnnotationDeserializer(this.module, this.notFoundClasses);
    }

    @Override
    @NotNull
    protected AnnotationDescriptor loadTypeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        return this.annotationDeserializer.deserializeAnnotation(proto, nameResolver);
    }

    @Override
    @Nullable
    protected ConstantValue<?> loadConstant(@NotNull String desc, @NotNull Object initializer) {
        Object object;
        block18: {
            block16: {
                Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                Intrinsics.checkNotNullParameter((Object)initializer, (String)"initializer");
                if (!StringsKt.contains$default((CharSequence)"ZBCS", (CharSequence)desc, (boolean)false, (int)2, null)) break block16;
                int intValue = (Integer)initializer;
                switch (desc) {
                    case "Z": {
                        object = intValue != 0;
                        break block18;
                    }
                    case "B": {
                        object = (byte)intValue;
                        break block18;
                    }
                    case "C": {
                        object = Character.valueOf((char)intValue);
                        break block18;
                    }
                    case "S": {
                        object = (short)intValue;
                        break block18;
                    }
                    default: {
                        throw new AssertionError((Object)desc);
                    }
                }
            }
            object = initializer;
        }
        Object normalizedValue = object;
        return ConstantValueFactory.INSTANCE.createConstantValue(normalizedValue);
    }

    @Override
    @Nullable
    protected ConstantValue<?> transformToUnsignedConstant(@NotNull ConstantValue<?> constant) {
        Intrinsics.checkNotNullParameter(constant, (String)"constant");
        ConstantValue constantValue = constant;
        return constantValue instanceof ByteValue ? (ConstantValue)new UByteValue(((Number)((ByteValue)constant).getValue()).byteValue()) : (constantValue instanceof ShortValue ? (ConstantValue)new UShortValue(((Number)((ShortValue)constant).getValue()).shortValue()) : (constantValue instanceof IntValue ? (ConstantValue)new UIntValue(((Number)((IntValue)constant).getValue()).intValue()) : (constantValue instanceof LongValue ? (ConstantValue)new ULongValue(((Number)((LongValue)constant).getValue()).longValue()) : constant)));
    }

    @Override
    @Nullable
    protected KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotation(@NotNull ClassId annotationClassId, @NotNull SourceElement source, @NotNull List<AnnotationDescriptor> result2) {
        Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        ClassDescriptor annotationClass = this.resolveClass(annotationClassId);
        return new KotlinJvmBinaryClass.AnnotationArgumentVisitor(annotationClass, this, result2, source){
            @NotNull
            private final HashMap<Name, ConstantValue<?>> arguments;
            final /* synthetic */ ClassDescriptor $annotationClass;
            final /* synthetic */ BinaryClassAnnotationAndConstantLoaderImpl this$0;
            final /* synthetic */ List<AnnotationDescriptor> $result;
            final /* synthetic */ SourceElement $source;
            {
                this.$annotationClass = $annotationClass;
                this.this$0 = $receiver;
                this.$result = $result;
                this.$source = $source;
                this.arguments = new HashMap<K, V>();
            }

            public void visit(@Nullable Name name, @Nullable Object value) {
                if (name != null) {
                    Map map = this.arguments;
                    ConstantValue<?> constantValue = this.createConstant(name, value);
                    boolean bl = false;
                    map.put(name, constantValue);
                }
            }

            public void visitClassLiteral(@NotNull Name name, @NotNull ClassLiteralValue value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Map map = this.arguments;
                KClassValue kClassValue = new KClassValue(value);
                boolean bl = false;
                map.put(name, kClassValue);
            }

            public void visitEnum(@NotNull Name name, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
                Intrinsics.checkNotNullParameter((Object)enumEntryName, (String)"enumEntryName");
                Map map = this.arguments;
                EnumValue enumValue = new EnumValue(enumClassId, enumEntryName);
                boolean bl = false;
                map.put(name, enumValue);
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor(this, name, this.$annotationClass){
                    @NotNull
                    private final ArrayList<ConstantValue<?>> elements;
                    final /* synthetic */ loadAnnotation.1 this$0;
                    final /* synthetic */ Name $name;
                    final /* synthetic */ ClassDescriptor $annotationClass;
                    {
                        this.this$0 = $receiver;
                        this.$name = $name;
                        this.$annotationClass = $annotationClass;
                        this.elements = new ArrayList<E>();
                    }

                    public void visit(@Nullable Object value) {
                        this.elements.add(loadAnnotation.1.access$createConstant(this.this$0, this.$name, value));
                    }

                    public void visitEnum(@NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                        Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
                        Intrinsics.checkNotNullParameter((Object)enumEntryName, (String)"enumEntryName");
                        this.elements.add(new EnumValue(enumClassId, enumEntryName));
                    }

                    public void visitClassLiteral(@NotNull ClassLiteralValue value) {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        this.elements.add(new KClassValue(value));
                    }

                    public void visitEnd() {
                        ValueParameterDescriptor parameter = DescriptorResolverUtils.getAnnotationParameterByName(this.$name, this.$annotationClass);
                        if (parameter != null) {
                            Map map = loadAnnotation.1.access$getArguments$p(this.this$0);
                            Name name = this.$name;
                            List<ConstantValue<?>> list = kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.compact(this.elements);
                            Object object = parameter.getType();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameter.type");
                            object = ConstantValueFactory.INSTANCE.createArrayValue(list, (KotlinType)object);
                            boolean bl = false;
                            map.put(name, object);
                        }
                    }
                };
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull Name name, @NotNull ClassId classId) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                ArrayList<AnnotationDescriptor> list = new ArrayList<AnnotationDescriptor>();
                SourceElement sourceElement = SourceElement.NO_SOURCE;
                Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
                KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = this.this$0.loadAnnotation(classId, sourceElement, (List<AnnotationDescriptor>)list);
                Intrinsics.checkNotNull((Object)annotationArgumentVisitor);
                KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2 = annotationArgumentVisitor;
                return new KotlinJvmBinaryClass.AnnotationArgumentVisitor(visitor2, this, name, list){
                    private final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $$delegate_0;
                    final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor $visitor;
                    final /* synthetic */ loadAnnotation.1 this$0;
                    final /* synthetic */ Name $name;
                    final /* synthetic */ ArrayList<AnnotationDescriptor> $list;
                    {
                        this.$visitor = $visitor;
                        this.this$0 = $receiver;
                        this.$name = $name;
                        this.$list = $list;
                        this.$$delegate_0 = this.$visitor;
                    }

                    public void visit(@Nullable Name name, @Nullable Object value) {
                        this.$$delegate_0.visit(name, value);
                    }

                    @Nullable
                    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull Name name, @NotNull ClassId classId) {
                        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                        return this.$$delegate_0.visitAnnotation(name, classId);
                    }

                    @Nullable
                    public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name) {
                        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                        return this.$$delegate_0.visitArray(name);
                    }

                    public void visitClassLiteral(@NotNull Name name, @NotNull ClassLiteralValue value) {
                        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        this.$$delegate_0.visitClassLiteral(name, value);
                    }

                    public void visitEnum(@NotNull Name name, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                        Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
                        Intrinsics.checkNotNullParameter((Object)enumEntryName, (String)"enumEntryName");
                        this.$$delegate_0.visitEnum(name, enumClassId, enumEntryName);
                    }

                    public void visitEnd() {
                        this.$visitor.visitEnd();
                        Map map = loadAnnotation.1.access$getArguments$p(this.this$0);
                        Name name = this.$name;
                        AnnotationValue annotationValue = new AnnotationValue((AnnotationDescriptor)CollectionsKt.single((List)this.$list));
                        boolean bl = false;
                        map.put(name, annotationValue);
                    }
                };
            }

            public void visitEnd() {
                this.$result.add(new AnnotationDescriptorImpl(this.$annotationClass.getDefaultType(), (Map)this.arguments, this.$source));
            }

            private final ConstantValue<?> createConstant(Name name, Object value) {
                ConstantValue constantValue = ConstantValueFactory.INSTANCE.createConstantValue(value);
                return constantValue == null ? (ConstantValue)ErrorValue.Companion.create(Intrinsics.stringPlus((String)"Unsupported annotation argument: ", (Object)name)) : constantValue;
            }

            public static final /* synthetic */ ConstantValue access$createConstant(loadAnnotation.1 $this, Name name, Object value) {
                return $this.createConstant(name, value);
            }

            public static final /* synthetic */ HashMap access$getArguments$p(loadAnnotation.1 $this) {
                return $this.arguments;
            }
        };
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }
}

