/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.internal;

import java.io.FileInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.internal.eventadmin.EventAdminTracker;
import org.ops4j.pax.logging.log4j2.internal.FrameworkHandler;
import org.ops4j.pax.logging.log4j2.internal.JdkHandler;
import org.ops4j.pax.logging.log4j2.internal.LogReaderServiceImpl;
import org.ops4j.pax.logging.log4j2.internal.PaxLoggingServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    public static final String CONFIGURATION_PID = "org.ops4j.pax.logging";
    public static final String PAX_LOGGING_PROPERTY_FILE_KEY = "org.ops4j.pax.logging.property.file";
    public static final String PAX_LOGGING_PROPERTY_FILE = "pax-logging.properties";
    private static final String[] LOGSERVICE_NAMES = new String[]{LogService.class.getName(), org.knopflerfish.service.log.LogService.class.getName(), PaxLoggingService.class.getName(), ManagedService.class.getName()};
    private PaxLoggingServiceImpl m_PaxLogging;
    private ServiceRegistration m_RegistrationPaxLogging;
    private JdkHandler m_JdkHandler;
    private ServiceRegistration m_registrationLogReaderService;
    private FrameworkHandler m_frameworkHandler;
    private EventAdminPoster m_eventAdmin;

    public void start(BundleContext bundleContext) throws Exception {
        int ranking = 1;
        String rankingProperty = bundleContext.getProperty("org.ops4j.pax.logging.ranking");
        if (rankingProperty != null) {
            ranking = Integer.parseInt(rankingProperty);
        }
        LogReaderServiceImpl logReader = new LogReaderServiceImpl(100);
        String readerServiceName = LogReaderService.class.getName();
        Hashtable<String, Object> serviceProperties = new Hashtable<String, Object>();
        serviceProperties.put("service.ranking", ranking);
        this.m_registrationLogReaderService = bundleContext.registerService(readerServiceName, (Object)logReader, serviceProperties);
        try {
            this.m_eventAdmin = new EventAdminTracker(bundleContext);
        }
        catch (NoClassDefFoundError e) {
            this.m_eventAdmin = new EventAdminPoster(){

                public void postEvent(Bundle bundle, int level, LogEntry entry, String message, Throwable exception, ServiceReference sr, Map context) {
                }

                public void destroy() {
                }
            };
        }
        this.m_PaxLogging = new PaxLoggingServiceImpl(bundleContext, logReader, this.m_eventAdmin);
        Path configFilePath = Paths.get(System.getProperty(PAX_LOGGING_PROPERTY_FILE_KEY, PAX_LOGGING_PROPERTY_FILE), new String[0]);
        if (configFilePath.toFile().exists()) {
            try (FileInputStream inputStream = new FileInputStream(configFilePath.toFile());){
                Properties properties = new Properties();
                properties.load(inputStream);
                Hashtable<String, String> configurations = new Hashtable<String, String>();
                StrSubstitutor strSubstitutor = new StrSubstitutor(System.getProperties());
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String propValue = (String)entry.getValue();
                    propValue = strSubstitutor.replace(propValue);
                    configurations.put((String)entry.getKey(), propValue);
                }
                ServiceReference configurationAdminSR = bundleContext.getServiceReference(ConfigurationAdmin.class);
                if (configurationAdminSR != null) {
                    ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(configurationAdminSR);
                    Configuration configuration = configurationAdmin.getConfiguration(CONFIGURATION_PID, null);
                    configuration.update(configurations);
                }
                this.m_PaxLogging.updated(configurations);
            }
        }
        serviceProperties = new Hashtable();
        serviceProperties.put("service.id", "org.ops4j.pax.logging.configuration");
        serviceProperties.put("service.pid", CONFIGURATION_PID);
        serviceProperties.put("service.ranking", ranking);
        this.m_RegistrationPaxLogging = bundleContext.registerService(LOGSERVICE_NAMES, (Object)this.m_PaxLogging, serviceProperties);
        String skipJULProperty = bundleContext.getProperty("org.ops4j.pax.logging.skipJUL");
        if (!Boolean.parseBoolean(skipJULProperty)) {
            Handler[] handlers;
            LogManager manager = LogManager.getLogManager();
            if (!Boolean.valueOf(bundleContext.getProperty("org.ops4j.pax.logging.skipJULReset")).booleanValue()) {
                manager.reset();
            }
            Logger rootLogger = manager.getLogger("");
            for (Handler handler : handlers = rootLogger.getHandlers()) {
                rootLogger.removeHandler(handler);
            }
            rootLogger.setFilter(null);
            this.m_JdkHandler = new JdkHandler(this.m_PaxLogging);
            rootLogger.addHandler(this.m_JdkHandler);
        }
        this.m_frameworkHandler = new FrameworkHandler(this.m_PaxLogging);
        bundleContext.addBundleListener((BundleListener)this.m_frameworkHandler);
        bundleContext.addFrameworkListener((FrameworkListener)this.m_frameworkHandler);
        bundleContext.addServiceListener((ServiceListener)this.m_frameworkHandler);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.m_eventAdmin.destroy();
        bundleContext.removeBundleListener((BundleListener)this.m_frameworkHandler);
        bundleContext.removeFrameworkListener((FrameworkListener)this.m_frameworkHandler);
        bundleContext.removeServiceListener((ServiceListener)this.m_frameworkHandler);
        if (this.m_JdkHandler != null) {
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            rootLogger.removeHandler(this.m_JdkHandler);
            this.m_JdkHandler.flush();
            this.m_JdkHandler.close();
            this.m_JdkHandler = null;
        }
        this.m_RegistrationPaxLogging.unregister();
        this.m_RegistrationPaxLogging = null;
        if (this.m_PaxLogging != null) {
            this.m_PaxLogging.shutdown();
            this.m_PaxLogging = null;
        }
        this.m_registrationLogReaderService.unregister();
        this.m_registrationLogReaderService = null;
    }
}

