/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sbt.internal.inc.IndexBasedZipFsOps$;
import sbt.internal.inc.IndexBasedZipOps;
import sbt.internal.inc.JarUtils;
import sbt.internal.inc.JarUtils$ClassInJar$;
import sbt.internal.inc.JarUtils$NoOutputJar$;
import sbt.internal.inc.zip.ZipCentralDir;
import sbt.io.IO$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import xsbti.compile.Output;
import xsbti.compile.SingleOutput;

public final class JarUtils$ {
    public static final JarUtils$ MODULE$ = new JarUtils$();
    private static final Set<String> scalacOptions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-YdisableFlatCpCaching"}));
    private static final Set<String> javacOptions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-XDuseOptimizedZip=false"}));
    private static Path tempDir;
    private static final String prevJarPrefix;

    static {
        prevJarPrefix = "prev-jar";
    }

    public Set<String> scalacOptions() {
        return scalacOptions;
    }

    public Set<String> javacOptions() {
        return javacOptions;
    }

    public ZipCentralDir stashIndex(Path jar) {
        return (ZipCentralDir)IndexBasedZipFsOps$.MODULE$.readCentralDir(jar.toFile());
    }

    public void unstashIndex(Path jar, ZipCentralDir index) {
        IndexBasedZipFsOps$.MODULE$.writeCentralDir(jar.toFile(), index);
    }

    public void includeInJar(File jar, Seq<Tuple2<File, String>> files) {
        IndexBasedZipFsOps$.MODULE$.includeInArchive(jar, (Seq<Tuple2<File, String>>)files.toVector());
    }

    public void mergeJars(File into, File from) {
        IndexBasedZipFsOps$.MODULE$.mergeArchives(into, from);
    }

    public Seq<String> listClassFiles(File jar) {
        return (Seq)IndexBasedZipFsOps$.MODULE$.listEntries(jar).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.endsWith(".class")));
    }

    public Seq<String> listFiles(Path jar) {
        return IndexBasedZipFsOps$.MODULE$.listEntries(jar.toFile());
    }

    public void removeFromJar(Path jarFile, Iterable<String> classes) {
        block0: {
            if (!Files.exists(jarFile, new LinkOption[0])) break block0;
            IndexBasedZipFsOps$.MODULE$.removeEntries(jarFile.toFile(), classes);
        }
    }

    public Function1<Path, Object> readStamps(Path jar) {
        IndexBasedZipOps.CachedStamps stamps = IndexBasedZipFsOps$.MODULE$.new IndexBasedZipOps.CachedStamps(jar);
        return (Function1 & Serializable)file -> BoxesRunTime.boxToLong((long)JarUtils$.$anonfun$readStamps$1(stamps, jar, file));
    }

    public void withPreviousJar(Output output, Function1<Seq<Path>, BoxedUnit> compile) {
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<File, File>> option = this.preparePreviousJar(output);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            File prevJar = (File)tuple2._1();
            File outputJar = (File)tuple2._2();
            try {
                compile.apply((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{prevJar.toPath()})));
            }
            catch (Exception e) {
                IO$.MODULE$.move(prevJar, outputJar);
                throw e;
            }
            this.cleanupPreviousJar(prevJar, outputJar);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = (BoxedUnit)compile.apply((Object)package$.MODULE$.Nil());
        } else {
            throw new MatchError(option);
        }
    }

    public Option<Tuple2<File, File>> preparePreviousJar(Output output) {
        return this.getOutputJar(output).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JarUtils$.$anonfun$preparePreviousJar$1(x$2))).map((Function1 & Serializable)outputJar -> {
            File prevJar = MODULE$.createPrevJarPath();
            File out = outputJar.toFile();
            IO$.MODULE$.move(out, prevJar);
            return new Tuple2((Object)prevJar, (Object)out);
        });
    }

    public void cleanupPreviousJar(File prevJar, File outputJar) {
        if (outputJar.exists()) {
            this.mergeJars(prevJar, outputJar);
        }
        IO$.MODULE$.move(prevJar, outputJar);
    }

    private Path tempDir() {
        return tempDir;
    }

    private void tempDir_$eq(Path x$1) {
        tempDir = x$1;
    }

    public void setupTempClassesDir(Option<Path> temporaryClassesDirectory) {
        Option<Path> option = temporaryClassesDirectory;
        if (option instanceof Some) {
            Some some = (Some)option;
            Path dir = (Path)some.value();
            Files.createDirectories(dir, new FileAttribute[0]);
            this.tempDir_$eq(dir);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.tempDir_$eq(new File(IO$.MODULE$.temporaryDirectory(), "zinc_temp_classes_dir").toPath());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    private File createPrevJarPath() {
        String prevJarName = new StringBuilder(5).append(this.prevJarPrefix()).append("-").append(UUID.randomUUID()).append(".jar").toString();
        return this.tempDir().resolve(prevJarName).toFile();
    }

    public String prevJarPrefix() {
        return prevJarPrefix;
    }

    public boolean isClassInJar(File file) {
        boolean bl;
        Object object;
        String[] stringArray = file.toString().split("!");
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
            String jar = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            bl = jar.endsWith(".jar");
        } else {
            bl = false;
        }
        return bl;
    }

    public Option<Path> getJarInClassInJar(Path path) {
        String jar;
        Object object;
        String[] stringArray = ((Object)path).toString().split("!");
        Object object2 = stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0 && (jar = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0)).toString().endsWith(".jar") ? new Some((Object)Paths.get(jar, new String[0])) : None$.MODULE$;
        return object2;
    }

    public boolean isCompilingToJar(Output output) {
        return this.getOutputJar(output).isDefined();
    }

    public Option<Path> getOutputJar(Output output) {
        None$ none$;
        Output output2 = output;
        if (output2 instanceof SingleOutput) {
            SingleOutput singleOutput = (SingleOutput)output2;
            none$ = new Some((Object)singleOutput.getOutputDirectoryAsPath()).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)JarUtils$.$anonfun$getOutputJar$1(x$4)));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Path javacTempOutput(Path outputJar) {
        String outJarName = ((Object)outputJar.getFileName()).toString();
        String outDirName = new StringBuilder(13).append(outJarName).append("-javac-output").toString();
        return outputJar.resolveSibling(outDirName);
    }

    public JarUtils.OutputJarContent createOutputJarContent(Output output) {
        JarUtils.OutputJarContent outputJarContent;
        Option<Path> option = this.getOutputJar(output);
        if (option instanceof Some) {
            Some some = (Some)option;
            Path jar = (Path)some.value();
            outputJarContent = new JarUtils.ValidOutputJarContent(jar);
        } else if (None$.MODULE$.equals(option)) {
            outputJarContent = JarUtils$NoOutputJar$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return outputJarContent;
    }

    public long readModifiedTime(String jc) {
        Tuple2<File, Option<String>> tuple2 = JarUtils$ClassInJar$.MODULE$.splitJarReference$extension(jc);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        File jar = (File)tuple2._1();
        Option cls = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)jar, (Object)cls);
        Tuple2 tuple23 = tuple22;
        File jar2 = (File)tuple23._1();
        Option cls2 = (Option)tuple23._2();
        return jar2.exists() ? BoxesRunTime.unboxToLong(this.withZipFile(jar2, (Function1 & Serializable)zip -> BoxesRunTime.boxToLong((long)JarUtils$.$anonfun$readModifiedTime$1(cls2, zip)))) : 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean exists(String jc) {
        Tuple2<File, Option<String>> tuple2 = JarUtils$ClassInJar$.MODULE$.splitJarReference$extension(jc);
        if (tuple2 == null) throw new MatchError(tuple2);
        File jar = (File)tuple2._1();
        Option clsOpt = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)jar, (Object)clsOpt);
        Tuple2 tuple23 = tuple22;
        File jar2 = (File)tuple23._1();
        Option clsOpt2 = (Option)tuple23._2();
        if (!jar2.exists()) return false;
        Option option = clsOpt2;
        if (!(option instanceof Some)) return true;
        Some some = (Some)option;
        String cls = (String)some.value();
        boolean bl = BoxesRunTime.unboxToBoolean(this.withZipFile(jar2, (Function1 & Serializable)zip -> BoxesRunTime.boxToBoolean((boolean)JarUtils$.$anonfun$exists$1(cls, zip))));
        if (!bl) return false;
        return true;
    }

    private <A> A withZipFile(File zip, Function1<ZipFile, A> f) {
        Object object;
        try (ZipFile file = new ZipFile(zip);){
            object = f.apply((Object)file);
        }
        return (A)object;
    }

    public static final /* synthetic */ long $anonfun$readStamps$1(IndexBasedZipOps.CachedStamps stamps$1, Path jar$1, Path file) {
        URL u = file.toUri().toURL();
        return stamps$1.getStamp((String)JarUtils$ClassInJar$.MODULE$.toClassFilePath$extension(JarUtils$ClassInJar$.MODULE$.fromURL(u, jar$1)).get());
    }

    public static final /* synthetic */ boolean $anonfun$preparePreviousJar$1(Path x$2) {
        return Files.exists(x$2, new LinkOption[0]);
    }

    public static final /* synthetic */ boolean $anonfun$getOutputJar$1(Path x$4) {
        return ((Object)x$4).toString().endsWith(".jar");
    }

    public static final /* synthetic */ long $anonfun$readModifiedTime$2(ZipEntry x$6) {
        return x$6.getLastModifiedTime().toMillis();
    }

    public static final /* synthetic */ long $anonfun$readModifiedTime$1(Option cls$1, ZipFile zip) {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)zip.getEntry((String)cls$1.get())).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)JarUtils$.$anonfun$readModifiedTime$2(x$6))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ boolean $anonfun$exists$1(String cls$2, ZipFile zip) {
        return zip.getEntry(cls$2) != null;
    }

    private JarUtils$() {
    }
}

