/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.binary.converters;

import java.io.Serializable;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import sbt.internal.inc.APIs;
import sbt.internal.inc.APIs$;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.Analysis$;
import sbt.internal.inc.Compilation;
import sbt.internal.inc.Compilations;
import sbt.internal.inc.Compilations$;
import sbt.internal.inc.CompileOutput$;
import sbt.internal.inc.EmptyStamp$;
import sbt.internal.inc.ExternalDependencies;
import sbt.internal.inc.FarmHash$;
import sbt.internal.inc.Hash$;
import sbt.internal.inc.InternalDependencies;
import sbt.internal.inc.LastModified;
import sbt.internal.inc.RelationBuilder;
import sbt.internal.inc.Relations;
import sbt.internal.inc.Relations$;
import sbt.internal.inc.Schema;
import sbt.internal.inc.SourceInfos;
import sbt.internal.inc.SourceInfos$;
import sbt.internal.inc.Stamps;
import sbt.internal.inc.Stamps$;
import sbt.internal.inc.UsedNames;
import sbt.internal.inc.UsedNames$;
import sbt.internal.inc.binary.converters.InternalApiProxy$Modifiers$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$EmptyLazyCompanions$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$Feedback$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$Feedback$Readers$;
import sbt.internal.inc.binary.converters.ProtobufDefaults$ReadersConstants$;
import sbt.internal.util.Relation;
import sbt.util.InterfaceUtil$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapFactoryDefaults;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import xsbti.DiagnosticCode;
import xsbti.DiagnosticRelatedInformation;
import xsbti.Position;
import xsbti.Problem;
import xsbti.Severity;
import xsbti.T2;
import xsbti.UseScope;
import xsbti.VirtualFileRef;
import xsbti.api.Access;
import xsbti.api.AnalyzedClass;
import xsbti.api.Annotated;
import xsbti.api.Annotation;
import xsbti.api.AnnotationArgument;
import xsbti.api.ClassDefinition;
import xsbti.api.ClassLike;
import xsbti.api.ClassLikeDef;
import xsbti.api.Companions;
import xsbti.api.Constant;
import xsbti.api.Def;
import xsbti.api.DefinitionType;
import xsbti.api.DependencyContext;
import xsbti.api.Existential;
import xsbti.api.Id;
import xsbti.api.IdQualifier;
import xsbti.api.Lazy;
import xsbti.api.MethodParameter;
import xsbti.api.Modifiers;
import xsbti.api.NameHash;
import xsbti.api.ParameterList;
import xsbti.api.ParameterModifier;
import xsbti.api.ParameterRef;
import xsbti.api.Parameterized;
import xsbti.api.Path;
import xsbti.api.PathComponent;
import xsbti.api.Polymorphic;
import xsbti.api.Private;
import xsbti.api.Projection;
import xsbti.api.Protected;
import xsbti.api.Public;
import xsbti.api.Qualifier;
import xsbti.api.SafeLazyProxy$;
import xsbti.api.Singleton;
import xsbti.api.Structure;
import xsbti.api.Super;
import xsbti.api.Type;
import xsbti.api.TypeAlias;
import xsbti.api.TypeDeclaration;
import xsbti.api.TypeParameter;
import xsbti.api.Val;
import xsbti.api.Var;
import xsbti.api.Variance;
import xsbti.compile.CompileOrder;
import xsbti.compile.FileHash;
import xsbti.compile.MiniOptions;
import xsbti.compile.MiniSetup;
import xsbti.compile.Output;
import xsbti.compile.OutputGroup;
import xsbti.compile.analysis.ReadMapper;
import xsbti.compile.analysis.SourceInfo;
import xsbti.compile.analysis.Stamp;

@ScalaSignature(bytes="\u0006\u0005\u0011ug\u0001B\"E\u0005=C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\tC\u0002\u0011\t\u0011)A\u0005E\")!\u000e\u0001C\u0001W\")\u0001\u000f\u0001C\u0001c\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001bBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!a\u0019\u0001\t\u0003\t)\u0007C\u0004\u0002x\u0001!\t!!\u001f\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAT\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003\u0007\u0004A\u0011BAc\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'Dq!!:\u0001\t\u0013\t9\u000fC\u0004\u0002x\u0002!I!!?\t\u000f\t%\u0001\u0001\"\u0001\u0003\f!9!1\u0004\u0001\u0005\u0002\tu\u0001b\u0002B\u0017\u0001\u0011\u0005!q\u0006\u0005\b\u0005\u007f\u0001A\u0011\u0001B!\u0011\u001d\u0011\t\u0006\u0001C\u0001\u0005'BqAa\u0019\u0001\t\u0003\u0011)\u0007C\u0004\u0003x\u0001!\tA!\u001f\t\u000f\t-\u0005\u0001\"\u0001\u0003\u000e\"9!\u0011\u0014\u0001\u0005\u0002\tmeA\u0002BR\u0001\u0005\u0011)\u000b\u0003\u0006\u0003*n\u0011\t\u0011)A\u0005\u0005WCaA[\u000e\u0005\u0002\t5\u0007b\u0002Bk7\u0011\u0005!q\u001b\u0005\n\u0007\u000b\u0001\u0011\u0011!C\u0002\u0007\u000f1aa!\u0006\u0001\u0003\r]\u0001BCB\u000eA\t\u0005\t\u0015!\u0003\u0004\u001e!1!\u000e\tC\u0001\u0007GAqa!\u000b!\t\u0003\u0019Y\u0003C\u0005\u0004D\u0001\t\t\u0011b\u0001\u0004F!911\u000b\u0001\u0005\u0002\rU\u0003bBB4\u0001\u0011\u00051\u0011\u000e\u0005\b\u0007s\u0002A\u0011AB>\u0011\u001d\u0019\u0019\n\u0001C\u0001\u0007+Cqa!*\u0001\t\u0003\u00199\u000bC\u0004\u00048\u0002!\ta!/\t\u000f\r%\u0007\u0001\"\u0001\u0004L\"911\u001c\u0001\u0005\u0002\ru\u0007bBBw\u0001\u0011\u00051q\u001e\u0005\b\u0007\u007f\u0004A\u0011\u0001C\u0001\u0011\u001d!\t\u0002\u0001C\u0001\t'Aq\u0001\"\n\u0001\t\u0003!9\u0003C\u0005\u0005d\u0001\u0011\r\u0011\"\u0004\u0005f!AA\u0011\u000e\u0001!\u0002\u001b!9\u0007C\u0005\u0005l\u0001\u0011\r\u0011\"\u0004\u0005n!AA\u0011\u000f\u0001!\u0002\u001b!y\u0007C\u0005\u0005t\u0001\u0011\r\u0011\"\u0004\u0005n!AAQ\u000f\u0001!\u0002\u001b!y\u0007C\u0005\u0005x\u0001\u0011\r\u0011\"\u0004\u0005n!AA\u0011\u0010\u0001!\u0002\u001b!y\u0007C\u0004\u0005|\u0001!\t\u0001\" \t\u000f\u00115\u0005\u0001\"\u0001\u0005\u0010\"9A1\u0015\u0001\u0005\u0002\u0011\u0015\u0006b\u0002C]\u0001\u0011\u0005A1\u0018\u0005\b\t\u0013\u0004A\u0011\u0001Cf\r\u0019!I\u0005\u0001\u0003\u0005L!1!N\u0010C\u0001\t\u001bB\u0011\u0002b\u0014?\u0005\u0004%I\u0001\"\u0015\t\u0011\u0011ec\b)A\u0005\t'Bq\u0001b\u0017?\t\u0003!iFA\bQe>$xNY;g%\u0016\fG-\u001a:t\u0015\t)e)\u0001\u0006d_:4XM\u001d;feNT!a\u0012%\u0002\r\tLg.\u0019:z\u0015\tI%*A\u0002j]\u000eT!a\u0013'\u0002\u0011%tG/\u001a:oC2T\u0011!T\u0001\u0004g\n$8\u0001A\n\u0003\u0001A\u0003\"!\u0015+\u000e\u0003IS\u0011aU\u0001\u0006g\u000e\fG.Y\u0005\u0003+J\u0013a!\u00118z%\u00164\u0017AB7baB,'\u000f\u0005\u0002Y?6\t\u0011L\u0003\u0002[7\u0006A\u0011M\\1msNL7O\u0003\u0002];\u000691m\\7qS2,'\"\u00010\u0002\u000ba\u001c(\r^5\n\u0005\u0001L&A\u0003*fC\u0012l\u0015\r\u001d9fe\u0006q1-\u001e:sK:$h+\u001a:tS>t\u0007CA2h\u001d\t!W-D\u0001I\u0013\t1\u0007*\u0001\u0004TG\",W.Y\u0005\u0003Q&\u0014qAV3sg&|gN\u0003\u0002g\u0011\u00061A(\u001b8jiz\"2\u0001\u001c8p!\ti\u0007!D\u0001E\u0011\u001516\u00011\u0001X\u0011\u0015\t7\u00011\u0001c\u000391'o\\7QCRD7\u000b\u001e:j]\u001e$\"A\u001d?\u0011\u0005MTX\"\u0001;\u000b\u0005U4\u0018\u0001\u00024jY\u0016T!a\u001e=\u0002\u00079LwNC\u0001z\u0003\u0011Q\u0017M^1\n\u0005m$(\u0001\u0002)bi\"DQ! \u0003A\u0002y\fA\u0001]1uQB\u0019q0!\u0004\u000f\t\u0005\u0005\u0011\u0011\u0002\t\u0004\u0003\u0007\u0011VBAA\u0003\u0015\r\t9AT\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-!+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\t\tB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017\u0011\u0016a\u00044s_6\u0004\u0016\r\u001e5TiJLgn\u001a,\u0015\t\u0005]\u0011q\u0004\t\u0005\u00033\tY\"D\u0001^\u0013\r\ti\"\u0018\u0002\u000f-&\u0014H/^1m\r&dWMU3g\u0011\u0015iX\u00011\u0001\u007f\u000351'o\\7Ti\u0006l\u0007\u000fV=qKR!\u0011QEA\u0016!\rA\u0016qE\u0005\u0004\u0003SI&!B*uC6\u0004\bbBA\u0017\r\u0001\u0007\u0011qF\u0001\ngR\fW\u000e\u001d+za\u0016\u0004B!!\r\u000289\u00191-a\r\n\u0007\u0005U\u0012.\u0001\u0004Ti\u0006l\u0007o]\u0005\u0005\u0003s\tYDA\u0005Ti\u0006l\u0007\u000fV=qK*\u0019\u0011QG5\u0002\u0015\u0019\u0014x.\\*uC6\u00048\u000f\u0006\u0003\u0002B\u0005\u001d\u0003c\u00013\u0002D%\u0019\u0011Q\t%\u0003\rM#\u0018-\u001c9t\u0011\u001d\tIe\u0002a\u0001\u0003\u0017\naa\u001d;b[B\u001c\bcA2\u0002N%\u0019\u0011QI5\u0002\u001f\u0019\u0014x.\\(viB,Ho\u0012:pkB$B!a\u0015\u0002\\A!\u0011QKA,\u001b\u0005Y\u0016bAA-7\nYq*\u001e;qkR<%o\\;q\u0011\u001d\ti\u0006\u0003a\u0001\u0003?\n1b\\;uaV$xI]8vaB\u00191-!\u0019\n\u0007\u0005e\u0013.A\u000bge>l7i\\7qS2\fG/[8o\u001fV$\b/\u001e;\u0015\t\u0005\u001d\u0014Q\u000e\t\u0005\u0003+\nI'C\u0002\u0002lm\u0013aaT;uaV$\bbBA8\u0013\u0001\u0007\u0011\u0011O\u0001\u0002GB\u00191-a\u001d\n\u0007\u0005U\u0014NA\u0006D_6\u0004\u0018\u000e\\1uS>t\u0017a\u00044s_6\u001cu.\u001c9jY\u0006$\u0018n\u001c8\u0015\t\u0005m\u0014q\u0010\t\u00041\u0006u\u0014bAA;3\"9\u0011\u0011\u0011\u0006A\u0002\u0005E\u0014aC2p[BLG.\u0019;j_:\f\u0001C\u001a:p[\u000e{W\u000e]5mCRLwN\\:\u0015\t\u0005\u001d\u0015Q\u0012\t\u0004I\u0006%\u0015bAAF\u0011\na1i\\7qS2\fG/[8og\"9\u0011qR\u0006A\u0002\u0005E\u0015!D2p[BLG.\u0019;j_:\u001c\b\u0007E\u0002d\u0003'K1!a#j\u000311'o\\7Q_NLG/[8o)\u0011\tI*a(\u0011\t\u0005e\u00111T\u0005\u0004\u0003;k&\u0001\u0003)pg&$\u0018n\u001c8\t\u000f\u0005\u0005F\u00021\u0001\u0002$\u0006A\u0001o\\:ji&|g\u000eE\u0002d\u0003KK1!!(j\u000311'o\\7TKZ,'/\u001b;z)\u0019\tY+!-\u0002:B!\u0011\u0011DAW\u0013\r\ty+\u0018\u0002\t'\u00164XM]5us\"9\u00111W\u0007A\u0002\u0005U\u0016\u0001C:fm\u0016\u0014\u0018\u000e^=\u0011\u0007\r\f9,C\u0002\u00020&Dq!a/\u000e\u0001\u0004\ti,\u0001\u0002jIB\u0019\u0011+a0\n\u0007\u0005\u0005'KA\u0002J]R\f!B\u001a:p[N#(/\u001b8h)\u0011\t9-!4\u0011\tE\u000bIM`\u0005\u0004\u0003\u0017\u0014&AB(qi&|g\u000e\u0003\u0004\u0002P:\u0001\rA`\u0001\u0006m\u0006dW/Z\u0001\bMJ|W.\u00138u)\u0011\t).a9\u0011\u000bE\u000bI-a6\u0011\t\u0005e\u0017q\\\u0007\u0003\u00037T1!!8y\u0003\u0011a\u0017M\\4\n\t\u0005\u0005\u00181\u001c\u0002\b\u0013:$XmZ3s\u0011\u001d\tym\u0004a\u0001\u0003{\u000b!C\u001a:p[\u0012K\u0017m\u001a8pgRL7mQ8eKR!\u0011\u0011^Ax!\u0011\tI\"a;\n\u0007\u00055XL\u0001\bES\u0006<gn\\:uS\u000e\u001cu\u000eZ3\t\u000f\u0005E\b\u00031\u0001\u0002t\u0006qA-[1h]>\u001cH/[2D_\u0012,\u0007cA2\u0002v&\u0019\u0011Q^5\u0002A\u0019\u0014x.\u001c#jC\u001etwn\u001d;jGJ+G.\u0019;fI&sgm\u001c:nCRLwN\u001c\u000b\u0005\u0003w\u0014\t\u0001\u0005\u0003\u0002\u001a\u0005u\u0018bAA\u0000;\naB)[1h]>\u001cH/[2SK2\fG/\u001a3J]\u001a|'/\\1uS>t\u0007b\u0002B\u0002#\u0001\u0007!QA\u0001\u0005S:4w\u000eE\u0002d\u0005\u000fI1!a@j\u0003-1'o\\7Qe>\u0014G.Z7\u0015\t\t5!1\u0003\t\u0005\u00033\u0011y!C\u0002\u0003\u0012u\u0013q\u0001\u0015:pE2,W\u000eC\u0004\u0003\u0016I\u0001\rAa\u0006\u0002\u000fA\u0014xN\u00197f[B\u00191M!\u0007\n\u0007\tE\u0011.\u0001\bge>l7k\\;sG\u0016LeNZ8\u0015\t\t}!Q\u0005\t\u00041\n\u0005\u0012b\u0001B\u00123\nQ1k\\;sG\u0016LeNZ8\t\u000f\t\u001d2\u00031\u0001\u0003*\u0005Q1o\\;sG\u0016LeNZ8\u0011\u0007\r\u0014Y#C\u0002\u0003$%\fqB\u001a:p[N{WO]2f\u0013:4wn\u001d\u000b\u0005\u0005c\u00119\u0004E\u0002e\u0005gI1A!\u000eI\u0005-\u0019v.\u001e:dK&sgm\\:\t\u000f\teB\u00031\u0001\u0003<\u0005a1o\\;sG\u0016LeNZ8taA\u00191M!\u0010\n\u0007\tU\u0012.A\u000bge>l7\t\\1tgB\fG\u000f\u001b$jY\u0016D\u0015m\u001d5\u0015\t\t\r#\u0011\n\t\u0005\u0003+\u0012)%C\u0002\u0003Hm\u0013\u0001BR5mK\"\u000b7\u000f\u001b\u0005\b\u0005\u0017*\u0002\u0019\u0001B'\u0003!1\u0017\u000e\\3ICND\u0007cA2\u0003P%\u0019!qI5\u0002\u001f\u0019\u0014x.\\'j]&|\u0005\u000f^5p]N$BA!\u0016\u0003\\A!\u0011Q\u000bB,\u0013\r\u0011If\u0017\u0002\f\u001b&t\u0017n\u00149uS>t7\u000fC\u0004\u0003^Y\u0001\rAa\u0018\u0002\u00175Lg.[(qi&|gn\u001d\t\u0004G\n\u0005\u0014b\u0001B-S\u0006\u0001bM]8n\u0007>l\u0007/\u001b7f\u001fJ$WM\u001d\u000b\u0007\u0005O\u0012iG!\u001e\u0011\t\u0005U#\u0011N\u0005\u0004\u0005WZ&\u0001D\"p[BLG.Z(sI\u0016\u0014\bb\u0002B8/\u0001\u0007!\u0011O\u0001\rG>l\u0007/\u001b7f\u001fJ$WM\u001d\t\u0004G\nM\u0014b\u0001B6S\"9\u00111X\fA\u0002\u0005u\u0016a\u00044s_6\u001cFO]5oOR+\b\u000f\\3\u0015\t\tm$\u0011\u0011\t\u0007\u00033\u0011iH @\n\u0007\t}TL\u0001\u0002Ue!9!1\u0011\rA\u0002\t\u0015\u0015!\u0002;va2,\u0007cA2\u0003\b&\u0019!\u0011R5\u0003\u000bQ+\b\u000f\\3\u0002'\u0019\u0014x.\\'j]&\u001cV\r^;q\u001fV$\b/\u001e;\u0015\t\u0005\u001d$q\u0012\u0005\b\u0005#K\u0002\u0019\u0001BJ\u0003%i\u0017N\\5TKR,\b\u000fE\u0002d\u0005+K1Aa&j\u0005%i\u0015N\\5TKR,\b/A\u0007ge>lW*\u001b8j'\u0016$X\u000f\u001d\u000b\u0005\u0005;\u0013\t\u000b\u0005\u0003\u0002V\t}\u0015b\u0001BL7\"9!\u0011\u0013\u000eA\u0002\tM%!E#gM&\u001c\u0017.\u001a8u)J\fg/\u001a:tKV!!q\u0015B^'\tY\u0002+A\u0002tKF\u0004bA!,\u00034\n]VB\u0001BX\u0015\r\u0011\t\f_\u0001\u0005kRLG.\u0003\u0003\u00036\n=&\u0001\u0002'jgR\u0004BA!/\u0003<2\u0001Aa\u0002B_7\t\u0007!q\u0018\u0002\u0002)F!!\u0011\u0019Bd!\r\t&1Y\u0005\u0004\u0005\u000b\u0014&a\u0002(pi\"Lgn\u001a\t\u0004#\n%\u0017b\u0001Bf%\n\u0019\u0011I\\=\u0015\t\t='1\u001b\t\u0006\u0005#\\\"qW\u0007\u0002\u0001!9!\u0011V\u000fA\u0002\t-\u0016a\u0003;p5&t7-\u0011:sCf,BA!7\u0003fR!!1\u001cB~)\u0011\u0011iNa;\u0011\u000bE\u0013yNa9\n\u0007\t\u0005(KA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0003:\n\u0015Ha\u0002Bt=\t\u0007!\u0011\u001e\u0002\u0002%F\u0019!\u0011\u0019)\t\u0013\t5h$!AA\u0004\t=\u0018AC3wS\u0012,gnY3%cA1!\u0011\u001fB|\u0005Gl!Aa=\u000b\u0007\tU(+A\u0004sK\u001adWm\u0019;\n\t\te(1\u001f\u0002\t\u00072\f7o\u001d+bO\"9!Q \u0010A\u0002\t}\u0018!\u00014\u0011\u000fE\u001b\tAa.\u0003d&\u001911\u0001*\u0003\u0013\u0019+hn\u0019;j_:\f\u0014!E#gM&\u001c\u0017.\u001a8u)J\fg/\u001a:tKV!1\u0011BB\b)\u0011\u0019Ya!\u0005\u0011\u000b\tE7d!\u0004\u0011\t\te6q\u0002\u0003\b\u0005{{\"\u0019\u0001B`\u0011\u001d\u0011Ik\ba\u0001\u0007'\u0001bA!,\u00034\u000e5!\u0001D(qi&|gNU3bI\u0016\u0014X\u0003BB\r\u0007C\u0019\"\u0001\t)\u0002\r=\u0004H/[8o!\u0015\t\u0016\u0011ZB\u0010!\u0011\u0011Il!\t\u0005\u000f\tu\u0006E1\u0001\u0003@R!1QEB\u0014!\u0015\u0011\t\u000eIB\u0010\u0011\u001d\u0019YB\ta\u0001\u0007;\tAA]3bIV!1QFB\u0019)\u0019\u0019yca\r\u0004:A!!\u0011XB\u0019\t\u001d\u00119o\tb\u0001\u0005\u007fCqa!\u000e$\u0001\u0004\u00199$\u0001\u0003ge>l\u0007cB)\u0004\u0002\r}1q\u0006\u0005\t\u0007w\u0019C\u00111\u0001\u0004>\u0005aQM\u001d:pe6+7o]1hKB!\u0011ka\u0010\u007f\u0013\r\u0019\tE\u0015\u0002\ty\tLh.Y7f}\u0005aq\n\u001d;j_:\u0014V-\u00193feV!1qIB')\u0011\u0019Iea\u0014\u0011\u000b\tE\u0007ea\u0013\u0011\t\te6Q\n\u0003\b\u0005{##\u0019\u0001B`\u0011\u001d\u0019Y\u0002\na\u0001\u0007#\u0002R!UAe\u0007\u0017\n\u0001B\u001a:p[B\u000bG\u000f\u001b\u000b\u0005\u0007/\u001a\t\u0007\u0005\u0003\u0004Z\r}SBAB.\u0015\r\u0019i&X\u0001\u0004CBL\u0017bA>\u0004\\!1Q0\na\u0001\u0007G\u00022aYB3\u0013\tY\u0018.\u0001\bge>l\u0017I\u001c8pi\u0006$\u0018n\u001c8\u0015\t\r-4\u0011\u000f\t\u0005\u00073\u001ai'\u0003\u0003\u0004p\rm#AC!o]>$\u0018\r^5p]\"911\u000f\u0014A\u0002\rU\u0014AC1o]>$\u0018\r^5p]B\u00191ma\u001e\n\u0007\r=\u0014.A\u0007ge>l7\u000b\u001e:vGR,(/\u001a\u000b\u0005\u0007{\u001a\u0019\t\u0005\u0003\u0004Z\r}\u0014\u0002BBA\u00077\u0012\u0011b\u0015;sk\u000e$XO]3\t\u000f\r\u0015u\u00051\u0001\u0004\b\u0006\u0019A\u000f]3\u0011\t\r%5q\u0012\b\u0004G\u000e-\u0015bABGS\u0006!A+\u001f9f\u0013\u0011\u0019\ti!%\u000b\u0007\r5\u0015.\u0001\u0005ge>lG+\u001f9f)\u0011\u00199j!(\u0011\t\re3\u0011T\u0005\u0005\u00077\u001bYF\u0001\u0003UsB,\u0007bBBPQ\u0001\u00071\u0011U\u0001\u0005if\u0004X\rE\u0002d\u0007GK1aa'j\u000351'o\\7N_\u0012Lg-[3sgR!1\u0011VBX!\u0011\u0019Ifa+\n\t\r561\f\u0002\n\u001b>$\u0017NZ5feNDqa!-*\u0001\u0004\u0019\u0019,A\u0005n_\u0012Lg-[3sgB\u00191m!.\n\u0007\r5\u0016.\u0001\u0006ge>l\u0017iY2fgN$Baa/\u0004BB!1\u0011LB_\u0013\u0011\u0019yla\u0017\u0003\r\u0005\u001b7-Z:t\u0011\u001d\u0019\u0019M\u000ba\u0001\u0007\u000b\fa!Y2dKN\u001c\bcA2\u0004H&\u00191qX5\u0002%\u0019\u0014x.\u001c#fM&t\u0017\u000e^5p]RK\b/\u001a\u000b\u0005\u0007\u001b\u001c\u0019\u000e\u0005\u0003\u0004Z\r=\u0017\u0002BBi\u00077\u0012a\u0002R3gS:LG/[8o)f\u0004X\rC\u0004\u0004V.\u0002\raa6\u0002\u001d\u0011,g-\u001b8ji&|g\u000eV=qKB\u00191m!7\n\u0007\rE\u0017.A\nge>l7\t\\1tg\u0012+g-\u001b8ji&|g\u000e\u0006\u0003\u0004`\u000e\u0015\b\u0003BB-\u0007CLAaa9\u0004\\\ty1\t\\1tg\u0012+g-\u001b8ji&|g\u000eC\u0004\u0004h2\u0002\ra!;\u0002\u001f\rd\u0017m]:EK\u001aLg.\u001b;j_:\u00042aYBv\u0013\r\u0019\u0019/[\u0001\u0012MJ|W\u000eV=qKB\u000b'/Y7fi\u0016\u0014H\u0003BBy\u0007o\u0004Ba!\u0017\u0004t&!1Q_B.\u00055!\u0016\u0010]3QCJ\fW.\u001a;fe\"91\u0011`\u0017A\u0002\rm\u0018!\u0004;za\u0016\u0004\u0016M]1nKR,'\u000fE\u0002d\u0007{L1a!>j\u000351'o\\7DY\u0006\u001c8\u000fT5lKR!A1\u0001C\u0005!\u0011\u0019I\u0006\"\u0002\n\t\u0011\u001d11\f\u0002\n\u00072\f7o\u001d'jW\u0016Dq\u0001b\u0003/\u0001\u0004!i!A\u0005dY\u0006\u001c8\u000fT5lKB\u00191\rb\u0004\n\u0007\u0011\u001d\u0011.\u0001\u0007ge>lWk]3TG>\u0004X\r\u0006\u0004\u0005\u0016\u0011mA1\u0005\t\u0005\u00033!9\"C\u0002\u0005\u001au\u0013\u0001\"V:f'\u000e|\u0007/\u001a\u0005\b\t;y\u0003\u0019\u0001C\u0010\u0003!)8/Z*d_B,\u0007cA2\u0005\"%\u0019A\u0011D5\t\u000f\u0005mv\u00061\u0001\u0002>\u0006\tbM]8n\u0003:\fG.\u001f>fI\u000ec\u0017m]:\u0015\r\u0011%B\u0011\bC\")\u0011!Y\u0003\"\r\u0011\t\reCQF\u0005\u0005\t_\u0019YFA\u0007B]\u0006d\u0017P_3e\u00072\f7o\u001d\u0005\b\tg\u0001\u0004\u0019\u0001C\u001b\u00035\tg.\u00197zu\u0016$7\t\\1tgB\u00191\rb\u000e\n\u0007\u0011=\u0012\u000eC\u0004\u0005<A\u0002\r\u0001\"\u0010\u0002\u001fMDw.\u001e7e'R|'/Z!qSN\u00042!\u0015C \u0013\r!\tE\u0015\u0002\b\u0005>|G.Z1o\u0011\u001d!)\u0005\ra\u0001\t\u000f\n1b\u001d;sS:<G+\u00192mKB\u0019!\u0011\u001b \u0003\u0017M#(/\u001b8h)\u0006\u0014G.Z\n\u0003}A#\"\u0001b\u0012\u0002\u000fM$(/\u001b8hgV\u0011A1\u000b\t\u0007\u0005[#)F @\n\t\u0011]#q\u0016\u0002\b\u0011\u0006\u001c\b.T1q\u0003!\u0019HO]5oON\u0004\u0013!\u00047p_.,\bo\u0014:F]R,'\u000fF\u0002\u007f\t?Ba\u0001\"\u0019C\u0001\u0004q\u0018AB:ue&tw-\u0001\u0005tiJLgnZ%e+\t!9\u0007E\u0003R\u0007\u0003qh0A\u0005tiJLgnZ%eA\u0005q1\u000f\u001e:j]\u001e$vnU8ve\u000e,WC\u0001C8!\u0019\t6\u0011\u0001@\u0002\u0018\u0005y1\u000f\u001e:j]\u001e$vnU8ve\u000e,\u0007%A\btiJLgn\u001a+p\u0019&\u0014'/\u0019:z\u0003A\u0019HO]5oOR{G*\u001b2sCJL\b%\u0001\u0007tiJLgn\u001a+p!J|G-A\u0007tiJLgn\u001a+p!J|G\rI\u0001\u000eMJ|WNU3mCRLwN\\:\u0015\t\u0011}DQ\u0011\t\u0004I\u0012\u0005\u0015b\u0001CB\u0011\nI!+\u001a7bi&|gn\u001d\u0005\b\t\u000fK\u0004\u0019\u0001CE\u0003%\u0011X\r\\1uS>t7\u000fE\u0002d\t\u0017K1\u0001b!j\u0003!1'o\\7Ba&\u001cH\u0003\u0002CI\tC#B\u0001b%\u0005\u001aB\u0019A\r\"&\n\u0007\u0011]\u0005J\u0001\u0003B!&\u001b\bb\u0002CNu\u0001\u0007AQT\u0001\u0005CBL7\u000fE\u0002d\t?K1\u0001b&j\u0011\u001d!YD\u000fa\u0001\t{\tAB\u001a:p[\u0006\u0003\u0018n\u001d$jY\u0016$b\u0001b*\u0005.\u0012]\u0006CB)\u0005*\u0012M%-C\u0002\u0005,J\u0013a\u0001V;qY\u0016\u0014\u0004b\u0002CXw\u0001\u0007A\u0011W\u0001\tCBL7OR5mKB\u00191\rb-\n\u0007\u0011U\u0016N\u0001\u0005B!&\u001bh)\u001b7f\u0011\u001d!Yd\u000fa\u0001\t{\tAB\u001a:p[\u0006s\u0017\r\\=tSN$B\u0001\"0\u0005DB\u0019A\rb0\n\u0007\u0011\u0005\u0007J\u0001\u0005B]\u0006d\u0017p]5t\u0011\u0019QF\b1\u0001\u0005FB\u00191\rb2\n\u0007\u0011\u0005\u0017.\u0001\tge>l\u0017I\\1msNL7OR5mKR!AQ\u001aCj!!\tFq\u001aC_\u0005;\u0013\u0017b\u0001Ci%\n1A+\u001e9mKNBq\u0001\"6>\u0001\u0004!9.\u0001\u0007b]\u0006d\u0017p]5t\r&dW\rE\u0002d\t3L1\u0001b7j\u00051\te.\u00197zg&\u001ch)\u001b7f\u0001")
public final class ProtobufReaders {
    private final ReadMapper mapper;
    private final Schema.Version currentVersion;
    private final Function1<String, String> stringId;
    private final Function1<String, VirtualFileRef> stringToSource;
    private final Function1<String, VirtualFileRef> stringToLibrary;
    private final Function1<String, VirtualFileRef> stringToProd;

    public java.nio.file.Path fromPathString(String path) {
        return Paths.get(path, new String[0]);
    }

    public VirtualFileRef fromPathStringV(String path) {
        return VirtualFileRef.of((String)path);
    }

    public Stamp fromStampType(Schema.Stamps.StampType stampType) {
        EmptyStamp$ emptyStamp$;
        Schema.Stamps.StampType.TypeCase typeCase = stampType.getTypeCase();
        if (Schema.Stamps.StampType.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
            emptyStamp$ = EmptyStamp$.MODULE$;
        } else if (Schema.Stamps.StampType.TypeCase.FARMHASH.equals(typeCase)) {
            emptyStamp$ = FarmHash$.MODULE$.fromLong(stampType.getFarmHash().getHash());
        } else if (Schema.Stamps.StampType.TypeCase.HASH.equals(typeCase)) {
            emptyStamp$ = Hash$.MODULE$.unsafeFromString(stampType.getHash().getHash());
        } else if (Schema.Stamps.StampType.TypeCase.LASTMODIFIED.equals(typeCase)) {
            emptyStamp$ = new LastModified(stampType.getLastModified().getMillis());
        } else {
            throw new MatchError((Object)typeCase);
        }
        return emptyStamp$;
    }

    public Stamps fromStamps(Schema.Stamps stamps) {
        scala.collection.immutable.Map libraries = this.fromBinarySchemaMap$1(stamps.getBinaryStampsMap());
        scala.collection.immutable.Map sources = this.fromSourceSchemaMap$1(stamps.getSourceStampsMap());
        scala.collection.immutable.Map products = this.fromProductSchemaMap$1(stamps.getProductStampsMap());
        return Stamps$.MODULE$.apply(products, sources, libraries);
    }

    public OutputGroup fromOutputGroup(Schema.OutputGroup outputGroup) {
        java.nio.file.Path sourcePath = this.fromPathString(outputGroup.getSourcePath());
        java.nio.file.Path sourceDir = this.mapper.mapSourceDir(sourcePath);
        java.nio.file.Path targetPath = this.fromPathString(outputGroup.getTargetPath());
        java.nio.file.Path targetDir = this.mapper.mapOutputDir(targetPath);
        return CompileOutput$.MODULE$.outputGroup(sourceDir, targetDir);
    }

    public Output fromCompilationOutput(Schema.Compilation c) {
        Output output;
        Schema.Compilation.OutputCase outputCase = c.getOutputCase();
        if (Schema.Compilation.OutputCase.SINGLEOUTPUT.equals(outputCase)) {
            Output output2;
            java.nio.file.Path target;
            Schema.SingleOutput single = c.getSingleOutput();
            java.nio.file.Path path = target = this.fromPathString(single.getTarget());
            java.nio.file.Path path2 = Analysis$.MODULE$.dummyOutputPath();
            if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                output2 = CompileOutput$.MODULE$.empty();
            } else {
                java.nio.file.Path outputDir = this.mapper.mapOutputDir(target);
                output2 = CompileOutput$.MODULE$.apply(outputDir);
            }
            output = output2;
        } else if (Schema.Compilation.OutputCase.MULTIPLEOUTPUT.equals(outputCase)) {
            Schema.MultipleOutput multiple = c.getMultipleOutput();
            OutputGroup[] groups = (OutputGroup[])((IterableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(multiple.getOutputGroupsList()).asScala()).iterator().map((Function1 & Serializable)outputGroup -> this.fromOutputGroup((Schema.OutputGroup)outputGroup)).toArray(ClassTag$.MODULE$.apply(OutputGroup.class));
            output = CompileOutput$.MODULE$.apply(groups);
        } else {
            if (Schema.Compilation.OutputCase.OUTPUT_NOT_SET.equals(outputCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedOutputInCompilationOutput()).$bang$bang();
            }
            throw new MatchError((Object)outputCase);
        }
        return output;
    }

    public xsbti.compile.analysis.Compilation fromCompilation(Schema.Compilation compilation) {
        Output output = this.fromCompilationOutput(compilation);
        return new Compilation(compilation.getStartTimeMillis(), output);
    }

    public Compilations fromCompilations(Schema.Compilations compilations0) {
        Iterator compilations = ((IterableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(compilations0.getCompilationsList()).asScala()).iterator().map((Function1 & Serializable)compilation -> this.fromCompilation((Schema.Compilation)compilation));
        Seq castedCompilations = compilations.map((Function1 & Serializable)x0$1 -> {
            Compilation compilation;
            xsbti.compile.analysis.Compilation compilation2 = x0$1;
            if (!(compilation2 instanceof Compilation)) {
                throw new MatchError((Object)compilation2);
            }
            Compilation compilation3 = compilation = (Compilation)compilation2;
            return compilation3;
        }).toSeq();
        return Compilations$.MODULE$.of(castedCompilations);
    }

    public Position fromPosition(Schema.Position position) {
        return InterfaceUtil$.MODULE$.position(this.fromInt(position.getLine()), position.getLineContent(), this.fromInt(position.getOffset()), this.fromInt(position.getPointer()), this.sbt$internal$inc$binary$converters$ProtobufReaders$$fromString(position.getPointerSpace()), this.sbt$internal$inc$binary$converters$ProtobufReaders$$fromString(position.getSourcePath()), this.sbt$internal$inc$binary$converters$ProtobufReaders$$fromString(position.getSourceFilepath()).map((Function1 & Serializable)path -> this.fromPathString((String)path)).map((Function1 & Serializable)x$1 -> x$1.toFile()), this.fromInt(position.getStartOffset()), this.fromInt(position.getEndOffset()), this.fromInt(position.getStartLine()), this.fromInt(position.getStartColumn()), this.fromInt(position.getEndLine()), this.fromInt(position.getEndColumn()));
    }

    public Severity fromSeverity(Schema.Severity severity, int id) {
        Severity severity2;
        Schema.Severity severity3 = severity;
        if (Schema.Severity.INFO.equals(severity3)) {
            severity2 = Severity.Info;
        } else if (Schema.Severity.WARN.equals(severity3)) {
            severity2 = Severity.Warn;
        } else if (Schema.Severity.ERROR.equals(severity3)) {
            severity2 = Severity.Error;
        } else {
            if (Schema.Severity.UNRECOGNIZED.equals(severity3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedSeverity(id)).$bang$bang();
            }
            throw new MatchError((Object)severity3);
        }
        return severity2;
    }

    public Option<String> sbt$internal$inc$binary$converters$ProtobufReaders$$fromString(String value) {
        String string = value;
        String string2 = ProtobufDefaults$.MODULE$.MissingString();
        return !(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : new Some((Object)value);
    }

    private Option<Integer> fromInt(int value) {
        return value == ProtobufDefaults$.MODULE$.MissingInt() ? None$.MODULE$ : new Some((Object)Predef$.MODULE$.int2Integer(value));
    }

    private DiagnosticCode fromDiagnosticCode(Schema.DiagnosticCode diagnosticCode) {
        return new DiagnosticCode(this, diagnosticCode){
            private final String code;
            private final Optional<String> explanation;

            public String code() {
                return this.code;
            }

            public Optional<String> explanation() {
                return this.explanation;
            }
            {
                this.code = diagnosticCode$1.getCode();
                this.explanation = InterfaceUtil$.MODULE$.o2jo($outer.sbt$internal$inc$binary$converters$ProtobufReaders$$fromString(diagnosticCode$1.getExplanation()));
            }
        };
    }

    private DiagnosticRelatedInformation fromDiagnosticRelatedInformation(Schema.DiagnosticRelatedInformation info) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Problem fromProblem(Schema.Problem problem) {
        String category = problem.getCategory();
        String message = problem.getMessage();
        Severity severity = this.fromSeverity(problem.getSeverity(), problem.getSeverityValue());
        if (!problem.hasPosition()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPositionInProblem()).$bang$bang();
        }
        Position position = this.fromPosition(problem.getPosition());
        Option<String> rendered = this.sbt$internal$inc$binary$converters$ProtobufReaders$$fromString(problem.getRendered());
        None$ diagnosticCode = problem.hasDiagnosticCode() ? new Some((Object)this.fromDiagnosticCode(problem.getDiagnosticCode())) : None$.MODULE$;
        List infos = ((IterableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(problem.getDiagnosticRelatedInforamationList()).asScala()).iterator().map((Function1 & Serializable)info -> this.fromDiagnosticRelatedInformation((Schema.DiagnosticRelatedInformation)info)).toList();
        return InterfaceUtil$.MODULE$.problem(category, position, message, severity, rendered, (Option)diagnosticCode, infos);
    }

    public SourceInfo fromSourceInfo(Schema.SourceInfo sourceInfo) {
        Seq mainClasses = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)sourceInfo.getMainClassesList()).asScala()).toSeq();
        Seq reportedProblems = ((IterableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(sourceInfo.getReportedProblemsList()).asScala()).iterator().map((Function1 & Serializable)problem -> this.fromProblem((Schema.Problem)problem)).toSeq();
        Seq unreportedProblems = ((IterableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(sourceInfo.getUnreportedProblemsList()).asScala()).iterator().map((Function1 & Serializable)problem -> this.fromProblem((Schema.Problem)problem)).toSeq();
        return SourceInfos$.MODULE$.makeInfo(reportedProblems, unreportedProblems, mainClasses);
    }

    public SourceInfos fromSourceInfos(Schema.SourceInfos sourceInfos0) {
        Iterator sourceInfos = ((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(sourceInfos0.getSourceInfosMap()).asScala()).iterator().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Schema.SourceInfo value = (Schema.SourceInfo)tuple2._2();
            VirtualFileRef file = $this.mapper.mapSourceFile(this.fromPathStringV(path));
            SourceInfo sourceInfo = this.fromSourceInfo(value);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file), (Object)sourceInfo);
            return tuple22;
        });
        return SourceInfos$.MODULE$.of(sourceInfos.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public FileHash fromClasspathFileHash(Schema.FileHash fileHash) {
        int hash = fileHash.getHash();
        java.nio.file.Path classpathEntry = this.fromPathString(fileHash.getPath());
        java.nio.file.Path newClasspathEntry = this.mapper.mapClasspathEntry(classpathEntry);
        return FileHash.of((java.nio.file.Path)newClasspathEntry, (int)hash);
    }

    public MiniOptions fromMiniOptions(Schema.MiniOptions miniOptions) {
        FileHash[] classpathHash = (FileHash[])((IterableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(miniOptions.getClasspathHashList()).asScala()).iterator().map((Function1 & Serializable)fileHash -> this.fromClasspathFileHash((Schema.FileHash)fileHash)).toArray(ClassTag$.MODULE$.apply(FileHash.class));
        String[] javacOptions = (String[])((IterableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)miniOptions.getJavacOptionsList()).asScala()).iterator().map((Function1 & Serializable)javacOption -> $this.mapper.mapJavacOption((String)javacOption)).toArray(ClassTag$.MODULE$.apply(String.class));
        String[] scalacOptions = (String[])((IterableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)miniOptions.getScalacOptionsList()).asScala()).iterator().map((Function1 & Serializable)scalacOption -> $this.mapper.mapScalacOption((String)scalacOption)).toArray(ClassTag$.MODULE$.apply(String.class));
        return MiniOptions.of((FileHash[])classpathHash, (String[])scalacOptions, (String[])javacOptions);
    }

    public CompileOrder fromCompileOrder(Schema.CompileOrder compileOrder, int id) {
        CompileOrder compileOrder2;
        Schema.CompileOrder compileOrder3 = compileOrder;
        if (Schema.CompileOrder.MIXED.equals(compileOrder3)) {
            compileOrder2 = CompileOrder.Mixed;
        } else if (Schema.CompileOrder.JAVATHENSCALA.equals(compileOrder3)) {
            compileOrder2 = CompileOrder.JavaThenScala;
        } else if (Schema.CompileOrder.SCALATHENJAVA.equals(compileOrder3)) {
            compileOrder2 = CompileOrder.ScalaThenJava;
        } else {
            if (Schema.CompileOrder.UNRECOGNIZED.equals(compileOrder3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedOrder(id)).$bang$bang();
            }
            throw new MatchError((Object)compileOrder3);
        }
        return compileOrder2;
    }

    public T2<String, String> fromStringTuple(Schema.Tuple tuple) {
        return InterfaceUtil$.MODULE$.t2(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tuple.getFirst()), (Object)tuple.getSecond()));
    }

    public Output fromMiniSetupOutput(Schema.MiniSetup miniSetup) {
        Output output;
        Schema.MiniSetup.OutputCase outputCase = miniSetup.getOutputCase();
        if (Schema.MiniSetup.OutputCase.SINGLEOUTPUT.equals(outputCase)) {
            Output output2;
            java.nio.file.Path target;
            Schema.SingleOutput single = miniSetup.getSingleOutput();
            java.nio.file.Path path = target = this.fromPathString(single.getTarget());
            java.nio.file.Path path2 = Analysis$.MODULE$.dummyOutputPath();
            if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                output2 = CompileOutput$.MODULE$.empty();
            } else {
                java.nio.file.Path outputDir = this.mapper.mapOutputDir(target);
                output2 = CompileOutput$.MODULE$.apply(outputDir);
            }
            output = output2;
        } else if (Schema.MiniSetup.OutputCase.MULTIPLEOUTPUT.equals(outputCase)) {
            Schema.MultipleOutput multiple = miniSetup.getMultipleOutput();
            OutputGroup[] groups = (OutputGroup[])((IterableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(multiple.getOutputGroupsList()).asScala()).iterator().map((Function1 & Serializable)outputGroup -> this.fromOutputGroup((Schema.OutputGroup)outputGroup)).toArray(ClassTag$.MODULE$.apply(OutputGroup.class));
            output = CompileOutput$.MODULE$.apply(groups);
        } else {
            if (Schema.MiniSetup.OutputCase.OUTPUT_NOT_SET.equals(outputCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedOutputInCompilationOutput()).$bang$bang();
            }
            throw new MatchError((Object)outputCase);
        }
        return output;
    }

    public MiniSetup fromMiniSetup(Schema.MiniSetup miniSetup) {
        Output output = this.fromMiniSetupOutput(miniSetup);
        if (!miniSetup.hasMiniOptions()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedMiniOptionsInSetup()).$bang$bang();
        }
        MiniOptions miniOptions = this.fromMiniOptions(miniSetup.getMiniOptions());
        String compilerVersion = miniSetup.getCompilerVersion();
        CompileOrder compileOrder = this.fromCompileOrder(miniSetup.getCompileOrder(), miniSetup.getCompileOrderValue());
        boolean storeApis = miniSetup.getStoreApis();
        T2[] extra = (T2[])((IterableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(miniSetup.getExtraList()).asScala()).iterator().map((Function1 & Serializable)tuple -> this.fromStringTuple((Schema.Tuple)tuple)).toArray(ClassTag$.MODULE$.apply(T2.class));
        MiniSetup original = MiniSetup.of((Output)output, (MiniOptions)miniOptions, (String)compilerVersion, (CompileOrder)compileOrder, (boolean)storeApis, (T2[])extra);
        return this.mapper.mapMiniSetup(original);
    }

    public <T> EfficientTraverse<T> EfficientTraverse(java.util.List<T> seq) {
        return new EfficientTraverse<T>(this, seq);
    }

    public <T> OptionReader<T> OptionReader(Option<T> option) {
        return new OptionReader<T>(this, option);
    }

    public Path fromPath(Schema.Path path) {
        PathComponent[] components = (PathComponent[])this.EfficientTraverse(path.getComponentsList()).toZincArray((Function1 & Serializable)pathComponent -> this.fromPathComponent$1((Schema.Path.PathComponent)pathComponent), ClassTag$.MODULE$.apply(PathComponent.class));
        return Path.of((PathComponent[])components);
    }

    public Annotation fromAnnotation(Schema.Annotation annotation) {
        AnnotationArgument[] arguments = (AnnotationArgument[])this.EfficientTraverse(annotation.getArgumentsList()).toZincArray((Function1 & Serializable)argument -> ProtobufReaders.fromAnnotationArgument$1(argument), ClassTag$.MODULE$.apply(AnnotationArgument.class));
        None$ b = annotation.hasBase() ? new Some((Object)annotation.getBase()) : None$.MODULE$;
        Type base = (Type)this.OptionReader((Option)b).read((Function1 & Serializable)type -> this.fromType((Schema.Type)type), (Function0<String>)(Function0 & Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Annotation.class));
        return Annotation.of((Type)base, (AnnotationArgument[])arguments);
    }

    public Structure fromStructure(Schema.Type.Structure tpe) {
        Lazy parents = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getParentsList()).toZincArray((Function1 & Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class)));
        Lazy declared = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getDeclaredList()).toZincArray((Function1 & Serializable)classDefinition -> this.fromClassDefinition((Schema.ClassDefinition)classDefinition), ClassTag$.MODULE$.apply(ClassDefinition.class)));
        Lazy inherited = ProtobufReaders.lazy$1(this.EfficientTraverse(tpe.getInheritedList()).toZincArray((Function1 & Serializable)classDefinition -> this.fromClassDefinition((Schema.ClassDefinition)classDefinition), ClassTag$.MODULE$.apply(ClassDefinition.class)));
        return Structure.of((Lazy)parents, (Lazy)declared, (Lazy)inherited);
    }

    public Type fromType(Schema.Type type) {
        ParameterRef parameterRef;
        Schema.Type.ValueCase valueCase = type.getValueCase();
        if (Schema.Type.ValueCase.PARAMETERREF.equals(valueCase)) {
            parameterRef = ProtobufReaders.fromParameterRef$1(type.getParameterRef());
        } else if (Schema.Type.ValueCase.PARAMETERIZED.equals(valueCase)) {
            parameterRef = this.fromParameterized$1(type.getParameterized());
        } else if (Schema.Type.ValueCase.STRUCTURE.equals(valueCase)) {
            parameterRef = this.fromStructure(type.getStructure());
        } else if (Schema.Type.ValueCase.POLYMORPHIC.equals(valueCase)) {
            parameterRef = this.fromPolymorphic$1(type.getPolymorphic());
        } else if (Schema.Type.ValueCase.CONSTANT.equals(valueCase)) {
            parameterRef = this.fromConstant$1(type.getConstant());
        } else if (Schema.Type.ValueCase.EXISTENTIAL.equals(valueCase)) {
            parameterRef = this.fromExistential$1(type.getExistential());
        } else if (Schema.Type.ValueCase.SINGLETON.equals(valueCase)) {
            parameterRef = this.fromSingleton$1(type.getSingleton());
        } else if (Schema.Type.ValueCase.PROJECTION.equals(valueCase)) {
            parameterRef = this.fromProjection$1(type.getProjection());
        } else if (Schema.Type.ValueCase.ANNOTATED.equals(valueCase)) {
            parameterRef = this.fromAnnotated$1(type.getAnnotated());
        } else if (Schema.Type.ValueCase.EMPTYTYPE.equals(valueCase)) {
            parameterRef = ProtobufDefaults$ReadersConstants$.MODULE$.EmptyType();
        } else {
            if (Schema.Type.ValueCase.VALUE_NOT_SET.equals(valueCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyType()).$bang$bang();
            }
            throw new MatchError((Object)valueCase);
        }
        return parameterRef;
    }

    public Modifiers fromModifiers(Schema.Modifiers modifiers) {
        return InternalApiProxy$Modifiers$.MODULE$.apply(modifiers.getFlags());
    }

    public Access fromAccess(Schema.Access access) {
        Public public_;
        Schema.Access.TypeCase typeCase = access.getTypeCase();
        if (Schema.Access.TypeCase.PUBLIC.equals(typeCase)) {
            public_ = ProtobufDefaults$ReadersConstants$.MODULE$.Public();
        } else if (Schema.Access.TypeCase.PROTECTED.equals(typeCase)) {
            Schema.Protected a = access.getProtected();
            public_ = Protected.of((Qualifier)this.readQualifier$1((Option)(a.hasQualifier() ? new Some((Object)a.getQualifier()) : None$.MODULE$)));
        } else if (Schema.Access.TypeCase.PRIVATE.equals(typeCase)) {
            Schema.Private a = access.getPrivate();
            public_ = Private.of((Qualifier)this.readQualifier$1((Option)(a.hasQualifier() ? new Some((Object)a.getQualifier()) : None$.MODULE$)));
        } else {
            if (Schema.Access.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedValidAccessType()).$bang$bang();
            }
            throw new MatchError((Object)typeCase);
        }
        return public_;
    }

    public DefinitionType fromDefinitionType(Schema.DefinitionType definitionType) {
        DefinitionType definitionType2;
        Schema.DefinitionType definitionType3 = definitionType;
        if (Schema.DefinitionType.CLASSDEF.equals(definitionType3)) {
            definitionType2 = DefinitionType.ClassDef;
        } else if (Schema.DefinitionType.MODULE.equals(definitionType3)) {
            definitionType2 = DefinitionType.Module;
        } else if (Schema.DefinitionType.TRAIT.equals(definitionType3)) {
            definitionType2 = DefinitionType.Trait;
        } else if (Schema.DefinitionType.PACKAGEMODULE.equals(definitionType3)) {
            definitionType2 = DefinitionType.PackageModule;
        } else {
            if (Schema.DefinitionType.UNRECOGNIZED.equals(definitionType3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedDefinitionType()).$bang$bang();
            }
            throw new MatchError((Object)definitionType3);
        }
        return definitionType2;
    }

    public ClassDefinition fromClassDefinition(Schema.ClassDefinition classDefinition) {
        ClassLikeDef classLikeDef;
        String name = classDefinition.getName().intern();
        if (!classDefinition.hasAccess()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.MissingAccessInDef()).$bang$bang();
        }
        Access access = this.fromAccess(classDefinition.getAccess());
        if (!classDefinition.hasModifiers()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.MissingModifiersInDef()).$bang$bang();
        }
        Modifiers modifiers = this.fromModifiers(classDefinition.getModifiers());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(classDefinition.getAnnotationsList()).toZincArray((Function1 & Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        Schema.ClassDefinition.ExtraCase extraCase = classDefinition.getExtraCase();
        if (Schema.ClassDefinition.ExtraCase.CLASSLIKEDEF.equals(extraCase)) {
            classLikeDef = this.fromClassLikeDef$1(classDefinition.getClassLikeDef(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.DEFDEF.equals(extraCase)) {
            classLikeDef = this.fromDefDef$1(classDefinition.getDefDef(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.VALDEF.equals(extraCase)) {
            classLikeDef = this.fromValDef$1(classDefinition.getValDef(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.VARDEF.equals(extraCase)) {
            classLikeDef = this.fromVarDef$1(classDefinition.getVarDef(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.TYPEALIAS.equals(extraCase)) {
            classLikeDef = this.fromTypeAlias$1(classDefinition.getTypeAlias(), name, access, modifiers, annotations);
        } else if (Schema.ClassDefinition.ExtraCase.TYPEDECLARATION.equals(extraCase)) {
            classLikeDef = this.fromTypeDeclaration$1(classDefinition.getTypeDeclaration(), name, access, modifiers, annotations);
        } else {
            if (Schema.ClassDefinition.ExtraCase.EXTRA_NOT_SET.equals(extraCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyDefType()).$bang$bang();
            }
            throw new MatchError((Object)extraCase);
        }
        return classLikeDef;
    }

    public TypeParameter fromTypeParameter(Schema.TypeParameter typeParameter2) {
        String id = typeParameter2.getId();
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(typeParameter2.getAnnotationsList()).toZincArray((Function1 & Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(typeParameter2.getTypeParametersList()).toZincArray((Function1 & Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        Variance variance = ProtobufReaders.fromVariance$1(typeParameter2.getVariance());
        if (!typeParameter2.hasLowerBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedLowerBoundInTypeParameter()).$bang$bang();
        }
        Type lowerBound = this.fromType(typeParameter2.getLowerBound());
        if (!typeParameter2.hasUpperBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedUpperBoundInTypeParameter()).$bang$bang();
        }
        Type upperBound = this.fromType(typeParameter2.getUpperBound());
        return TypeParameter.of((String)id, (Annotation[])annotations, (TypeParameter[])typeParameters, (Variance)variance, (Type)lowerBound, (Type)upperBound);
    }

    public ClassLike fromClassLike(Schema.ClassLike classLike) {
        String name = classLike.getName().intern();
        if (!classLike.hasAccess()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Access.class)).$bang$bang();
        }
        Access access = this.fromAccess(classLike.getAccess());
        if (!classLike.hasModifiers()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Modifiers.class)).$bang$bang();
        }
        Modifiers modifiers = this.fromModifiers(classLike.getModifiers());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(classLike.getAnnotationsList()).toZincArray((Function1 & Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        DefinitionType definitionType = this.fromDefinitionType(classLike.getDefinitionType());
        if (!classLike.hasSelfType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expectedMsg$1("self type")).$bang$bang();
        }
        Lazy selfType = SafeLazyProxy$.MODULE$.strict((Object)this.fromType(classLike.getSelfType()));
        if (!classLike.hasStructure()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$1(Schema.Type.Structure.class)).$bang$bang();
        }
        Lazy structure = SafeLazyProxy$.MODULE$.strict((Object)this.fromStructure(classLike.getStructure()));
        String[] savedAnnotations = (String[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)classLike.getSavedAnnotationsList()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        Type[] childrenOfSealedClass = (Type[])this.EfficientTraverse(classLike.getChildrenOfSealedClassList()).toZincArray((Function1 & Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class));
        boolean topLevel = classLike.getTopLevel();
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(classLike.getTypeParametersList()).toZincArray((Function1 & Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return ClassLike.of((String)name, (Access)access, (Modifiers)modifiers, (Annotation[])annotations, (DefinitionType)definitionType, (Lazy)selfType, (Lazy)structure, (String[])savedAnnotations, (Type[])childrenOfSealedClass, (boolean)topLevel, (TypeParameter[])typeParameters);
    }

    public UseScope fromUseScope(Schema.UseScope useScope, int id) {
        UseScope useScope2;
        Schema.UseScope useScope3 = useScope;
        if (Schema.UseScope.DEFAULT.equals(useScope3)) {
            useScope2 = UseScope.Default;
        } else if (Schema.UseScope.IMPLICIT.equals(useScope3)) {
            useScope2 = UseScope.Implicit;
        } else if (Schema.UseScope.PATMAT.equals(useScope3)) {
            useScope2 = UseScope.PatMatTarget;
        } else {
            if (Schema.UseScope.UNRECOGNIZED.equals(useScope3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.unrecognizedUseScope(id)).$bang$bang();
            }
            throw new MatchError((Object)useScope3);
        }
        return useScope2;
    }

    public AnalyzedClass fromAnalyzedClass(boolean shouldStoreApis, StringTable stringTable, Schema.AnalyzedClass analyzedClass) {
        ProtobufDefaults$EmptyLazyCompanions$ protobufDefaults$EmptyLazyCompanions$;
        long compilationTs = analyzedClass.getCompilationTimestamp();
        String name = analyzedClass.getName().intern();
        if (!shouldStoreApis) {
            protobufDefaults$EmptyLazyCompanions$ = ProtobufDefaults$EmptyLazyCompanions$.MODULE$;
        } else {
            if (!analyzedClass.hasApi()) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedCompanionsInAnalyzedClass()).$bang$bang();
            }
            protobufDefaults$EmptyLazyCompanions$ = SafeLazyProxy$.MODULE$.strict((Object)this.fromCompanions$1(analyzedClass.getApi()));
        }
        ProtobufDefaults$EmptyLazyCompanions$ api = protobufDefaults$EmptyLazyCompanions$;
        int apiHash = analyzedClass.getApiHash();
        Schema.Version version = this.currentVersion;
        Schema.Version version2 = Schema.Version.V1;
        int extraHash = !(version != null ? !version.equals(version2) : version2 != null) ? 0 : analyzedClass.getExtraHash();
        NameHash[] nameHashes = (NameHash[])this.EfficientTraverse(analyzedClass.getNameHashesList()).toZincArray((Function1 & Serializable)nameHash -> this.fromNameHash$1((Schema.NameHash)nameHash, stringTable), ClassTag$.MODULE$.apply(NameHash.class));
        boolean hasMacro = analyzedClass.getHasMacro();
        String provenance = analyzedClass.getProvenance().intern();
        return AnalyzedClass.of((long)compilationTs, (String)name, (Lazy)api, (int)apiHash, (NameHash[])nameHashes, (boolean)hasMacro, (int)extraHash, (String)provenance);
    }

    private final Function1<String, String> stringId() {
        return this.stringId;
    }

    private final Function1<String, VirtualFileRef> stringToSource() {
        return this.stringToSource;
    }

    private final Function1<String, VirtualFileRef> stringToLibrary() {
        return this.stringToLibrary;
    }

    private final Function1<String, VirtualFileRef> stringToProd() {
        return this.stringToProd;
    }

    public Relations fromRelations(Schema.Relations relations) {
        Relation srcProd = ProtobufReaders.fromMap$1(relations.getSrcProdMap(), this.stringToSource(), this.stringToProd());
        Relation libraryDep = ProtobufReaders.fromMap$1(relations.getLibraryDepMap(), this.stringToSource(), this.stringToLibrary());
        Relation libraryClassName = ProtobufReaders.fromMap$1(relations.getLibraryClassNameMap(), this.stringToLibrary(), this.stringId());
        if (!relations.hasMemberRef()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("member refs")).$bang$bang();
        }
        Relations.ClassDependencies memberRef = this.fromClassDependencies$1(relations.getMemberRef());
        if (!relations.hasInheritance()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("inheritance")).$bang$bang();
        }
        Relations.ClassDependencies inheritance = this.fromClassDependencies$1(relations.getInheritance());
        if (!relations.hasLocalInheritance()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$3("local inheritance")).$bang$bang();
        }
        Relations.ClassDependencies localInheritance = this.fromClassDependencies$1(relations.getLocalInheritance());
        Relation classes = ProtobufReaders.fromMap$1(relations.getClassesMap(), this.stringToSource(), this.stringId());
        Relation productClassName = ProtobufReaders.fromMap$1(relations.getProductClassNameMap(), this.stringId(), this.stringId());
        UsedNames.JavaUsedNames names = UsedNames$.MODULE$.fromJavaMap(relations.getNamesMap());
        InternalDependencies internal = new InternalDependencies((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByMemberRef), (Object)memberRef.internal()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByInheritance), (Object)inheritance.internal()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.LocalDependencyByInheritance), (Object)localInheritance.internal())})));
        ExternalDependencies external = new ExternalDependencies((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByMemberRef), (Object)memberRef.external()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.DependencyByInheritance), (Object)inheritance.external()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DependencyContext.LocalDependencyByInheritance), (Object)localInheritance.external())})));
        return Relations$.MODULE$.make(srcProd, libraryDep, libraryClassName, internal, external, classes, (UsedNames)names, productClassName);
    }

    public APIs fromApis(boolean shouldStoreApis, Schema.APIs apis) {
        StringTable stringTable = new StringTable();
        scala.collection.immutable.Map internal = ((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(apis.getInternalMap()).asScala()).iterator().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Schema.AnalyzedClass v = (Schema.AnalyzedClass)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)this.fromAnalyzedClass(shouldStoreApis, stringTable, v));
            return tuple22;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map external = ((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(apis.getExternalMap()).asScala()).iterator().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Schema.AnalyzedClass v = (Schema.AnalyzedClass)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)this.fromAnalyzedClass(shouldStoreApis, stringTable, v));
            return tuple22;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return APIs$.MODULE$.apply(internal, external);
    }

    public Tuple2<APIs, Schema.Version> fromApisFile(Schema.APIsFile apisFile, boolean shouldStoreApis) {
        if (!apisFile.hasApis()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedApisInApisFile()).$bang$bang();
        }
        APIs apis = this.fromApis(shouldStoreApis, apisFile.getApis());
        Schema.Version version = apisFile.getVersion();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)apis), (Object)version);
    }

    public Analysis fromAnalysis(Schema.Analysis analysis) {
        if (!analysis.hasStamps()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Stamps.class)).$bang$bang();
        }
        Stamps stamps = this.fromStamps(analysis.getStamps());
        if (!analysis.hasRelations()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Relations.class)).$bang$bang();
        }
        Relations relations = this.fromRelations(analysis.getRelations());
        if (!analysis.hasSourceInfos()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.SourceInfos.class)).$bang$bang();
        }
        SourceInfos sourceInfos = this.fromSourceInfos(analysis.getSourceInfos());
        if (!analysis.hasCompilations()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$4(Schema.Compilations.class)).$bang$bang();
        }
        Compilations compilations = this.fromCompilations(analysis.getCompilations());
        Stamps x$1 = stamps;
        Relations x$2 = relations;
        SourceInfos x$3 = sourceInfos;
        Compilations x$4 = compilations;
        APIs x$5 = Analysis$.MODULE$.Empty().copy$default$2();
        return Analysis$.MODULE$.Empty().copy(x$1, x$5, x$2, x$3, x$4);
    }

    public Tuple3<Analysis, MiniSetup, Schema.Version> fromAnalysisFile(Schema.AnalysisFile analysisFile) {
        Schema.Version version = analysisFile.getVersion();
        if (!analysisFile.hasAnalysis()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(new StringBuilder(49).append("The analysis file from format ").append(version).append(" could not be read.").toString()).$bang$bang();
        }
        Analysis analysis = this.fromAnalysis(analysisFile.getAnalysis());
        if (!analysisFile.hasMiniSetup()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(new StringBuilder(46).append("The mini setup from format ").append(version).append(" could not be read.").toString()).$bang$bang();
        }
        MiniSetup miniSetup = this.fromMiniSetup(analysisFile.getMiniSetup());
        return new Tuple3((Object)analysis, (Object)miniSetup, (Object)version);
    }

    private final scala.collection.immutable.Map fromBinarySchemaMap$1(Map stamps) {
        return ((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
            VirtualFileRef file = this.fromPathStringV(path);
            VirtualFileRef newFile = $this.mapper.mapBinaryFile(file);
            Stamp stamp = this.fromStampType(schemaStamp);
            Stamp newStamp = $this.mapper.mapBinaryStamp(newFile, stamp);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            return tuple22;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final scala.collection.immutable.Map fromSourceSchemaMap$1(Map stamps) {
        return ((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
            VirtualFileRef file = this.fromPathStringV(path);
            VirtualFileRef newFile = $this.mapper.mapSourceFile(file);
            Stamp stamp = this.fromStampType(schemaStamp);
            Stamp newStamp = $this.mapper.mapSourceStamp(newFile, stamp);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            return tuple22;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final scala.collection.immutable.Map fromProductSchemaMap$1(Map stamps) {
        return ((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(stamps).asScala()).iterator().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Schema.Stamps.StampType schemaStamp = (Schema.Stamps.StampType)tuple2._2();
            VirtualFileRef file = this.fromPathStringV(path);
            VirtualFileRef newFile = $this.mapper.mapProductFile(file);
            Stamp stamp = this.fromStampType(schemaStamp);
            Stamp newStamp = $this.mapper.mapProductStamp(newFile, stamp);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newFile), (Object)newStamp);
            return tuple22;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final PathComponent fromPathComponent$1(Schema.Path.PathComponent pathComponent) {
        Id id;
        Schema.Path.PathComponent.ComponentCase componentCase = pathComponent.getComponentCase();
        if (Schema.Path.PathComponent.ComponentCase.ID.equals(componentCase)) {
            Schema.Id c = pathComponent.getId();
            id = Id.of((String)c.getId());
        } else if (Schema.Path.PathComponent.ComponentCase.SUPER.equals(componentCase)) {
            Schema.Super c = pathComponent.getSuper();
            if (!c.hasQualifier()) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPathInSuper()).$bang$bang();
            }
            Path q = this.fromPath(c.getQualifier());
            id = Super.of((Path)q);
        } else if (Schema.Path.PathComponent.ComponentCase.THIS.equals(componentCase)) {
            id = ProtobufDefaults$ReadersConstants$.MODULE$.This();
        } else {
            if (Schema.Path.PathComponent.ComponentCase.COMPONENT_NOT_SET.equals(componentCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expected(Schema.Path.PathComponent.ComponentCase.class, Schema.Path.PathComponent.class)).$bang$bang();
            }
            throw new MatchError((Object)componentCase);
        }
        return id;
    }

    private static final AnnotationArgument fromAnnotationArgument$1(Schema.AnnotationArgument argument) {
        String name = argument.getName().intern();
        String value = argument.getValue();
        return AnnotationArgument.of((String)name, (String)value);
    }

    private static final Lazy lazy$1(Object value) {
        return SafeLazyProxy$.MODULE$.strict(value);
    }

    private static final ParameterRef fromParameterRef$1(Schema.Type.ParameterRef tpe) {
        return ParameterRef.of((String)tpe.getId());
    }

    private final Parameterized fromParameterized$1(Schema.Type.Parameterized tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Parameterized.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        Type[] typeArguments = (Type[])this.EfficientTraverse(tpe.getTypeArgumentsList()).toZincArray((Function1 & Serializable)type -> this.fromType((Schema.Type)type), ClassTag$.MODULE$.apply(Type.class));
        return Parameterized.of((Type)baseType, (Type[])typeArguments);
    }

    private final Polymorphic fromPolymorphic$1(Schema.Type.Polymorphic tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Polymorphic.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(tpe.getTypeParametersList()).toZincArray((Function1 & Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return Polymorphic.of((Type)baseType, (TypeParameter[])typeParameters);
    }

    private final Constant fromConstant$1(Schema.Type.Constant tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Constant.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        String value = tpe.getValue();
        return Constant.of((Type)baseType, (String)value);
    }

    private final Existential fromExistential$1(Schema.Type.Existential tpe) {
        None$ b = tpe.hasBaseType() ? new Some((Object)tpe.getBaseType()) : None$.MODULE$;
        Type baseType = (Type)this.OptionReader((Option)b).read((Function1 & Serializable)type -> this.fromType((Schema.Type)type), (Function0<String>)(Function0 & Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Existential.class));
        TypeParameter[] clause = (TypeParameter[])this.EfficientTraverse(tpe.getClauseList()).toZincArray((Function1 & Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return Existential.of((Type)baseType, (TypeParameter[])clause);
    }

    private final Singleton fromSingleton$1(Schema.Type.Singleton tpe) {
        if (!tpe.hasPath()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPathInSingleton()).$bang$bang();
        }
        Path path = this.fromPath(tpe.getPath());
        return Singleton.of((Path)path);
    }

    private final Projection fromProjection$1(Schema.Type.Projection tpe) {
        String id = tpe.getId();
        if (!tpe.hasPrefix()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedPrefixInProjection()).$bang$bang();
        }
        Type prefix = this.fromType(tpe.getPrefix());
        return Projection.of((Type)prefix, (String)id);
    }

    private final Annotated fromAnnotated$1(Schema.Type.Annotated tpe) {
        if (!tpe.hasBaseType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedBaseIn(Schema.Type.Annotated.class)).$bang$bang();
        }
        Type baseType = this.fromType(tpe.getBaseType());
        Annotation[] annotations = (Annotation[])this.EfficientTraverse(tpe.getAnnotationsList()).toZincArray((Function1 & Serializable)annotation -> this.fromAnnotation((Schema.Annotation)annotation), ClassTag$.MODULE$.apply(Annotation.class));
        return Annotated.of((Type)baseType, (Annotation[])annotations);
    }

    private static final Qualifier fromQualifier$1(Schema.Qualifier qualifier) {
        IdQualifier idQualifier;
        Schema.Qualifier.TypeCase typeCase = qualifier.getTypeCase();
        if (Schema.Qualifier.TypeCase.IDQUALIFIER.equals(typeCase)) {
            Schema.IdQualifier q = qualifier.getIdQualifier();
            idQualifier = IdQualifier.of((String)q.getValue());
        } else if (Schema.Qualifier.TypeCase.THISQUALIFIER.equals(typeCase)) {
            idQualifier = ProtobufDefaults$ReadersConstants$.MODULE$.ThisQualifier();
        } else if (Schema.Qualifier.TypeCase.UNQUALIFIED.equals(typeCase)) {
            idQualifier = ProtobufDefaults$ReadersConstants$.MODULE$.Unqualified();
        } else {
            if (Schema.Qualifier.TypeCase.TYPE_NOT_SET.equals(typeCase)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedNonEmptyQualifier()).$bang$bang();
            }
            throw new MatchError((Object)typeCase);
        }
        return idQualifier;
    }

    private final Qualifier readQualifier$1(Option qualifier2) {
        return (Qualifier)this.OptionReader(qualifier2).read((Function1 & Serializable)qualifier -> ProtobufReaders.fromQualifier$1(qualifier), (Function0<String>)(Function0 & Serializable)() -> ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedQualifierInAccess());
    }

    private static final ParameterModifier fromParameterModifier$1(Schema.ParameterModifier modifier) {
        ParameterModifier parameterModifier;
        Schema.ParameterModifier parameterModifier2 = modifier;
        if (Schema.ParameterModifier.PLAIN.equals(parameterModifier2)) {
            parameterModifier = ParameterModifier.Plain;
        } else if (Schema.ParameterModifier.BYNAME.equals(parameterModifier2)) {
            parameterModifier = ParameterModifier.ByName;
        } else if (Schema.ParameterModifier.REPEATED.equals(parameterModifier2)) {
            parameterModifier = ParameterModifier.Repeated;
        } else {
            if (Schema.ParameterModifier.UNRECOGNIZED.equals(parameterModifier2)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedParamModifier()).$bang$bang();
            }
            throw new MatchError((Object)parameterModifier2);
        }
        return parameterModifier;
    }

    private final MethodParameter fromMethodParameter$1(Schema.MethodParameter methodParameter) {
        String name = methodParameter.getName().intern();
        boolean hasDefault = methodParameter.getHasDefault();
        if (!methodParameter.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.MethodParameter.class)).$bang$bang();
        }
        Type type = this.fromType(methodParameter.getType());
        ParameterModifier modifier = ProtobufReaders.fromParameterModifier$1(methodParameter.getModifier());
        return MethodParameter.of((String)name, (Type)type, (boolean)hasDefault, (ParameterModifier)modifier);
    }

    private final ParameterList fromParameterList$1(Schema.ParameterList parameterList) {
        boolean isImplicit = parameterList.getIsImplicit();
        MethodParameter[] parameters = (MethodParameter[])this.EfficientTraverse(parameterList.getParametersList()).toZincArray((Function1 & Serializable)methodParameter -> this.fromMethodParameter$1((Schema.MethodParameter)methodParameter), ClassTag$.MODULE$.apply(MethodParameter.class));
        return ParameterList.of((MethodParameter[])parameters, (boolean)isImplicit);
    }

    private final ClassLikeDef fromClassLikeDef$1(Schema.ClassDefinition.ClassLikeDef defDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        DefinitionType definitionType = this.fromDefinitionType(defDef.getDefinitionType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(defDef.getTypeParametersList()).toZincArray((Function1 & Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return ClassLikeDef.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (DefinitionType)definitionType);
    }

    private final Def fromDefDef$1(Schema.ClassDefinition.Def defDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!defDef.hasReturnType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedReturnTypeInDef()).$bang$bang();
        }
        Type returnType = this.fromType(defDef.getReturnType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(defDef.getTypeParametersList()).toZincArray((Function1 & Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        ParameterList[] valueParameters = (ParameterList[])this.EfficientTraverse(defDef.getValueParametersList()).toZincArray((Function1 & Serializable)parameterList -> this.fromParameterList$1((Schema.ParameterList)parameterList), ClassTag$.MODULE$.apply(ParameterList.class));
        return Def.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (ParameterList[])valueParameters, (Type)returnType);
    }

    private final Val fromValDef$1(Schema.ClassDefinition.Val valDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!valDef.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.Val.class)).$bang$bang();
        }
        Type tpe = this.fromType(valDef.getType());
        return Val.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (Type)tpe);
    }

    private final Var fromVarDef$1(Schema.ClassDefinition.Var varDef, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!varDef.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.Var.class)).$bang$bang();
        }
        Type tpe = this.fromType(varDef.getType());
        return Var.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (Type)tpe);
    }

    private final TypeAlias fromTypeAlias$1(Schema.ClassDefinition.TypeAlias typeAlias, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!typeAlias.hasType()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.expectedTypeIn(Schema.ClassDefinition.TypeAlias.class)).$bang$bang();
        }
        Type tpe = this.fromType(typeAlias.getType());
        TypeParameter[] typeParameters = (TypeParameter[])this.EfficientTraverse(typeAlias.getTypeParametersList()).toZincArray((Function1 & Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return TypeAlias.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParameters, (Type)tpe);
    }

    private final TypeDeclaration fromTypeDeclaration$1(Schema.ClassDefinition.TypeDeclaration decl, String name$1, Access access$1, Modifiers modifiers$1, Annotation[] annotations$1) {
        if (!decl.hasLowerBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedLowerBoundInTypeDeclaration()).$bang$bang();
        }
        Type lowerBound = this.fromType(decl.getLowerBound());
        if (!decl.hasUpperBound()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.ExpectedUpperBoundInTypeDeclaration()).$bang$bang();
        }
        Type upperBound = this.fromType(decl.getUpperBound());
        TypeParameter[] typeParams = (TypeParameter[])this.EfficientTraverse(decl.getTypeParametersList()).toZincArray((Function1 & Serializable)typeParameter -> this.fromTypeParameter((Schema.TypeParameter)typeParameter), ClassTag$.MODULE$.apply(TypeParameter.class));
        return TypeDeclaration.of((String)name$1, (Access)access$1, (Modifiers)modifiers$1, (Annotation[])annotations$1, (TypeParameter[])typeParams, (Type)lowerBound, (Type)upperBound);
    }

    private static final Variance fromVariance$1(Schema.Variance variance) {
        Variance variance2;
        Schema.Variance variance3 = variance;
        if (Schema.Variance.INVARIANT.equals(variance3)) {
            variance2 = Variance.Invariant;
        } else if (Schema.Variance.COVARIANT.equals(variance3)) {
            variance2 = Variance.Covariant;
        } else if (Schema.Variance.CONTRAVARIANT.equals(variance3)) {
            variance2 = Variance.Contravariant;
        } else {
            if (Schema.Variance.UNRECOGNIZED.equals(variance3)) {
                throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufDefaults$Feedback$Readers$.MODULE$.UnrecognizedVariance()).$bang$bang();
            }
            throw new MatchError((Object)variance3);
        }
        return variance2;
    }

    private static final String expectedMsg$1(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.ClassLike.class);
    }

    private static final String expected$1(Class clazz) {
        return ProtobufReaders.expectedMsg$1(clazz.getName());
    }

    private static final String expected$2(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.Companions.class);
    }

    private final Companions fromCompanions$1(Schema.Companions companions) {
        if (!companions.hasClassApi()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$2("class api")).$bang$bang();
        }
        ClassLike classApi = this.fromClassLike(companions.getClassApi());
        if (!companions.hasObjectApi()) {
            throw ProtobufDefaults$Feedback$.MODULE$.StringToException(ProtobufReaders.expected$2("object api")).$bang$bang();
        }
        ClassLike objectApi = this.fromClassLike(companions.getObjectApi());
        return Companions.of((ClassLike)classApi, (ClassLike)objectApi);
    }

    private final NameHash fromNameHash$1(Schema.NameHash nameHash, StringTable stringTable$1) {
        String name = stringTable$1.lookupOrEnter(nameHash.getName());
        int hash = nameHash.getHash();
        UseScope scope = this.fromUseScope(nameHash.getScope(), nameHash.getScopeValue());
        return NameHash.of((String)name, (UseScope)scope, (int)hash);
    }

    public static final /* synthetic */ boolean $anonfun$fromRelations$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$fromRelations$2(Function1 fk$1, RelationBuilder builder$1, Function1 fv$1, Tuple2 x$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            String kString = (String)tuple2._1();
            Schema.Values vs = (Schema.Values)tuple2._2();
            if (!vs.getValuesList().isEmpty()) {
                Object k = fk$1.apply((Object)kString);
                ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)vs.getValuesList()).asScala()).foreach((Function1 & Serializable)vString -> {
                    builder$1.update(k, fv$1.apply((Object)vString));
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private static final Relation fromMap$1(Map map, Function1 fk, Function1 fv) {
        RelationBuilder builder = new RelationBuilder();
        ((MapFactoryDefaults)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ProtobufReaders.$anonfun$fromRelations$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            ProtobufReaders.$anonfun$fromRelations$2(fk, builder, fv, x$3);
            return BoxedUnit.UNIT;
        });
        return builder.result();
    }

    private final Relations.ClassDependencies fromClassDependencies$1(Schema.ClassDependencies classDependencies) {
        Relation internal = ProtobufReaders.fromMap$1(classDependencies.getInternalMap(), this.stringId(), this.stringId());
        Relation external = ProtobufReaders.fromMap$1(classDependencies.getExternalMap(), this.stringId(), this.stringId());
        return new Relations.ClassDependencies(internal, external);
    }

    private static final String expected$3(String msg) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(msg, Schema.Relations.class);
    }

    private static final String expected$4(Class clazz) {
        return ProtobufDefaults$Feedback$Readers$.MODULE$.expected(clazz, Schema.Analysis.class);
    }

    public ProtobufReaders(ReadMapper mapper, Schema.Version currentVersion) {
        this.mapper = mapper;
        this.currentVersion = currentVersion;
        this.stringId = (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
        this.stringToSource = (Function1 & Serializable)path -> $this.mapper.mapSourceFile(this.fromPathStringV((String)path));
        this.stringToLibrary = (Function1 & Serializable)path -> $this.mapper.mapBinaryFile(this.fromPathStringV((String)path));
        this.stringToProd = (Function1 & Serializable)path -> $this.mapper.mapProductFile(this.fromPathStringV((String)path));
    }

    public class EfficientTraverse<T> {
        private final java.util.List<T> seq;
        public final /* synthetic */ ProtobufReaders $outer;

        public <R> R[] toZincArray(Function1<T, R> f, ClassTag<R> evidence$1) {
            return this.seq.stream().map(x -> f.apply(x)).toArray(x$2 -> (Object[])evidence$1.newArray(x$2));
        }

        public /* synthetic */ ProtobufReaders sbt$internal$inc$binary$converters$ProtobufReaders$EfficientTraverse$$$outer() {
            return this.$outer;
        }

        public EfficientTraverse(ProtobufReaders $outer, java.util.List<T> seq) {
            this.seq = seq;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class OptionReader<T> {
        private final Option<T> option;
        public final /* synthetic */ ProtobufReaders $outer;

        public <R> R read(Function1<T, R> from, Function0<String> errorMessage) {
            return (R)this.option.fold((Function0 & Serializable)() -> ProtobufDefaults$Feedback$.MODULE$.StringToException((String)errorMessage.apply()).$bang$bang(), from);
        }

        public /* synthetic */ ProtobufReaders sbt$internal$inc$binary$converters$ProtobufReaders$OptionReader$$$outer() {
            return this.$outer;
        }

        public OptionReader(ProtobufReaders $outer, Option<T> option) {
            this.option = option;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private class StringTable {
        private final HashMap<String, String> strings;

        private HashMap<String, String> strings() {
            return this.strings;
        }

        public String lookupOrEnter(String string) {
            String string2;
            block3: {
                String string3 = this.strings().putIfAbsent(string, string);
                switch (string3 == null ? 0 : string3.hashCode()) {
                    case 0: {
                        if (string3 != null) break;
                        string2 = string;
                        break block3;
                    }
                }
                string2 = string3;
            }
            return string2;
        }

        public /* synthetic */ ProtobufReaders sbt$internal$inc$binary$converters$ProtobufReaders$StringTable$$$outer() {
            return ProtobufReaders.this;
        }

        public StringTable() {
            if (ProtobufReaders.this == null) {
                throw null;
            }
            this.strings = new HashMap();
        }
    }
}

