/*
 * Decompiled with CFR 0.152.
 */
package org_scala_tools_maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.util.FileUtils;
import org_scala_tools_maven.ScalaMojoSupport;
import org_scala_tools_maven_executions.JavaMainCaller;
import org_scala_tools_maven_executions.MainHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScalaCompilerSupport
extends ScalaMojoSupport {
    public static final String ALL = "all";
    public static final String MODIFIED_ONLY = "modified-only";
    protected long loopSleep = 2500L;
    private String recompileMode = "all";
    private boolean notifyCompilation = true;
    protected boolean sendJavaToScalac = true;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private long _lastCompileAt = -1L;

    protected abstract File getOutputDir() throws Exception;

    protected abstract List<String> getClasspathElements() throws Exception;

    protected abstract List<String> getSourceDirectories() throws Exception;

    @Override
    protected void doExecute() throws Exception {
        File outputDir = this.normalize(this.getOutputDir());
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if (this.getLog().isDebugEnabled()) {
            for (String directory : this.getSourceDirectories()) {
                this.getLog().debug((CharSequence)directory);
            }
        }
        int nbFiles = this.compile(this.normalize(this.getSourceDirectories()), outputDir, this.getClasspathElements(), false);
        switch (nbFiles) {
            case -1: {
                this.getLog().warn((CharSequence)"No source files found.");
                break;
            }
            case 0: {
                this.getLog().info((CharSequence)"Nothing to compile - all classes are up to date");
                break;
            }
        }
    }

    protected File normalize(File f) {
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException exc) {
            f = f.getAbsoluteFile();
        }
        return f;
    }

    private List<File> normalize(List<String> compileSourceRootsList) {
        ArrayList<File> newCompileSourceRootsList = new ArrayList<File>();
        if (compileSourceRootsList != null) {
            for (String srcDir : compileSourceRootsList) {
                File srcDirFile = this.normalize(new File(srcDir));
                if (newCompileSourceRootsList.contains(srcDirFile) || !srcDirFile.exists()) continue;
                newCompileSourceRootsList.add(srcDirFile);
            }
        }
        return newCompileSourceRootsList;
    }

    protected int compile(File sourceDir, File outputDir, List<String> classpathElements, boolean compileInLoop) throws Exception, InterruptedException {
        return this.compile(Arrays.asList(sourceDir), outputDir, classpathElements, compileInLoop);
    }

    protected int compile(List<File> sourceRootDirs, File outputDir, List<String> classpathElements, boolean compileInLoop) throws Exception, InterruptedException {
        List<File> files;
        long t0 = System.currentTimeMillis();
        if (this._lastCompileAt < 0L) {
            this._lastCompileAt = this.findLastSuccessfullCompilation(outputDir);
        }
        if ((files = this.getFilesToCompile(sourceRootDirs, this._lastCompileAt)) == null) {
            return -1;
        }
        if (files.size() < 1) {
            return 0;
        }
        long t1 = System.currentTimeMillis();
        this.getLog().info((CharSequence)String.format("Compiling %d source files to %s at %d", files.size(), outputDir.getAbsolutePath(), t1));
        JavaMainCaller jcmd = this.getScalaCommand();
        jcmd.redirectToLog();
        jcmd.addArgs("-classpath", MainHelper.toMultiPath(classpathElements));
        jcmd.addArgs("-d", outputDir.getAbsolutePath());
        for (File f : files) {
            jcmd.addArgs(f.getAbsolutePath());
        }
        if (jcmd.run(this.displayCmd, !compileInLoop)) {
            this.setLastSuccessfullCompilation(outputDir, t1);
        }
        this.getLog().info((CharSequence)String.format("prepare-compile in %d s", (t1 - t0) / 1000L));
        this.getLog().info((CharSequence)String.format("compile in %d s", (System.currentTimeMillis() - t1) / 1000L));
        this._lastCompileAt = t1;
        return files.size();
    }

    protected List<File> getFilesToCompile(List<File> sourceRootDirs, long lastSuccessfullCompileTime) throws Exception {
        List<File> sourceFiles;
        if (this.includes.isEmpty()) {
            this.includes.add("**/*.scala");
            if (this.sendJavaToScalac && this.isJavaSupportedByCompiler()) {
                this.includes.add("**/*.java");
            }
        }
        if (this._lastCompileAt < 0L && this.getLog().isInfoEnabled()) {
            StringBuilder builder = new StringBuilder("includes = [");
            for (String include : this.includes) {
                builder.append(include).append(",");
            }
            builder.append("]");
            this.getLog().info((CharSequence)builder.toString());
            builder = new StringBuilder("excludes = [");
            for (String exclude : this.excludes) {
                builder.append(exclude).append(",");
            }
            builder.append("]");
            this.getLog().info((CharSequence)builder.toString());
        }
        if ((sourceFiles = this.findSourceWithFilters(sourceRootDirs)).size() == 0) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>(sourceFiles.size());
        if (this._lastCompileAt > 0L || !ALL.equals(this.recompileMode) && lastSuccessfullCompileTime > 0L) {
            ArrayList<File> modifiedScalaFiles = new ArrayList<File>(sourceFiles.size());
            ArrayList<File> modifiedJavaFiles = new ArrayList<File>(sourceFiles.size());
            ArrayList<File> allJavaFiles = new ArrayList<File>(sourceFiles.size());
            for (File f : sourceFiles) {
                if (f.getName().endsWith(".java")) {
                    allJavaFiles.add(f);
                }
                if (f.lastModified() < lastSuccessfullCompileTime) continue;
                if (f.getName().endsWith(".java")) {
                    modifiedJavaFiles.add(f);
                    continue;
                }
                modifiedScalaFiles.add(f);
            }
            if (modifiedScalaFiles.size() != 0 || modifiedJavaFiles.size() != 0) {
                if (modifiedScalaFiles.size() != 0 && MODIFIED_ONLY.equals(this.recompileMode)) {
                    files.addAll(allJavaFiles);
                    files.addAll(modifiedScalaFiles);
                    this.notifyCompilation(files);
                } else {
                    files.addAll(sourceFiles);
                    this.notifyCompilation(sourceRootDirs);
                }
            }
        } else {
            files.addAll(sourceFiles);
            this.notifyCompilation(sourceRootDirs);
        }
        return files;
    }

    private List<File> findSourceWithFilters(List<File> sourceRootDirs) {
        ArrayList<File> sourceFiles = new ArrayList<File>();
        for (File dir : sourceRootDirs) {
            String[] tmpFiles;
            for (String tmpLocalFile : tmpFiles = MainHelper.findFiles(dir, this.includes.toArray(new String[this.includes.size()]), this.excludes.toArray(new String[this.excludes.size()]))) {
                File tmpAbsFile = this.normalize(new File(dir, tmpLocalFile));
                sourceFiles.add(tmpAbsFile);
            }
        }
        Collections.sort(sourceFiles);
        return sourceFiles;
    }

    private void notifyCompilation(List<File> files) throws Exception {
        if (this.notifyCompilation) {
            for (File f : files) {
                this.getLog().info((CharSequence)String.format("%s:-1: info: compiling", f.getCanonicalPath()));
            }
        }
    }

    private long findLastSuccessfullCompilation(File outputDir) throws Exception {
        long back = -1L;
        File lastCompileAtFile = new File(outputDir + ".timestamp");
        if (lastCompileAtFile.exists() && outputDir.exists() && outputDir.list().length > 0) {
            back = lastCompileAtFile.lastModified();
        }
        return back;
    }

    private void setLastSuccessfullCompilation(File outputDir, long v) throws Exception {
        File lastCompileAtFile = new File(outputDir + ".timestamp");
        if (!lastCompileAtFile.exists()) {
            FileUtils.fileWrite((String)lastCompileAtFile.getAbsolutePath(), (String)".");
        }
        lastCompileAtFile.setLastModified(v);
    }
}

