/*
 * Decompiled with CFR 0.152.
 */
package org_scala_tools_maven;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;
import org_scala_tools_maven.BasicArtifact;
import org_scala_tools_maven.ScalaMojoSupport;
import org_scala_tools_maven.VersionNumber;
import org_scala_tools_maven_executions.JavaMainCaller;
import org_scala_tools_maven_executions.MainHelper;

public class ScalaDocMojo
extends ScalaMojoSupport
implements MavenReport {
    protected String windowtitle;
    protected String bottom;
    protected String charset;
    protected String doctitle;
    protected String footer;
    protected String header;
    protected boolean linksource;
    protected boolean nocomment;
    protected File stylesheetfile;
    protected String top;
    protected File sourceDir;
    private String outputDirectory;
    private File reportOutputDirectory;
    private String name;
    private String description;
    protected String scaladocClassName;
    protected String vscaladocVersion;
    protected boolean forceAggregate = false;
    protected boolean aggregateDirectOnly = true;
    private String[] sourceFiles_ = null;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();

    private String[] findSourceFiles() {
        if (this.sourceFiles_ == null) {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*.scala");
            }
            this.sourceFiles_ = MainHelper.findFiles(this.sourceDir, this.includes.toArray(new String[this.includes.size()]), this.excludes.toArray(new String[this.excludes.size()]));
        }
        return this.sourceFiles_;
    }

    public boolean canGenerateReport() {
        try {
            this.sourceDir = this.sourceDir.getCanonicalFile();
        }
        catch (IOException exc) {
            this.sourceDir = this.sourceDir.getAbsoluteFile();
        }
        boolean back = this.sourceDir.exists() && this.findSourceFiles().length != 0;
        back = back || (this.project.isExecutionRoot() || this.forceAggregate) && this.canAggregate() && this.project.getCollectedProjects().size() > 0;
        return back;
    }

    private boolean canAggregate() {
        return StringUtils.isNotEmpty((String)this.vscaladocVersion) && new VersionNumber(this.vscaladocVersion).compareTo(new VersionNumber("1.1")) >= 0;
    }

    public boolean isExternalReport() {
        return true;
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.description)) {
            return "ScalaDoc API documentation";
        }
        return this.description;
    }

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.name)) {
            return "ScalaDocs";
        }
        return this.name;
    }

    public String getOutputName() {
        return this.outputDirectory + "/index";
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            this.reportOutputDirectory = new File(this.project.getBasedir(), this.project.getReporting().getOutputDirectory() + "/" + this.outputDirectory).getAbsoluteFile();
        }
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith(this.outputDirectory) ? new File(reportOutputDirectory, this.outputDirectory) : reportOutputDirectory;
    }

    public void doExecute() throws Exception {
        this.generate(null, Locale.getDefault());
    }

    protected JavaMainCaller getScalaCommand() throws Exception {
        boolean isScaladoc2;
        boolean isPreviousScala271;
        this.checkScalaVersion();
        boolean bl = isPreviousScala271 = new VersionNumber("2.7.1").compareTo(new VersionNumber(this.scalaVersion)) > 0;
        if (StringUtils.isEmpty((String)this.scaladocClassName)) {
            this.scaladocClassName = !isPreviousScala271 ? "scala.tools.nsc.ScalaDoc" : this.scalaClassName;
        }
        JavaMainCaller jcmd = this.getEmptyScalaCommand(this.scaladocClassName);
        jcmd.addArgs(this.args);
        jcmd.addJvmArgs(this.jvmArgs);
        if (isPreviousScala271) {
            jcmd.addArgs("-Ydoc");
        }
        List paths = this.project.getCompileClasspathElements();
        paths.remove(this.project.getBuild().getOutputDirectory());
        jcmd.addOption("-classpath", MainHelper.toMultiPath(paths));
        jcmd.addOption("-sourcepath", this.sourceDir.getAbsolutePath());
        boolean bl2 = isScaladoc2 = new VersionNumber("2.8.0").compareTo(new VersionNumber(this.scalaVersion)) <= 0 && "scala.tools.nsc.ScalaDoc".equals(this.scaladocClassName);
        if (isScaladoc2) {
            jcmd.addArgs("-doc-format:html");
            jcmd.addOption("-doc-title", this.doctitle);
        } else {
            jcmd.addOption("-bottom", this.getBottomText());
            jcmd.addOption("-charset", this.charset);
            jcmd.addOption("-doctitle", this.doctitle);
            jcmd.addOption("-footer", this.footer);
            jcmd.addOption("-header", this.header);
            jcmd.addOption("-linksource", this.linksource);
            jcmd.addOption("-nocomment", this.nocomment);
            jcmd.addOption("-stylesheetfile", this.stylesheetfile);
            jcmd.addOption("-top", this.top);
            jcmd.addOption("-windowtitle", this.windowtitle);
        }
        return jcmd;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        try {
            if (!this.canGenerateReport()) {
                this.getLog().warn((CharSequence)("No source files found in " + this.sourceDir));
                return;
            }
            File reportOutputDir = this.getReportOutputDirectory();
            if (!reportOutputDir.exists()) {
                reportOutputDir.mkdirs();
            }
            if (StringUtils.isNotEmpty((String)this.vscaladocVersion)) {
                this.scaladocClassName = "org.scala_tools.vscaladoc.Main";
                BasicArtifact artifact = new BasicArtifact();
                artifact.artifactId = "vscaladoc";
                artifact.groupId = "org.scala-tools";
                artifact.version = this.vscaladocVersion;
                this.dependencies = new BasicArtifact[]{artifact};
            }
            if (this.sourceDir.exists()) {
                JavaMainCaller jcmd = this.getScalaCommand();
                jcmd.addOption("-d", reportOutputDir.getAbsolutePath());
                String[] sources = this.findSourceFiles();
                if (sources.length > 0) {
                    for (String x : sources) {
                        jcmd.addArgs(this.sourceDir + File.separator + x);
                    }
                    jcmd.run(this.displayCmd);
                }
            }
            if (this.forceAggregate) {
                this.aggregate(this.project);
            } else {
                this.tryAggregateUpper(this.project);
            }
        }
        catch (MavenReportException exc) {
            throw exc;
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MavenReportException("wrap: " + exc.getMessage(), exc);
        }
    }

    protected void tryAggregateUpper(MavenProject prj) throws Exception {
        MavenProject parent;
        List modules;
        if (prj != null && prj.hasParent() && this.canAggregate() && (modules = (parent = prj.getParent()).getCollectedProjects()).size() > 1 && prj.equals(modules.get(modules.size() - 1))) {
            this.aggregate(parent);
        }
    }

    protected void aggregate(MavenProject parent) throws Exception {
        List modules = parent.getCollectedProjects();
        File dest = new File(parent.getReporting().getOutputDirectory() + "/" + this.outputDirectory);
        this.getLog().info((CharSequence)("start aggregation into " + dest));
        StringBuilder mpath = new StringBuilder();
        for (MavenProject module : modules) {
            File subScaladocPath;
            if ("pom".equals(module.getPackaging().toLowerCase()) || this.aggregateDirectOnly && module.getParent() != parent || !(subScaladocPath = new File(module.getReporting().getOutputDirectory() + "/" + this.outputDirectory).getAbsoluteFile()).exists()) continue;
            mpath.append(subScaladocPath).append(File.pathSeparatorChar);
        }
        if (mpath.length() != 0) {
            this.getLog().info((CharSequence)("aggregate vscaladoc from : " + mpath));
            JavaMainCaller jcmd = this.getScalaCommand();
            jcmd.addOption("-d", dest.getAbsolutePath());
            jcmd.addOption("-aggregate", mpath.toString());
            jcmd.run(this.displayCmd);
        } else {
            this.getLog().warn((CharSequence)"no vscaladoc to aggregate");
        }
        this.tryAggregateUpper(parent);
    }

    private String getBottomText() {
        String inceptionYear = this.project.getInceptionYear();
        int actualYear = Calendar.getInstance().get(1);
        String year = String.valueOf(actualYear);
        String theBottom = StringUtils.replace((String)this.bottom, (String)"{currentYear}", (String)year);
        theBottom = inceptionYear != null ? (inceptionYear.equals(year) ? StringUtils.replace((String)theBottom, (String)"{inceptionYear}-", (String)"") : StringUtils.replace((String)theBottom, (String)"{inceptionYear}", (String)inceptionYear)) : StringUtils.replace((String)theBottom, (String)"{inceptionYear}-", (String)"");
        theBottom = this.project.getOrganization() == null ? StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)"") : (this.project.getOrganization() != null && StringUtils.isNotEmpty((String)this.project.getOrganization().getName()) ? (StringUtils.isNotEmpty((String)this.project.getOrganization().getUrl()) ? StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)("<a href=\"" + this.project.getOrganization().getUrl() + "\">" + this.project.getOrganization().getName() + "</a>")) : StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)this.project.getOrganization().getName())) : StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)""));
        return theBottom;
    }
}

