/*
 * Decompiled with CFR 0.152.
 */
package org.semver;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.osjava.jardiff.DiffCriteria;
import org.osjava.jardiff.DiffException;
import org.osjava.jardiff.JarDiff;
import org.semver.Delta;
import org.semver.jardiff.DifferenceAccumulatingHandler;

@NotThreadSafe
public class Comparer {
    private final DiffCriteria diffCriteria;
    private final File previousJAR;
    private final File currentJAR;
    private final Set<String> includes;
    private final boolean includesAreRegExp;
    private final Set<String> excludes;
    private final boolean excludesAreRegExp;

    public Comparer(DiffCriteria diffCriteria, File previousJAR, File currentJAR, Set<String> includes, Set<String> excludes) {
        this(diffCriteria, previousJAR, currentJAR, includes, false, excludes, false);
    }

    public Comparer(DiffCriteria diffCriteria, File previousJAR, File currentJAR, Set<String> includes, boolean includesAreRegExp, Set<String> excludes, boolean excludesAreRegExp) {
        if (!previousJAR.isFile()) {
            throw new IllegalArgumentException("<" + previousJAR + "> is not a valid file");
        }
        if (!currentJAR.isFile()) {
            throw new IllegalArgumentException("<" + currentJAR + "> is not a valid file");
        }
        this.diffCriteria = diffCriteria;
        this.previousJAR = previousJAR;
        this.currentJAR = currentJAR;
        this.includes = includes;
        this.includesAreRegExp = includesAreRegExp;
        this.excludes = excludes;
        this.excludesAreRegExp = excludesAreRegExp;
    }

    public final Delta diff() throws IOException {
        try {
            JarDiff jarDiff = new JarDiff();
            jarDiff.loadOldClasses(this.previousJAR);
            jarDiff.loadNewClasses(this.currentJAR);
            DifferenceAccumulatingHandler handler = new DifferenceAccumulatingHandler(this.includes, this.includesAreRegExp, this.excludes, this.excludesAreRegExp);
            jarDiff.diff(handler, this.diffCriteria);
            return handler.getDelta();
        }
        catch (DiffException e) {
            throw new RuntimeException(e);
        }
    }
}

