/*
 * Decompiled with CFR 0.152.
 */
package org.semver;

import de.tototec.cmdoption.CmdOption;
import de.tototec.cmdoption.CmdlineParser;
import de.tototec.cmdoption.CmdlineParserException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.osjava.jardiff.DiffCriteria;
import org.osjava.jardiff.PublicDiffCriteria;
import org.osjava.jardiff.SimpleDiffCriteria;
import org.semver.Comparer;
import org.semver.Delta;
import org.semver.Dumper;
import org.semver.Version;

public class Main {
    public static void main(String[] args) throws IOException {
        Config config = new Config();
        CmdlineParser cmdlineParser = new CmdlineParser(new Object[]{config});
        cmdlineParser.setResourceBundle(Main.class.getPackage().getName() + ".Messages", Main.class.getClassLoader());
        cmdlineParser.setProgramName("semver");
        cmdlineParser.setAboutLine("Semantic Version validator.");
        try {
            cmdlineParser.parse(args);
        }
        catch (CmdlineParserException e) {
            System.err.println("Error: " + e.getLocalizedMessage() + "\nRun semver --help for help.");
            System.exit(1);
        }
        if (config.help) {
            cmdlineParser.usage();
            System.exit(0);
        }
        DiffCriteria diffCriteria = config.publicOnly ? new PublicDiffCriteria() : new SimpleDiffCriteria();
        Comparer comparer = new Comparer(diffCriteria, new File(config.baseJar), new File(config.newJar), config.includes, config.excludes);
        Delta delta = comparer.diff();
        if (config.diff) {
            Dumper.dump(delta);
        }
        if (config.check) {
            System.out.println((Object)delta.computeCompatibilityType());
        }
        if (config.infer) {
            System.out.println(delta.infer(Version.parse(config.baseVersion)));
        }
        if (config.validate) {
            System.out.println(delta.validate(Version.parse(config.baseVersion), Version.parse(config.newVersion)));
        }
    }

    static class Config {
        @CmdOption(names={"--help", "-h"}, description="Show this help and exit.", isHelp=true)
        boolean help;
        @CmdOption(names={"--diff", "-d"}, conflictsWith={"--check", "--infer", "--validate"}, description="Show the differences between two jars.")
        public boolean diff;
        @CmdOption(names={"--check", "-c"}, conflictsWith={"--diff", "--infer", "--validate"}, description="Check the compatibility of two jars.")
        public boolean check;
        @CmdOption(names={"--publicOnly", "-p"}, description="Checks public members only")
        public boolean publicOnly;
        @CmdOption(names={"--infer", "-i"}, requires={"--base-version"}, conflictsWith={"--diff", "--check", "--validate"}, description="Infer the version of the new jar based on the previous jar.")
        public boolean infer;
        @CmdOption(names={"--validate", "-v"}, requires={"--base-version", "--new-version"}, conflictsWith={"--diff", "--check", "--infer"}, description="Validate that the versions of two jars fulfil the semver specification.")
        public boolean validate;
        @CmdOption(names={"--base-jar"}, args={"JAR"}, minCount=1, description="The base jar.")
        public String baseJar;
        @CmdOption(names={"--new-jar"}, args={"JAR"}, minCount=1, description="The new jar.")
        public String newJar;
        final Set<String> includes = new LinkedHashSet<String>();
        final Set<String> excludes = new LinkedHashSet<String>();
        @CmdOption(names={"--base-version"}, args={"VERSION"}, description="Version of the base jar (given with --base-jar).")
        public String baseVersion;
        @CmdOption(names={"--new-version"}, args={"VERSION"}, description="Version of the new jar (given with --new-jar).")
        public String newVersion;

        Config() {
        }

        @CmdOption(names={"--includes"}, args={"INCLUDE;..."}, description="Semicolon separated list of full qualified class names to be included.")
        public void setIncludes(String includes) {
            if (includes != null) {
                this.includes.addAll(Arrays.asList(includes.split(";")));
            }
        }

        @CmdOption(names={"--excludes"}, args={"EXCLUDE;..."}, description="Semicolon separated list of full qualified class names to be excluded.")
        public void setExcludes(String excludes) {
            if (excludes != null) {
                this.excludes.addAll(Arrays.asList(excludes.split(";")));
            }
        }
    }
}

