/*
 * Decompiled with CFR 0.152.
 */
package org.skife.config;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeSpan {
    private final long period;
    private final TimeUnit unit;
    private final long millis;
    private static final Pattern SPLIT = Pattern.compile("^(\\d+)\\s?(\\w+)$");
    private static final HashMap<String, TimeUnit> UNITS = new HashMap();

    public TimeSpan(String spec) {
        Matcher m = SPLIT.matcher(spec);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("%s is not a valid time spec", spec));
        }
        String number = m.group(1);
        String type = m.group(2);
        this.period = Long.parseLong(number);
        this.unit = UNITS.get(type);
        if (this.unit == null) {
            throw new IllegalArgumentException(String.format("%s is not a valid time unit in %s", type, spec));
        }
        this.millis = TimeUnit.MILLISECONDS.convert(this.period, this.unit);
    }

    public TimeSpan(long period, TimeUnit unit) {
        this.period = period;
        this.unit = unit;
        this.millis = TimeUnit.MILLISECONDS.convert(period, unit);
    }

    public long getMillis() {
        return this.millis;
    }

    public long getPeriod() {
        return this.period;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public String toString() {
        switch (this.unit) {
            case SECONDS: {
                return this.period + "s";
            }
            case MINUTES: {
                return this.period + "m";
            }
            case HOURS: {
                return this.period + "h";
            }
            case DAYS: {
                return this.period + "d";
            }
        }
        return this.period + "ms";
    }

    public int hashCode() {
        return 31 + (int)(this.millis ^ this.millis >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeSpan other = (TimeSpan)obj;
        return this.millis == other.millis;
    }

    static {
        UNITS.put("ms", TimeUnit.MILLISECONDS);
        UNITS.put("millisecond", TimeUnit.MILLISECONDS);
        UNITS.put("milliseconds", TimeUnit.MILLISECONDS);
        UNITS.put("s", TimeUnit.SECONDS);
        UNITS.put("second", TimeUnit.SECONDS);
        UNITS.put("seconds", TimeUnit.SECONDS);
        UNITS.put("m", TimeUnit.MINUTES);
        UNITS.put("minute", TimeUnit.MINUTES);
        UNITS.put("minutes", TimeUnit.MINUTES);
        UNITS.put("h", TimeUnit.HOURS);
        UNITS.put("hour", TimeUnit.HOURS);
        UNITS.put("hours", TimeUnit.HOURS);
        UNITS.put("d", TimeUnit.DAYS);
        UNITS.put("day", TimeUnit.DAYS);
        UNITS.put("days", TimeUnit.DAYS);
    }
}

